<?php
if (!defined('ABSPATH')) exit;

add_action('admin_enqueue_scripts', function($hook){
    if ($hook !== 'plugins.php') return;

    $plugin_file    = plugin_basename(AWP_PLUGIN_FILE);
    $deact_pattern = 'plugin=' . rawurlencode($plugin_file);

    wp_add_inline_style('common', '
    .wawp-deact-backdrop {
        position: fixed;
        inset: 0;
        background-color: rgba(0, 0, 0, 0.5);
        backdrop-filter: blur(4px);
        z-index: 100000;
        display: none;
    }

    .wawp-deact-modal {
        position: fixed;
        inset: 0;
        display: none;
        z-index: 100001;
        align-items: center;
        justify-content: center;
    }

    .wawp-deact-card {
        background-color: #ffffff;
        border: 1px solid #e0e0e0;
        border-radius: 12px; 
        max-width: 580px; 
        width: 90%;
        box-shadow: 0 16px 48px rgba(0, 0, 0, 0.25); 
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
    }

    .wawp-deact-card .hd {
        padding: 20px 24px;
        border-bottom: 1px solid #f0f0f0;
        font-size: 1.25em; 
        font-weight: 600;
        color: #333333;
    }

    .wawp-deact-card .bd {
        padding: 24px;
        max-height: 60vh;
        overflow-y: auto;
    }

    .wawp-deact-card .description {
        font-size: 0.9em;
        color: #666666;
        margin-bottom: 16px;
    }

    .wawp-deact-card .ft {
        padding: 16px 24px;
        border-top: 1px solid #f0f0f0;
        display: flex;
        gap: 12px;
        justify-content: flex-end;
    }

    .wawp-deact-card .opt {
        margin: 10px 0;
        font-size: 1em;
        cursor: pointer;
        display: block;
        user-select: none;
    }

    .wawp-deact-card .opt input[type=radio] {
        margin-right: 10px;
        accent-color: #0073aa;
        transform: scale(1.1);
    }

    .wawp-deact-card .opt-other {
        margin-top: 8px;
        padding-left: 28px;
    }

    .wawp-deact-card .opt-other input[type=text] {
        width: 100%;
        padding: 8px 10px;
        border: 1px solid #dddddd;
        border-radius: 6px;
        box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.07);
        transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
    }

    .wawp-deact-card .opt-other input[type=text]:focus {
        outline: none;
        border-color: #0073aa;
        box-shadow: 0 0 0 2px rgba(0, 115, 170, 0.25);
    }

    .button {
        font-weight: 500;
        border-radius: 6px;
        padding: 8px 16px;
    }

    .button-primary {
        background-color: #d63638; 
        border-color: #c92f31;
        color: #ffffff;
        transition: background-color 0.15s ease-in-out;
    }

    .button-primary:hover {
        background-color: #e04a4c;
    }

    .button-secondary {
        background-color: #f7f7f7;
        border-color: #cccccc;
        color: #333333;
    }

    .button-secondary:hover {
        background-color: #f0f0f0;
    }
    ');

    wp_register_script('wawp-deact', false, [], false, true);
    wp_enqueue_script('wawp-deact');

    wp_add_inline_script('wawp-deact', '
    (function($){
        var selector = \'a[href*="plugins.php?action=deactivate"][href*="' . esc_js($deact_pattern) . '"]\';
        var originalHref = null;

        var $backdrop = $("<div class=\'wawp-deact-backdrop\'></div>").appendTo("body");
        var $modal = $(
            "<div class=\'wawp-deact-modal\' role=\'dialog\' aria-modal=\'true\'>" +
            "  <div class=\'wawp-deact-card\'>" +
            "    <div class=\'hd\'>Quick feedback before deactivating Wawp?</div>" +
            "    <div class=\'bd\'>" +
            "        <p class=\'description\'>Choose a reason (optional) — it really helps us improve.</p>" +
            "        <label class=\'opt\'>" +
            "          <input type=\'radio\' name=\'wawp_reason\' value=\'I am just testing/temporary\'> I am just testing / temporary" +
            "        </label>" +
            "        <label class=\'opt\'>" +
            "          <input type=\'radio\' name=\'wawp_reason\' value=\'Found a bug / not working\'> Found a bug / not working" +
            "        </label>" +
            "        <label class=\'opt\'>" +
            "          <input type=\'radio\' name=\'wawp_reason\' value=\'Missing a feature I need\'> Missing a feature I need" +
            "        </label>" +
            "        <label class=\'opt\'>" +
            "          <input type=\'radio\' name=\'wawp_reason\' value=\'Too complex / hard to use\'> Too complex / hard to use" +
            "        </label>" +
            "        <label class=\'opt\'>" +
            "          <input type=\'radio\' name=\'wawp_reason\' value=\'Switched to another plugin\'> Switched to another plugin" +
            "        </label>" +
            "        <label class=\'opt\'>" +
            "          <input type=\'radio\' name=\'wawp_reason\' value=\'other\'> Other" +
            "        </label>" +
            "        <div class=\'opt-other\' style=\'display:none\'>" +
            "          <input type=\'text\' class=\'regular-text\' id=\'wawp_other_text\' placeholder=\'Type your reason...\' />" +
            "        </div>" +
            "    </div>" +
            "    <div class=\'ft\'>" +
            "      <button type=\'button\' class=\'button button-secondary\' id=\'wawp_cancel\'>Cancel</button>" +
            "      <button type=\'button\' class=\'button\' id=\'wawp_skip\'>Deactivate without feedback</button>" +
            "      <button type=\'button\' class=\'button button-primary\' id=\'wawp_submit\'>Submit & Deactivate</button>" +
            "    </div>" +
            "  </div>" +
            "</div>"
        ).appendTo("body");

        $(document).on("click", selector, function(e){
            e.preventDefault();
            originalHref = this.href;
            $backdrop.show(); $modal.css("display","flex");
        });

        $modal.on("change", "input[name=wawp_reason]", function(){
            if (this.value === "other") { $(".opt-other",$modal).slideDown(120); }
            else { $(".opt-other",$modal).slideUp(120); }
        });

        $("#wawp_cancel").on("click", function(){
            $modal.hide(); $backdrop.hide(); originalHref=null;
        });
        $("#wawp_skip").on("click", function(){
            if (originalHref) window.location = originalHref;
        });
        $("#wawp_submit").on("click", function(){
            var val = $modal.find("input[name=wawp_reason]:checked").val() || "";
            var other = (val==="other") ? $("#wawp_other_text").val() : "";
            $.post(ajaxurl, {
                action:"wawp_save_deactivation_reason",
                _wpnonce:"' . wp_create_nonce('wawp_deact_survey') . '",
                reason: val,
                other_text: other
            }).always(function(){
                if (originalHref) window.location = originalHref;
            });
        });
    })(jQuery);
    ');
});

add_action('wp_ajax_wawp_save_deactivation_reason', function(){
    check_ajax_referer('wawp_deact_survey');

    $reason = isset($_POST['reason']) ? sanitize_text_field(wp_unslash($_POST['reason'])) : '';
    $other  = isset($_POST['other_text']) ? sanitize_text_field(wp_unslash($_POST['other_text'])) : '';

    if ($reason === 'other' && $other !== '') {
        $reason = 'Other: ' . $other;
    }
    update_option('wawp_last_deactivation_reason', [
        'reason' => $reason ?: '',
        'ts'     => current_time('mysql'),
    ], false);

    wp_send_json_success();
});