<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'Wawp_Abandoned_Carts' ) ) {

    class Wawp_Abandoned_Carts {
        private $option_name = 'wawp_abandoned_cart_settings';
        public $notifications;
        public function __construct() {
        if ( ! get_option('awp_abandoned_carts_enabled', 1) ) {
        return; 
    }
    require_once AWP_PLUGIN_DIR . 'includes/class-wawp-abandoned-cart-notifications.php';
    $this->notifications = new Wawp_Abandoned_Cart_Notifications();
            add_action( 'init', array( $this, 'cleanup_empty_records' ) );
            add_action( 'init', array( $this, 'init_session' ) );
            add_action( 'wp', array( $this, 'capture_ip_user_agent' ) );
            add_action( 'woocommerce_cart_updated', array( $this, 'cart_updated' ) );
            add_action( 'woocommerce_checkout_update_order_review', array( $this, 'checkout_update_order_review' ), 10, 1 );
            add_action( 'woocommerce_thankyou', array( $this, 'order_thankyou' ) );
            add_action( 'wp_ajax_wac_update_status', array( $this, 'update_status' ) );
            add_action( 'wp_ajax_nopriv_wac_update_status', array( $this, 'update_status' ) );
            add_action( 'wp_ajax_wac_track_page', array( $this, 'track_page' ) );
            add_action( 'wp_ajax_nopriv_wac_track_page', array( $this, 'track_page' ) );
            add_action( 'wp_ajax_wac_capture_billing_fields', array( $this, 'capture_billing_fields' ) );
            add_action( 'wp_ajax_nopriv_wac_capture_billing_fields', array( $this, 'capture_billing_fields' ) );
            add_action( 'wp_ajax_pnp_save_phone_number', array( $this, 'save_phone_number' ) );
            add_action( 'wp_ajax_nopriv_pnp_save_phone_number', array( $this, 'save_phone_number' ) );
            add_action( 'woocommerce_add_to_cart', array( $this, 'woocommerce_add_to_cart_callback' ), 10, 6 );
            add_action( 'woocommerce_remove_cart_item', array( $this, 'track_removed_from_cart' ), 10, 2 );
            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
            add_action( 'wp_footer', array( $this, 'add_popup' ) );
            add_action( 'wp_footer', array( $this, 'add_phone_number_to_checkout' ), 20 );
            add_filter( 'woocommerce_checkout_get_value', array( $this, 'prefill_checkout_fields' ), 10, 2 );
            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_custom_scripts' ) );
            add_action( 'wp_loaded', array( $this, 'restore_abandoned_cart' ) );
            add_action( 'wp_login', array( $this, 'handle_user_login' ), 10, 2 );
            add_action( 'user_register', array( $this, 'handle_user_register' ) );
            add_action( 'admin_init', array( $this, 'handle_settings_save' ) );
        }
        
        public function is_bot() {
            if ( empty( $_SERVER['HTTP_USER_AGENT'] ) ) {
                return false;
            }
            $ua = strtolower( $_SERVER['HTTP_USER_AGENT'] );
            $bots = array( 'bot', 'crawl', 'slurp', 'spider', 'mediapartners', 'facebookexternalhit', 'httpclient', 'twitterbot', 'bingpreview' );
            foreach ( $bots as $b ) {
                if ( strpos( $ua, $b ) !== false ) {
                    return true;
                }
            }
            return false;
        }

        public function get_status_color( $status ) {
            $status = strtolower( $status );
            switch ( $status ) {
                case 'new':
                    return '#007bff';
                case 'potential customer':
                    return '#fd7e14';
                case 'shopping':
                    return '#ffedbf';
                case 'purchased':
                    return '#28a745';
                case 'returning customer':
                    return '#6c757d'; // Grey for returning customer
                case 'wp user':
                    return '#17a2b8'; // Light blue for WP user
                case 'online':
                    return '#007bff'; // Blue for online
                case 'online - recovered':
                    return '#20c997'; // Teal for online - recovered
                default:
                    return '#6c757d';
            }
        }

		public function get_ip_country_code( $ip ) {
			if ( empty( $ip ) ) {
				return '';
			}

			$transient_key = 'wawp_ip_geo_' . md5( $ip );
			$cached_country_code = get_transient( $transient_key );
			if ( false !== $cached_country_code ) {
				return $cached_country_code; 
			}

			$url = 'http://ip-api.com/json/' . $ip . '?fields=status,countryCode';
			$response = wp_remote_get( $url, array( 'timeout' => 5 ) );

			if ( is_wp_error( $response ) ) {
				set_transient( $transient_key, '', HOUR_IN_SECONDS ); 
				return '';
			}

			$body = wp_remote_retrieve_body( $response );
			$data = json_decode( $body, true );
			$country_code = '';

			if ( isset( $data['status'] ) && 'success' === $data['status'] && ! empty( $data['countryCode'] ) ) {
				$country_code = strtolower( $data['countryCode'] );
			}
			
			set_transient( $transient_key, $country_code, DAY_IN_SECONDS );

			return $country_code;
		}

		public function add_history_event( $type, $data ) {
			if ( ! session_id() ) { session_start(); }
			if ( empty( $_SESSION['wac_session'] ) ) { return; }
			global $wpdb;
			$table = $wpdb->prefix . 'wawp_abandoned_carts';
			$row = $wpdb->get_row( $wpdb->prepare( "SELECT page_history FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
			$history = array();
			if ( $row && $row->page_history ) {
				$decoded = json_decode( $row->page_history, true );
				if ( is_array( $decoded ) ) {
					$history = $decoded;
				}
			}

			if ( 'cart_add' === $type && ! empty( $history ) ) {
				$last_event = end( $history );
				
				if ( isset( $last_event['type'] ) && 'cart_add' === $last_event['type'] &&
					isset( $last_event['timestamp'] ) && ( time() - $last_event['timestamp'] < 3 ) &&
					isset( $last_event['data']['name'] ) && isset( $data['name'] ) && $last_event['data']['name'] === $data['name'] &&
					isset( $last_event['data']['price'] ) && isset( $data['price'] ) && $last_event['data']['price'] == $data['price'] )
				{
					return; 
				}
			}

			$history[] = array(
				'type'      => $type,
				'data'      => $data,
				'timestamp' => time(),
			);
			$wpdb->update( $table, array( 'page_history' => wp_json_encode( $history ) ), array( 'session_id' => $_SESSION['wac_session'] ) );
		}

        public function woocommerce_add_to_cart_callback( $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data ) {
            if ( ! session_id() ) { session_start(); }
            if ( empty( $_SESSION['wac_session'] ) ) { return; }
            $session_id = $_SESSION['wac_session'];
            $product = wc_get_product( $variation_id ? $variation_id : $product_id );
            if ( $product ) {
                global $wpdb;
                $table = $wpdb->prefix . 'wawp_abandoned_carts';
                $row = $wpdb->get_row( $wpdb->prepare( "SELECT id, cart_contents, cart_total, contact_details FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $session_id ) );
                
                $cart_items = $row ? maybe_unserialize( $row->cart_contents ) : [];
                if (!is_array($cart_items)) {
                    $cart_items = [];
                }

                $contact_details = $row ? maybe_unserialize( $row->contact_details ) : [];
                if (!is_array($contact_details)) {
                    $contact_details = [];
                }

                $cart_total = $row ? (float) $row->cart_total : 0.0;

                $cart_items[] = array(
                    'product_id'   => $product_id,
                    'variation_id' => $variation_id,
                    'quantity'     => $quantity,
                    'name'         => $product->get_name(),
                    'price'        => $product->get_price()
                );
                $cart_total += $product->get_price() * $quantity;
                $this->insert_or_update( $session_id, get_current_user_id(), maybe_serialize( $contact_details ), '', maybe_serialize( $cart_items ), $cart_total, 'shopping' );
                
                $this->add_history_event( 'cart_add', array(
                    'link'  => $product->get_permalink(),
                    'name'  => $product->get_name(),
                    'price' => $product->get_price(),
                    'qty'   => $quantity,
                ) );

                $updated_row = $wpdb->get_row( $wpdb->prepare( "SELECT id FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $session_id ) );
                if($updated_row){
                    $this->notifications->schedule_notifications_for_cart($updated_row->id, 'abandoned_cart');
                }
            }
        }
        public function track_removed_from_cart( $cart_item_key, $cart ) {
            if ( ! session_id() ) { session_start(); }
            if ( empty( $_SESSION['wac_session'] ) ) { return; }
            $item = $cart->removed_cart_contents[ $cart_item_key ] ?? null;
            if ( ! $item ) { return; }
            $product_id = $item['product_id'] ?? 0;
            $variation_id = $item['variation_id'] ?? 0;
            $quantity = $item['quantity'] ?? 1;
            $product = wc_get_product( $variation_id ? $variation_id : $product_id );
            if ( ! $product ) { return; }
            $this->add_history_event( 'cart_remove', array(
                'link'  => $product->get_permalink(),
                'name'  => $product->get_name(),
                'price' => wc_price( $product->get_price() ),
                'qty'   => $quantity,
            ) );
        }
        
		public function handle_user_login( $user_login, $user ) {
        if ( ! session_id() ) { session_start(); }
        if ( empty( $_SESSION['wac_session'] ) || ! $user ) { return; }

        global $wpdb;
        $table = $wpdb->prefix . 'wawp_abandoned_carts';
        $session_id = $_SESSION['wac_session'];
        $user_id = $user->ID;

        $guest_row = $wpdb->get_row( $wpdb->prepare( 
            "SELECT * FROM $table WHERE session_id = %s AND (user_id IS NULL OR user_id = 0) ORDER BY id DESC LIMIT 1", 
            $session_id 
        ) );

        if ( ! $guest_row ) {
            return;
        }

        $user_row = $wpdb->get_row( $wpdb->prepare(
            "SELECT * FROM $table WHERE user_id = %d AND status <> 'purchased' ORDER BY id DESC LIMIT 1",
            $user_id
        ));

        if ( $user_row ) {
            $guest_cart = maybe_unserialize($guest_row->cart_contents);
            if (!is_array($guest_cart)) $guest_cart = [];

            $user_cart = maybe_unserialize($user_row->cart_contents);
            if (!is_array($user_cart)) $user_cart = [];

            $merged_cart = $user_cart;
            foreach($guest_cart as $guest_item) {
                $found = false;
                foreach($merged_cart as &$merged_item) {
                    if ($merged_item['product_id'] == $guest_item['product_id'] && $merged_item['variation_id'] == $guest_item['variation_id']) {
                        $merged_item['quantity'] += $guest_item['quantity'];
                        $found = true;
                        break;
                    }
                }
                if (!$found) {
                    $merged_cart[] = $guest_item;
                }
            }

            $guest_history = json_decode($guest_row->page_history, true);
            if (!is_array($guest_history)) $guest_history = [];
            
            $user_history = json_decode($user_row->page_history, true);
            if (!is_array($user_history)) $user_history = [];

            $merged_history = array_merge($user_history, $guest_history);
            usort($merged_history, function($a, $b) {
                return ($a['timestamp'] ?? 0) <=> ($b['timestamp'] ?? 0);
            });
            $wpdb->update($table, 
                [
                    'cart_contents' => maybe_serialize($merged_cart),
                    'cart_total' => $guest_row->cart_total + $user_row->cart_total,
                    'page_history' => wp_json_encode($merged_history),
                    'updated_at' => current_time('mysql')
                ],
                ['id' => $user_row->id]
            );
            $wpdb->delete($table, ['id' => $guest_row->id]);

        } else {
            $update_data = [
                'user_id' => $user_id,
                'status' => 'WP User'
            ];
            $guest_contact = maybe_unserialize($guest_row->contact_details);
            if (!is_array($guest_contact)) $guest_contact = [];

            $user_meta_contact = [
                'billing_first_name' => get_user_meta( $user_id, 'billing_first_name', true ),
                'billing_last_name'  => get_user_meta( $user_id, 'billing_last_name', true ),
                'billing_email'      => $user->user_email,
                'billing_phone'      => get_user_meta( $user_id, 'billing_phone', true ),
            ];

            $merged_contact = array_merge($guest_contact, array_filter($user_meta_contact));
            $update_data['contact_details'] = maybe_serialize($merged_contact);

            $wpdb->update($table, $update_data, ['id' => $guest_row->id]);
        }

        $this->add_history_event( 'user_login', 'User logged in: ' . $user->user_login );
    }

        public function handle_user_register( $user_id ) {
            if ( ! session_id() ) { session_start(); }
            if ( empty( $_SESSION['wac_session'] ) ) { return; }
            $user = get_userdata( $user_id );
            $this->add_history_event( 'user_signup', 'User signed up: ' . $user->user_login . ' (' . $user->user_email . ')' );
        }

        public function enqueue_scripts() {
            wp_enqueue_script('pnp-popup-script', AWP_PLUGIN_URL . 'assets/js/popup.js', ['jquery'], '1.0', true);
            wp_enqueue_style('pnp-popup-style', AWP_PLUGIN_URL . 'assets/css/popup.css', [], AWP_PLUGIN_VERSION);

            $ajax_script = 'var ajaxurl="' . admin_url( 'admin-ajax.php' ) . '";';
            $success_icon_url = AWP_PLUGIN_URL . 'assets/img/success.gif';
            $success_title = __( 'Excellent!', 'awp' );
            $success_message = __( 'You can now browse our website better.', 'awp' );
            $ajax_script .= 'var successIconUrl="' . $success_icon_url . '";';
            $ajax_script .= 'var successTitle="' . $success_title . '";';
            $ajax_script .= 'var successMessage="' . $success_message . '";';
            wp_add_inline_script( 'pnp-popup-script', $ajax_script, 'before' );
            
            $options = get_option( 'wawp_abandoned_cart_settings', array() );
            $popupSettings = array(
                'enablePopup'         => isset( $options['enable_popup'] ) && (int) $options['enable_popup'] === 1,
                'popupTitle'          => isset( $options['popup_title'] ) ? $options['popup_title'] : __( 'Add your WhatsApp Number', 'awp' ),
                'popupDescription'    => isset( $options['popup_description'] ) ? $options['popup_description'] : __( 'To get a better experience with our website.', 'awp' ),
                'popupDisplay'        => isset( $options['popup_display'] ) ? $options['popup_display'] : 'both',
                'popupWhere'          => isset( $options['popup_where'] ) ? $options['popup_where'] : 'all',
                'popupExcludePages'   => isset( $options['popup_exclude_pages'] ) ? (array) $options['popup_exclude_pages'] : array(),
                'triggerCart'         => isset( $options['popup_trigger_cart'] ) && (int) $options['popup_trigger_cart'] === 1,
                'triggerExit'         => isset( $options['popup_trigger_exit'] ) && (int) $options['popup_trigger_exit'] === 1,
                'closeHideDuration'   => isset( $options['popup_close_hide_duration'] ) ? (int) $options['popup_close_hide_duration'] : 300,
                'popupInitialDelay'  => isset( $options['popup_initial_delay'] ) ? (int) $options['popup_initial_delay'] : 0,
            );
            wp_localize_script( 'pnp-popup-script', 'popupSettings', $popupSettings );
        }
        public function add_popup() {
            $options = get_option( 'wawp_abandoned_cart_settings', array() );
            $enable_popup = isset( $options['enable_popup'] ) ? (int) $options['enable_popup'] : 1;
            $popup_display = isset( $options['popup_display'] ) ? $options['popup_display'] : 'both';
            $popup_where = isset( $options['popup_where'] ) ? $options['popup_where'] : 'all';
            $popup_exclude_pages = isset( $options['popup_exclude_pages'] ) ? (array) $options['popup_exclude_pages'] : array();

            if ( ! $enable_popup ) { return; }

            $show_for_user = false;
            if ( is_user_logged_in() ) {
                if ( $popup_display === 'both' || $popup_display === 'logged_in' ) {
                    $billing_phone = get_user_meta( get_current_user_id(), 'billing_phone', true );
                    if ( empty( $billing_phone ) ) {
                        $show_for_user = true;
                    }
                }
            } else {
                if ( $popup_display === 'both' || $popup_display === 'guest' ) {
                    if ( ( ! isset( $_COOKIE['New_phone'] ) || empty( $_COOKIE['New_phone'] ) ) && ( ! isset( $_SESSION['login_your_whatsapp'] ) || empty( $_SESSION['login_your_whatsapp'] ) ) ) {
                        global $wpdb;
                        $table = $wpdb->prefix . 'wawp_abandoned_carts';
                        $row = null;
                        if ( isset( $_SESSION['wac_session'] ) ) {
                            $row = $wpdb->get_row( $wpdb->prepare( "SELECT contact_details FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
                        }
                        if ( $row && ! empty( $row->contact_details ) ) {
                            $contact_details = maybe_unserialize( $row->contact_details );
                            if ( is_array( $contact_details ) && ! empty( $contact_details['billing_phone'] ) ) {
                              
                            } else {
                                $show_for_user = true;
                            }
                        } else {
                            $show_for_user = true;
                        }
                    }
                }
            }

            if ( ! $show_for_user ) { return; }

            if ( $popup_where === 'exclude' && is_page( $popup_exclude_pages ) ) {
                return;
            }

            $popup_title = isset( $options['popup_title'] ) ? esc_html( $options['popup_title'] ) : esc_html__( 'Add your WhatsApp Number', 'awp' );
            $popup_description = isset( $options['popup_description'] ) ? esc_html( $options['popup_description'] ) : esc_html__( 'To get a better experience with our website.', 'awp' );
            ?>
            <div id="pnp-popup" class="pnp-popup-overlay" style="display:none;">
                <div class="pnp-popup-content">
                    <span class="pnp-close" aria-label="<?php esc_attr_e( 'Close popup', 'awp' ); ?>">&times;</span>
                    <div class="pnp-popup-body">
                        <h2 class="pnp-popup-title"><?php echo $popup_title; ?></h2>
                        <p class="pnp-popup-des"><?php echo $popup_description; ?></p>
                        <div class="pnp-input-wrapper">
                            <input type="tel" class="input-text" name="billing_phone" id="billing_phone_popup" placeholder="" value="" autocomplete="tel">
                        </div>
                        <p id="phone-check-message" class="pnp-message pnp-success" style="display:none;"><?php esc_html_e( 'You are already a member.', 'awp' ); ?> <a href="/login"><?php esc_html_e( 'Log in', 'awp' ); ?></a></p>
                        <p id="pnp-error-message" class="pnp-message pnp-error" style="display:none;"></p>
                        <button id="pnp-save-phone" class="pnp-button">
                            <span class="button-text"><?php esc_html_e( 'Save', 'awp' ); ?></span>
                            <span class="loading-spinner" style="display:none;"></span>
                        </button>
                    </div>
                    <div class="pnp-success-state" style="display:none;">
                        <img src="<?php echo esc_url( AWP_PLUGIN_URL . 'assets/img/success.gif' ); ?>" alt="Success" class="success-icon">
                        <h2 class="pnp-popup-title"><?php esc_html_e( 'Excellent!', 'awp' ); ?></h2>
                        <p class="pnp-popup-des"><?php esc_html_e( 'You can now browse our website better.', 'awp' ); ?></p>
                        <button id="pnp-close-success" class="pnp-button"><?php esc_html_e( 'Continue browsing', 'awp' ); ?></button>
                    </div>
                </div>
            </div>
            <?php
        }

        public function save_phone_number() {
            if ( isset( $_POST['phone_number'] ) && ! empty( $_POST['phone_number'] ) ) {
                if ( ! session_id() ) { session_start(); }
                $phone_number = sanitize_text_field( $_POST['phone_number'] );
                $user_id = get_current_user_id();
                $contact_details = array();
                global $wpdb;
                $table = $wpdb->prefix . 'wawp_abandoned_carts';

                if ( $user_id ) {
                    $existing_phone = get_user_meta( $user_id, 'billing_phone', true );
                    if ( $existing_phone === $phone_number ) {
                        wp_send_json_success( array( 'message' => __( 'Phone number already registered.', 'awp' ), 'status' => 'exists' ) );
                        return;
                    }
                    update_user_meta( $user_id, 'billing_phone', $phone_number );
                    update_user_meta( $user_id, 'awp_user_phone', $phone_number );
                    $_SESSION['login_your_whatsapp'] = $phone_number;
                    
                    $row = $wpdb->get_row( $wpdb->prepare( "SELECT id, contact_details FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
                    if ( $row && ! empty( $row->contact_details ) ) {
                        $contact_details = maybe_unserialize( $row->contact_details );
                        if ( ! is_array( $contact_details ) ) { $contact_details = array(); }
                    }
                    $contact_details['billing_phone'] = $phone_number;
                } else {
                    if ( isset( $_COOKIE['New_phone'] ) && $_COOKIE['New_phone'] === $phone_number ) {
                        wp_send_json_success( array( 'message' => __( 'Phone number already saved in cookies.', 'awp' ), 'status' => 'exists' ) );
                        return;
                    }
                    setcookie( 'New_phone', $phone_number, time() + ( 86400 * 30 ), "/" );
                    $row = $wpdb->get_row( $wpdb->prepare( "SELECT id, contact_details FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
                    if ( $row && ! empty( $row->contact_details ) ) {
                        $contact_details = maybe_unserialize( $row->contact_details );
                        if ( ! is_array( $contact_details ) ) { $contact_details = array(); }
                    }
                    $contact_details['billing_phone'] = $phone_number;
                }
                $_SESSION['pnp_phone_registered'] = true;
                $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), maybe_serialize( $contact_details ), '', '', 0.0, 'potential customer' );
                $this->notifications->schedule_notifications_for_cart($cart_row->id, 'potential_customer');
                $cart_row = $wpdb->get_row( $wpdb->prepare( "SELECT id FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );

                if ($cart_row) {
                    $notification_options = get_option('wawp_abandoned_cart_notification_settings', []);
                    $notification_sequence = $notification_options['potential_customer']['notifications'] ?? [];
                
                    $sequence_uses_coupon = false;
                    foreach ($notification_sequence as $settings) {
                        if (!empty($settings['enable']) && !empty($settings['use_coupon'])) {
                            $sequence_uses_coupon = true;
                            break;
                        }
                    }
                
                    if ($sequence_uses_coupon) {
                        $coupon_code = $this->notifications->generate_coupon_code($cart_row->id, $notification_options['coupon_settings'] ?? []);
                        if (!empty($coupon_code)) {
                            $wpdb->update($table, ['coupon_code' => $coupon_code], ['id' => $cart_row->id]);
                        }
                    }
                
                    $this->notifications->schedule_notifications_for_cart($cart_row->id, 'potential_customer');
                }
                wp_send_json_success( array( 'message' => __( 'Phone number saved successfully.', 'awp' ), 'status' => 'saved' ) );
            } else {
                wp_send_json_error( array( 'message' => __( 'Phone number is required.', 'awp' ) ) );
            }
        }

        public function add_phone_number_to_checkout() {
            if ( ! is_user_logged_in() && ( isset( $_COOKIE['New_phone'] ) || isset( $_SESSION['login_your_whatsapp'] ) ) ) {
                $billing_phone = isset( $_SESSION['login_your_whatsapp'] ) ? $_SESSION['login_your_whatsapp'] : $_COOKIE['New_phone'];
                ?>
                <script type="text/javascript">
                document.addEventListener('DOMContentLoaded', function(){
                    var NewPhone = "<?php echo esc_js( $billing_phone ); ?>";
                    var billingPhoneField = document.getElementById('billing_phone');
                    if ( billingPhoneField && billingPhoneField.value === '' ) {
                        billingPhoneField.value = NewPhone;
                    }
                });
                </script>
                <?php
            }
        }

    public function parse_user_agent( $ua ) {
        $b = 'Unknown';
        $o = 'Unknown';
        $d = 'Desktop';
        if ( preg_match( '/android/i', $ua ) ) {
            $o = 'Android';
            $d = 'Mobile';
        } elseif ( preg_match( '/iphone/i', $ua ) ) {
            $o = 'iOS';
            $d = 'Mobile';
        } elseif ( preg_match( '/ipad/i', $ua ) ) {
            $o = 'iOS';
            $d = 'Tablet';
        } elseif ( preg_match( '/windows|win32/i', $ua ) ) {
            $o = 'Windows';
        } elseif ( preg_match( '/macintosh|mac os x/i', $ua ) ) {
            $o = 'Mac';
        } elseif ( preg_match( '/linux/i', $ua ) ) {
        
            $o = 'Linux';
        }

        if ( preg_match( '/MSIE/i', $ua ) && ! preg_match( '/Opera/i', $ua ) ) { $b = 'Internet Explorer'; }
        elseif ( preg_match( '/Firefox/i', $ua ) ) { $b = 'Firefox'; }
        elseif ( preg_match( '/Edg/i', $ua ) ) { $b = 'Edge'; }
        elseif ( preg_match( '/Chrome/i', $ua ) ) { $b = 'Chrome'; }
        elseif ( preg_match( '/Safari/i', $ua ) ) { $b = 'Safari'; }
        elseif ( preg_match( '/Opera/i', $ua ) ) { $b = 'Opera'; }
        return array( $b, $o, $d );
    }

        public function get_browser_icon( $browser ) {
            $icons_url = AWP_PLUGIN_URL . 'assets/icons/browsers/';
            
            $browser_map = [
                'chrome'  => 'chrome.svg',
                'firefox' => 'firefox.svg',
                'safari'  => 'safari.svg',
                'edge'    => 'edge.svg',
                'opera'   => 'opera.svg',
                'msie'    => 'msie.svg',
            ];
            
            $icon_filename = 'globe.svg';
            $browser_lower = strtolower( $browser );
            
            foreach ( $browser_map as $key => $file ) {
                if ( strpos( $browser_lower, $key ) !== false ) {
                    $icon_filename = $file;
                    break;
                }
            }
            
            $icon_path = $icons_url . $icon_filename;
            $svg_icon = '<img src="' . esc_url( $icon_path ) . '" alt="' . esc_attr( $browser ) . '" width="16" height="16">';
            
            return $svg_icon . esc_html( $browser );
        }
        public function get_os_icon( $os ) {
            $icons_url = AWP_PLUGIN_URL . 'assets/icons/os/';
            
            $os_map = [
                'windows' => 'windows.svg',
                'mac'     => 'mac.svg',
                'linux'   => 'linux.svg',
                'android' => 'android.svg',
                'ios'     => 'ios.svg',
            ];
            
            $icon_filename = 'hdd.svg';
            $os_lower = strtolower( $os );
            
            foreach ( $os_map as $key => $file ) {
                if ( strpos( $os_lower, $key ) !== false ) {
                    $icon_filename = $file;
                    break;
                }
            }
            
            $icon_path = $icons_url . $icon_filename;
            $svg_icon = '<img src="' . esc_url( $icon_path ) . '" alt="' . esc_attr( $os ) . '" width="16" height="16">';
            
            return $svg_icon . esc_html( $os );
        }

        public function get_device_icon( $device ) {
            $icons_url = AWP_PLUGIN_URL . 'assets/icons/devices/';
            
            $device_map = [
                'mobile' => 'mobile.png',
                'tablet' => 'tablet.png',
            ];
            
            $icon_filename = 'desktop.png';
            $device_lower = strtolower( $device );
            
            foreach ( $device_map as $key => $file ) {
                if ( strpos( $device_lower, $key ) !== false ) {
                    $icon_filename = $file;
                    break;
                }
            }
            
            $icon_path = $icons_url . $icon_filename;
            $svg_icon = '<img src="' . esc_url( $icon_path ) . '" alt="' . esc_attr( $device ) . '" width="16" height="16">';
            
            return $svg_icon . esc_html( $device );
        }

		public function insert_or_update( $session_id, $user_id = 0, $contact = '', $loc = '', $contents = '', $total = 0.0, $status = '', $browser = '', $os = '', $device = '', $order_id = '', $page_history = NULL, $screen_size = '' ) {
			global $wpdb;
			$table = $wpdb->prefix . 'wawp_abandoned_carts';
			$row = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table WHERE session_id = %s ORDER BY id DESC LIMIT 1", $session_id ) );
			if ( is_user_logged_in() ) {
				$user_id = get_current_user_id();
				$user_meta = array(
					'billing_first_name' => get_user_meta( $user_id, 'billing_first_name', true ),
					'billing_last_name'  => get_user_meta( $user_id, 'billing_last_name', true ),
					'billing_email'      => get_user_meta( $user_id, 'billing_email', true ),
					'billing_phone'      => get_user_meta( $user_id, 'billing_phone', true ),
					'billing_company'    => get_user_meta( $user_id, 'billing_company', true ),
					'billing_country'    => get_user_meta( $user_id, 'billing_country', true ),
					'billing_address_1'  => get_user_meta( $user_id, 'billing_address_1', true ),
					'billing_address_2'  => get_user_meta( $user_id, 'billing_address_2', true ),
					'billing_city'       => get_user_meta( $user_id, 'billing_city', true ),
					'billing_state'      => get_user_meta( $user_id, 'billing_state', true ),
					'billing_postcode'   => get_user_meta( $user_id, 'billing_postcode', true )
				);
				if ( empty( $contact ) ) {
					$contact = maybe_serialize( $user_meta );
				} else {
					$existingContact = maybe_unserialize( $contact );
					if ( ! is_array( $existingContact ) ) { $existingContact = array(); }
					foreach ( $user_meta as $key => $value ) {
						if ( empty( $existingContact[ $key ] ) && ! empty( $value ) ) {
							$existingContact[ $key ] = $value;
						}
					}
					$contact = maybe_serialize( $existingContact );
				}
				if ( strtolower( $status ) === 'new' || empty( $status ) ) {
					$status = 'returning customer';
				}
			}
			$data = array();
			$data['session_id'] = $session_id;
			if ( $user_id ) {
				$data['user_id'] = $user_id;
			} elseif ( $row && $row->user_id ) {
				$data['user_id'] = $row->user_id;
			}
			if ( $contact !== '' ) {
				$data['contact_details'] = $contact;
			} elseif ( $row && ! empty( $row->contact_details ) ) {
				$data['contact_details'] = $row->contact_details;
			}
			if ( $loc !== '' ) {
				$data['location'] = $loc;
			} elseif ( $row && ! empty( $row->location ) ) {
				$data['location'] = $row->location;
			}
			if ( $contents !== '' ) {
				$data['cart_contents'] = $contents;
			} elseif ( $row && ! empty( $row->cart_contents ) ) {
				$data['cart_contents'] = $row->cart_contents;
			}
			if ( $total !== 0.0 ) {
				$data['cart_total'] = $total;
			} elseif ( $row && isset( $row->cart_total ) ) {
				$data['cart_total'] = $row->cart_total;
			}
			if ( $status !== '' ) {
				$data['status'] = $status;
			} elseif ( $row && ! empty( $row->status ) ) {
				$data['status'] = $row->status;
			}
			if ( $order_id !== '' ) {
				$data['order_id'] = $order_id;
			} elseif ( $row && ! empty( $row->order_id ) ) {
				$data['order_id'] = $row->order_id;
			}
			if ( $browser !== '' ) {
				$data['browser'] = $browser;
			} elseif ( $row && ! empty( $row->browser ) ) {
				$data['browser'] = $row->browser;
			}
			if ( $os !== '' ) {
				$data['os'] = $os;
			} elseif ( $row && ! empty( $row->os ) ) {
				$data['os'] = $row->os;
			}
			if ( $device !== '' ) {
				$data['device'] = $device;
			} elseif ( $row && ! empty( $row->device ) ) {
				$data['device'] = $row->device;
			}
			if ( $screen_size !== '' ) {
				$data['screen_size'] = $screen_size;
			} elseif ( $row && ! empty( $row->screen_size ) ) {
				$data['screen_size'] = $row->screen_size;
			}
			if ( $page_history !== NULL ) {
				$data['page_history'] = $page_history;
			} elseif ( $row && ! empty( $row->page_history ) ) {
				$data['page_history'] = $row->page_history;
			}
			$data['updated_at'] = current_time( 'mysql' );
			if ( $row ) {
				$wpdb->update( $table, $data, array( 'id' => $row->id ) );
			} else {
				if ( empty( $data['status'] ) ) {
					$data['status'] = 'new';
				}
				$data['created_at'] = current_time( 'mysql' );
				$wpdb->insert( $table, $data );
			}
		}

    public function cleanup_empty_records() {
        $settings = get_option( 'wawp_abandoned_cart_settings' );
        if ( ! isset( $settings['enable_data_cleaner'] ) || $settings['enable_data_cleaner'] != 1 ) {
            return;
        }
        if ( ! session_id() ) {
            session_start();
        }
        if ( ! isset( $_SESSION['wac_cleanup_counter'] ) ) {
            $_SESSION['wac_cleanup_counter'] = 1;
        } else {
            $_SESSION['wac_cleanup_counter']++;
        }
        if ( $_SESSION['wac_cleanup_counter'] >= 3 ) {
            global $wpdb;
            $table = $wpdb->prefix . 'wawp_abandoned_carts';
            $rows_new = $wpdb->get_results( "SELECT id, contact_details, location, cart_contents FROM $table WHERE status = 'new'" );
            if ( $rows_new ) {
                foreach ( $rows_new as $row_new ) {
                    $cd = maybe_unserialize( $row_new->contact_details );
                    $emptyContact = true;
                    if ( is_array( $cd ) ) {
                        if ( ! empty( $cd['billing_first_name'] ) && ! empty( $cd['billing_last_name'] ) &&
                            ! empty( $cd['billing_email'] ) && ! empty( $cd['billing_phone'] ) ) {
                            $emptyContact = false;
                        }
                    }
                    $emptyCart = empty( $row_new->cart_contents );
                    if ( $emptyContact && $emptyCart && ! empty( $row_new->location ) ) {
                        $match = $wpdb->get_row( $wpdb->prepare(
                            "SELECT id FROM $table WHERE location = %s AND status = 'purchased' LIMIT 1",
                            $row_new->location
                        ) );
                        if ( $match ) {
                            $wpdb->update( $table, array( 'status' => 'Returning customer' ), array( 'id' => $row_new->id ) );
                        }
                    }
                }
            }
            $sql = "DELETE FROM $table
                WHERE 
                (
                    (location IS NULL OR location = '')
                    AND (
                        contact_details IS NULL
                        OR contact_details = ''
                        OR contact_details = 'a:0:{}'
                        OR contact_details = 'N;'
                        OR (contact_details NOT LIKE '%billing_email%' AND contact_details NOT LIKE '%billing_phone%')
                    )
                )
                OR
                (
                    (location IS NOT NULL AND location <> '')
                    AND (
                        contact_details IS NULL
                        OR contact_details = ''
                        OR contact_details = 'a:0:{}'
                        OR contact_details = 'N;'
                    )
                    AND (
                        cart_contents IS NULL
                        OR cart_contents = ''
                        OR cart_contents = 'a:0:{}'
                    )
                    AND (
                        page_history IS NULL
                        OR page_history = ''
                        OR page_history = '[]'
                    )
                )";
            $wpdb->query( $sql );
            $duplicate_groups = $wpdb->get_results("
                SELECT GROUP_CONCAT(id) AS ids, MAX(id) AS keep_id
                FROM $table
                WHERE status = 'shopping'
                GROUP BY contact_details, location, cart_contents
                HAVING COUNT(*) > 1
            ");
            if ( $duplicate_groups ) {
                foreach ( $duplicate_groups as $group ) {
                    $ids = explode( ',', $group->ids );
                    $keep_id = $group->keep_id;
                    $delete_ids = array_diff( $ids, array( $keep_id ) );
                    if ( ! empty( $delete_ids ) ) {
                        $delete_ids_imploded = implode( ',', array_map( 'intval', $delete_ids ) );
                        $wpdb->query( "DELETE FROM $table WHERE id IN ($delete_ids_imploded)" );
                    }
                }
            }
            $rows_new = $wpdb->get_results("
                SELECT id, contact_details
                FROM $table
                WHERE status = 'new'
                AND contact_details <> ''
            ");
            if ( $rows_new ) {
                foreach ( $rows_new as $new_row ) {
                    $contact_new = $new_row->contact_details;
                    $purchased = $wpdb->get_row( $wpdb->prepare("
                        SELECT id FROM $table
                        WHERE status = 'purchased'
                        AND contact_details = %s
                        LIMIT 1
                    ", $contact_new) );
                    if ( $purchased ) {
                        $wpdb->update( $table, array( 'status' => 'Returning customer' ), array( 'id' => $new_row->id ) );
                    }
                }
            }

            $rows_all = $wpdb->get_results("SELECT id, contact_details, status FROM $table WHERE status <> 'purchased' AND contact_details <> ''");
            $groups = array();
            foreach ( $rows_all as $row ) {
                $data = maybe_unserialize( $row->contact_details );
                $name = '';
                $contact = '';
                    $billing = '';
                if ( is_array( $data ) ) {
                    $first = isset( $data['billing_first_name'] ) ? strtolower( trim( $data['billing_first_name'] ) ) : '';
                    $last  = isset( $data['billing_last_name'] ) ? strtolower( trim( $data['billing_last_name'] ) ) : '';
                    $name = $first . ' ' . $last;
                    $email = isset( $data['billing_email'] ) ? strtolower( trim( $data['billing_email'] ) ) : '';
                    $phone = isset( $data['billing_phone'] ) ? strtolower( trim( $data['billing_phone'] ) ) : '';
                    $contact = $email . ' ' . $phone;
                    $billing = '';
                    $billing .= isset( $data['billing_address_1'] ) ? strtolower( trim( $data['billing_address_1'] ) ) : '';
                    $billing .= isset( $data['billing_address_2'] ) ? ' ' . strtolower( trim( $data['billing_address_2'] ) ) : '';
                    $billing .= isset( $data['billing_city'] ) ? ' ' . strtolower( trim( $data['billing_city'] ) ) : '';
                    $billing .= isset( $data['billing_state'] ) ? ' ' . strtolower( trim( $data['billing_state'] ) ) : '';
                    $billing .= isset( $data['billing_postcode'] ) ? ' ' . strtolower( trim( $data['billing_postcode'] ) ) : '';
                    $billing .= isset( $data['billing_country'] ) ? ' ' . strtolower( trim( $data['billing_country'] ) ) : '';
                }
                $key = $name . '|' . $contact . '|' . $billing . '|' . strtolower( trim( $row->status ) );
                $groups[ $key ][] = $row->id;
            }
            foreach ( $groups as $key => $ids ) {
                if ( count( $ids ) > 1 ) {
                    rsort( $ids );
                    $keep = array_shift( $ids );
                    $ids_to_delete = implode( ',', array_map( 'intval', $ids ) );
                    $wpdb->query( "DELETE FROM $table WHERE id IN ($ids_to_delete)" );
                }
            }

            $wpdb->query( "
                DELETE FROM $table
                WHERE
                    (
                        location IS NULL OR location = ''
                        OR browser IS NULL OR browser = ''
                        OR os IS NULL OR os = ''
                        OR device IS NULL OR device = ''
                    )
                    AND status <> 'purchased'
            " );

            $purchased_rows = $wpdb->get_results( "SELECT location, contact_details FROM $table WHERE status = 'purchased' AND location <> ''" );
            if ( $purchased_rows ) {
                foreach ( $purchased_rows as $p_row ) {
                    $p_contact = $p_row->contact_details;
                    $p_location = $p_row->location;
                    $wpdb->query( $wpdb->prepare(
                        "UPDATE $table SET contact_details = %s WHERE location = %s AND status <> 'purchased'",
                        $p_contact, $p_location
                    ) );
                }
            }

            $_SESSION['wac_cleanup_counter'] = 0;
        }
    }

    public function init_session() {
        if ( is_user_logged_in() && current_user_can( 'manage_options' ) ) {
            return;
        }
        if ( $this->is_bot() ) {
            return;
        }
        if ( ! session_id() ) {
            session_start();
        }
        global $wpdb;
        $table = $wpdb->prefix . 'wawp_abandoned_carts';
        if ( isset( $_COOKIE['wac_session'] ) && ! empty( $_COOKIE['wac_session'] ) ) {
            $_SESSION['wac_session'] = $_COOKIE['wac_session'];
            $existing = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table WHERE session_id = %s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
            if ( $existing && ( 'purchased' === $existing->status || ! empty( $existing->order_id ) ) ) {
                $_SESSION['wac_session'] = uniqid( 'wac_', true );
                setcookie( 'wac_session', $_SESSION['wac_session'], time() + ( 365 * 24 * 60 * 60 ), COOKIEPATH, COOKIE_DOMAIN );
                $all_time = get_option( 'wawp_all_time_visits', 0 );
                update_option( 'wawp_all_time_visits', ++$all_time );
                $copied_contact = $existing->contact_details;
                $copied_contents = $existing->cart_contents;
                $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), $copied_contact, '', '', 0.0, 'Returning customer' );
                $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), $copied_contact, '', $copied_contents, 0.0, 'Returning customer' );
            } else {
                $current_status = $existing ? strtolower( $existing->status ) : 'new';
                if ( $current_status === 'new' ) {
                    $new_status = 'online';
                } elseif ( in_array( $current_status, array( 'potential customer', 'shopping' ) ) ) {
                    $new_status = $current_status;
                } else {
                    $new_status = 'online - recovered';
                }
                $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), '', '', '', 0.0, $new_status );
            }
            if ( is_user_logged_in() ) {
                $purchased = $wpdb->get_row( $wpdb->prepare( "SELECT id FROM $table WHERE user_id = %d AND status = 'purchased' LIMIT 1", get_current_user_id() ) );
                if ( ! $purchased && $existing && strtolower( $existing->status ) === 'returning customer' ) {
                    $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), $existing->contact_details, $existing->location, $existing->cart_contents, $existing->cart_total, 'wp user' );
                }
            }
        } else {
            $_SESSION['wac_session'] = uniqid( 'wac_', true );
            setcookie( 'wac_session', $_SESSION['wac_session'], time() + ( 365 * 24 * 60 * 60 ), COOKIEPATH, COOKIE_DOMAIN );
            $all_time = get_option( 'wawp_all_time_visits', 0 );
            update_option( 'wawp_all_time_visits', ++$all_time );
            $copied_contact = '';
            $copied_contents = '';
            $status = 'new';
            $ip = $_SERVER['REMOTE_ADDR'] ?? '';
            $cc = $this->get_ip_country_code( $ip );
            $location_value = $cc ? ( $ip . '|' . $cc ) : $ip;
            $user_id = get_current_user_id();
            if ( $user_id ) {
                $found = $wpdb->get_row( $wpdb->prepare(
                    "SELECT * FROM $table WHERE user_id = %d AND contact_details <> '' AND contact_details IS NOT NULL ORDER BY id DESC LIMIT 1",
                    $user_id
                ) );
                if ( $found ) {
                    $copied_contact = $found->contact_details;
                    $copied_contents = $found->cart_contents;
                    if ( 'purchased' === $found->status ) {
                        $status = 'returned_customer';
                    }
                }
            }

            if ( is_user_logged_in() && $user_id ) {
                $purchased = $wpdb->get_row( $wpdb->prepare( "SELECT id FROM $table WHERE user_id = %d AND status = 'purchased' LIMIT 1", $user_id ) );
                if ( ! $purchased ) {
                    $status = 'wp user';
                }
            }
            
            if ( ( empty( $copied_contact ) || 'a:0:{}' === $copied_contact || 'N;' === $copied_contact ) && isset( $_COOKIE['New_phone'] ) && ! empty( $_COOKIE['New_phone'] ) ) {
                
                $phone_from_cookie = sanitize_text_field( $_COOKIE['New_phone'] );
                $contact_details_from_cookie = [
                    'billing_phone' => $phone_from_cookie,
                ];
                $copied_contact = maybe_serialize( $contact_details_from_cookie );
            
                if ( 'new' === $status ) {
                    $status = 'potential customer';
                }
            }
            $this->insert_or_update( $_SESSION['wac_session'], $user_id, $copied_contact, $location_value, $copied_contents, 0.0, $status );
        }
    }
        public function capture_ip_user_agent() {
            if ( ! empty( $_SESSION['wac_session'] ) ) {
                $ip = $_SERVER['REMOTE_ADDR'] ?? '';
                if ( $ip ) {
                    $cc = $this->get_ip_country_code( $ip );
                    $location_value = $cc ? ( $ip . '|' . $cc ) : $ip;
                    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
                    list( $b, $o, $d ) = $this->parse_user_agent( $ua );
                    $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), '', $location_value, '', 0.0, '', $b, $o, $d );
                }
            }
        }
        public function cart_updated() {
            if ( ! empty( $_SESSION['wac_session'] ) ) {
                global $wpdb;
                $table = $wpdb->prefix . 'wawp_abandoned_carts';
                $session_id = $_SESSION['wac_session'];
                $row = $wpdb->get_row( $wpdb->prepare( "SELECT id, cart_contents, contact_details, status FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $session_id ) );
                $oldCart = $row ? maybe_unserialize( $row->cart_contents ) : [];
                if (!is_array($oldCart)) { $oldCart = []; }
                
                $cart_items = WC()->cart->get_cart();
                $newCart = array();
                $total = 0.0;
                foreach ( $cart_items as $item ) {
                    $pid = $item['product_id'] ?? 0;
                    $vid = $item['variation_id'] ?? 0;
                    $qty = $item['quantity'] ?? 1;
                    $product = wc_get_product( $vid ? $vid : $pid );
                    if ( $product ) {
                        $newCart[] = array(
                            'product_id'   => $pid,
                            'variation_id' => $vid,
                            'quantity'     => $qty,
                            'name'         => $product->get_name(),
                            'price'        => $product->get_price()
                        );
                        $total += $product->get_price() * $qty;
                    }
                }
                $mapOld = array();
                if ( is_array( $oldCart ) ) {
                    foreach ( $oldCart as $oc ) {
                        $key = $oc['product_id'] . '|' . $oc['variation_id'];
                        $mapOld[ $key ] = $oc;
                    }
                }
                $mapNew = array();
                foreach ( $newCart as $nc ) {
                    $key = $nc['product_id'] . '|' . $nc['variation_id'];
                    $mapNew[ $key ] = $nc;
                }
                foreach ( $mapNew as $k => $nc ) {
                    $newQty = $nc['quantity'];
                    $oldQty = isset( $mapOld[ $k ] ) ? $mapOld[ $k ]['quantity'] : 0;
                    if ( $newQty > $oldQty ) {
                        $diff = $newQty - $oldQty;
                        $this->add_history_event( 'cart_add', array(
                            'link'  => wc_get_product( $nc['variation_id'] ?: $nc['product_id'] )->get_permalink(),
                            'name'  => $nc['name'],
                            'price' => $nc['price'],
                            'qty'   => $diff,
                        ) );
                    } elseif ( $newQty < $oldQty ) {
                        $diff = $oldQty - $newQty;
                        $this->add_history_event( 'cart_remove', array(
                            'link'  => wc_get_product( $nc['variation_id'] ?: $nc['product_id'] )->get_permalink(),
                            'name'  => $nc['name'],
                            'price' => $nc['price'],
                            'qty'   => $diff,
                        ) );
                    }
                }
                foreach ( $mapOld as $k => $oc ) {
                    if ( ! isset( $mapNew[ $k ] ) && $oc['quantity'] > 0 ) {
                        $this->add_history_event( 'cart_remove', array(
                            'link'  => wc_get_product( $oc['variation_id'] ?: $oc['product_id'] )->get_permalink(),
                            'name'  => $oc['name'],
                            'price' => $oc['price'],
                            'qty'   => $oc['quantity'],
                        ) );
                    }
                }
                $contact_details = $row ? maybe_unserialize( $row->contact_details ) : [];
                if (!is_array($contact_details)) { $contact_details = []; }

                if ( empty( $newCart ) && $total == 0.0 ) {
                    $current_status = $row && isset( $row->status ) ? strtolower( $row->status ) : 'new';
                    $status = ( ! empty( $contact_details ) && $current_status === 'potential customer' ) ? 'potential customer' : 'new';
                    $this->insert_or_update( $session_id, get_current_user_id(), maybe_serialize( $contact_details ), '', '', 0.0, $status );
                } else {
                    $this->insert_or_update( $session_id, get_current_user_id(), maybe_serialize( $contact_details ), '', maybe_serialize( $newCart ), $total, 'shopping' );
                }
            }
        }

        public function checkout_update_order_review( $post_data ) {
            if ( ! session_id() ) { session_start(); }
            if ( empty( $_SESSION['wac_session'] ) ) { return; }
            parse_str( $post_data, $fields );
            $billing_data = array();
            foreach ( $fields as $key => $val ) {
                if ( strpos( $key, 'billing_' ) === 0 ) {
                    $billing_data[ $key ] = sanitize_text_field( $val );
                }
            }
            if ( ! empty( $billing_data ) ) {
                $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), maybe_serialize( $billing_data ), '', '', 0.0, '' );
                $provided_fields = array();
                $possible_fields = array(
                    'billing_first_name' => 'First Name',
                    'billing_last_name'  => 'Last Name',
                    'billing_email'      => 'Email',
                    'billing_address_1'  => 'Address 1',
                    'billing_address_2'  => 'Address 2',
                    'billing_city'       => 'City',
                    'billing_state'      => 'State',
                    'billing_postcode'   => 'Postcode',
                    'billing_country'    => 'Country'
                );
                foreach ( $possible_fields as $key => $label ) {
                    if ( isset( $billing_data[ $key ] ) && $billing_data[ $key ] !== '' ) {
                        $provided_fields[] = $label . ': ' . $billing_data[ $key ];
                    }
                }
                if ( ! empty( $provided_fields ) ) {
                    $message = 'User began checkout by entering: ' . implode( ', ', $provided_fields );
                    $this->add_history_event( 'begin_checkout', $message );
                } else {
                    $this->add_history_event( 'begin_checkout', 'User began checkout with no billing details entered' );
                }
                $user_id = get_current_user_id();
                if ( $user_id > 0 ) {
                    foreach ( $billing_data as $field_key => $field_value ) {
                        update_user_meta( $user_id, $field_key, $field_value );
                    }
                }
            }
            
        }

        public function order_thankyou( $order_id ) {
            if ( ! empty( $_SESSION['wac_session'] ) ) {
                global $wpdb;
                $table = $wpdb->prefix . 'wawp_abandoned_carts';
                $row = $wpdb->get_row( $wpdb->prepare( "SELECT id, cart_contents, cart_total, status FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
                $cart_total = $row ? $row->cart_total : 0.0;
                $contents   = $row ? $row->cart_contents : '';
                if ( $row && 'purchased' === $row->status && ! empty( $row->order_id ) ) {
                    $order = wc_get_order( $row->order_id );
                    if ( $order ) {
                        $cart_total = $order->get_total();
                        $contents = ''; 
                    }
                }
                $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), '', '', $contents, $cart_total, 'purchased', '', '', '', $order_id );
                if($row) {
                    $this->notifications->cancel_all_scheduled_notifications_for_cart($row->id);
                }
            }
        }
        public function update_status() {
            if ( ! session_id() ) { session_start(); }
            if ( empty( $_SESSION['wac_session'] ) ) { wp_die(); }
            $status = isset( $_POST['status'] ) ? sanitize_text_field( $_POST['status'] ) : '';
            if ( $status ) {
                $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), '', '', '', 0.0, $status );
            }
            wp_die();
        }

       public function track_page() {
            if ( ! session_id() ) { session_start(); }
            if ( empty( $_SESSION['wac_session'] ) ) { wp_die(); }
            $page_url       = isset( $_POST['page_url'] ) ? esc_url_raw( $_POST['page_url'] ) : '';
            $page_title     = isset( $_POST['page_title'] ) ? sanitize_text_field( $_POST['page_title'] ) : '';
            $timestamp      = isset( $_POST['timestamp'] ) ? sanitize_text_field( $_POST['timestamp'] ) : time();
            $time_spent     = isset( $_POST['time_spent'] ) ? intval( $_POST['time_spent'] ) : 0;
            $scroll_percent = isset( $_POST['scroll_percent'] ) ? intval( $_POST['scroll_percent'] ) : 0;
            $referrer       = isset( $_POST['referrer'] ) ? esc_url_raw( $_POST['referrer'] ) : '';
            $screen_size    = isset( $_POST['screen_size'] ) ? sanitize_text_field( $_POST['screen_size'] ) : '';

            if ( empty( $page_url ) ) { wp_die(); }

            if ( ! empty( $screen_size ) ) {
                $this->insert_or_update( 
                    $_SESSION['wac_session'],
                    get_current_user_id(),
                    '', '', '', 0.0, '', '', '', '', '', null,
                    $screen_size
                );
            }

            global $wpdb;
            $table = $wpdb->prefix . 'wawp_abandoned_carts';
            $session_id = $_SESSION['wac_session'];
            $row = $wpdb->get_row( $wpdb->prepare( "SELECT page_history FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $session_id ) );
            $history = array();
            if ( $row && ! empty( $row->page_history ) ) {
                $decoded = json_decode( $row->page_history, true );
                if ( is_array( $decoded ) ) {
                    $history = $decoded;
                }
            }
            
            $last_event = end( $history );
            if ( empty( $last_event['data']['url'] ) ) {
                for ( $i = count( $history ) - 1; $i >= 0; $i-- ) {
                    if ( isset( $history[$i]['type'] ) && $history[$i]['type'] === 'page' && ! empty( $history[$i]['data']['url'] ) ) {
                        $last_event = $history[$i];
                        break;
                    }
                }
            }

            if ( $last_event && ( $last_event['type'] === 'page' ) ) {
                $last_url = isset( $last_event['data']['url'] ) ? $last_event['data']['url'] : '';
                if ( $last_url === $page_url ) { wp_die(); }
            }

            $event_data = array(
                'title'          => $page_title,
                'url'            => $page_url,
                'time_spent'     => $time_spent,
                'scroll_percent' => $scroll_percent,
            );
            if ( ! empty( $referrer ) ) {
                $event_data['referrer'] = $referrer;
            }
            $history[] = array(
                'type'      => 'page',
                'data'      => $event_data,
                'timestamp' => $timestamp,
            );
            $wpdb->update( $table, array( 'page_history' => wp_json_encode( $history ) ), array( 'session_id' => $session_id ) );
            wp_die();
        }

        public function enqueue_custom_scripts() {
            if ( is_checkout() ) {
                wp_enqueue_script('wac-custom', AWP_PLUGIN_URL . 'assets/js/wac-custom.js', ['jquery'], '1.0', true);
                wp_localize_script( 'wac-custom', 'wac_params', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
            }
            if ( ! is_admin() ) {
                wp_enqueue_script('wac-track', AWP_PLUGIN_URL . 'assets/js/wac-track.js', ['jquery'], '1.0', true);
                wp_localize_script( 'wac-track', 'wac_track_params', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
            }
        }

        public function capture_billing_fields() {
            if ( ! session_id() ) { session_start(); }
            if ( empty( $_SESSION['wac_session'] ) ) { wp_die(); }
            $billing_data = array();
            foreach ( $_POST as $key => $value ) {
                if ( strpos( $key, 'billing_' ) === 0 ) {
                    $billing_data[ $key ] = sanitize_text_field( trim( $value ) );
                }
            }
            if ( ! empty( $billing_data ) ) {
                $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), maybe_serialize( $billing_data ), '', '', 0.0, '' );
                $provided_fields = array();
                $possible_fields = array(
                    'billing_first_name' => 'First Name',
                    'billing_last_name'  => 'Last Name',
                    'billing_email'      => 'Email',
                    'billing_address_1'  => 'Address 1',
                    'billing_address_2'  => 'Address 2',
                    'billing_city'       => 'City',
                    'billing_state'      => 'State',
                    'billing_postcode'   => 'Postcode',
                    'billing_country'    => 'Country'
                );
                foreach ( $possible_fields as $key => $label ) {
                    if ( isset( $billing_data[ $key ] ) && $billing_data[ $key ] !== '' ) {
                        $provided_fields[] = $label . ': ' . $billing_data[ $key ];
                    }
                }
                if ( ! empty( $provided_fields ) ) {
                    $message = 'User began checkout by entering: ' . implode( ', ', $provided_fields );
                    $this->add_history_event( 'begin_checkout', $message );
                } else {
                    $this->add_history_event( 'begin_checkout', 'User began checkout with no billing details entered' );
                }
                $user_id = get_current_user_id();
                if ( $user_id > 0 ) {
                    foreach ( $billing_data as $field_key => $field_value ) {
                        update_user_meta( $user_id, $field_key, $field_value );
                    }
                }
            }
            
                wp_send_json_success(array('message' => 'Billing data captured successfully.'));
            
        }

        public function maybe_toggle_hide_new() {
            if ( ! current_user_can( 'manage_options' ) ) {
                return;
            }
            if ( isset( $_POST['toggle_hide_new'] ) && check_admin_referer( 'wac_clear_nonce' ) ) {
                $current = get_option( 'wawp_hide_new_rows', '1' );
                $new     = ( $current === '1' ) ? '0' : '1';
                update_option( 'wawp_hide_new_rows', $new );
                echo '<div class="updated notice"><p>' . esc_html__( 'Hide New Status setting toggled.', 'awp' ) . '</p></div>';
            }
        }

    public function admin_page() {
        global $wpdb;
        $table = $wpdb->prefix . 'wawp_abandoned_carts';
        
        $current_status = isset( $_GET['status'] ) ? sanitize_key( $_GET['status'] ) : 'all';
    
        $this->maybe_toggle_hide_new();
        $this->merge_duplicate_sessions_by_rule();
    
        if ( isset( $_POST['wac_clear'] ) && check_admin_referer( 'wac_clear_nonce' ) ) {
            if ( 'selected' === $_POST['wac_clear'] && ! empty( $_POST['wac_clear_ids'] ) && is_array( $_POST['wac_clear_ids'] ) ) {
                $ids = array_map( 'intval', $_POST['wac_clear_ids'] );
                $in  = implode( ',', $ids );
                $wpdb->query( "DELETE FROM $table WHERE id IN ($in)" );
            } elseif ( 'all' === $_POST['wac_clear'] ) {
                $wpdb->query( "DELETE FROM $table" );
            }
            echo '<div class="updated notice"><p>' . esc_html__( 'Record(s) cleared.', 'awp' ) . '</p></div>';
        }
    
        $where_conditions = [];
        
        if ($current_status !== 'all') {
    $db_status = str_replace('_', ' ', $current_status);
    $where_conditions[] = $wpdb->prepare("status = %s", $db_status);
}
    
        $hide_new = get_option('wawp_hide_new_rows', '1');
        if ($hide_new === '1') {
            $where_conditions[] = "status <> 'new'";
        }
        
    
        $admin_users = get_users(array('role' => 'administrator', 'fields' => 'ID'));
        if (!empty($admin_users)) {
            $admin_ids_str = implode(',', array_map('intval', $admin_users));
            $where_conditions[] = "(user_id IS NULL OR user_id NOT IN ($admin_ids_str))";
        }
    
        $where_clause = '';
        if (!empty($where_conditions)) {
            $where_clause = ' WHERE ' . implode(' AND ', $where_conditions);
        }
    
        $current_page = isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;
        $per_page = 50;
        $offset = ( $current_page - 1 ) * $per_page;
    
        $total_items_query = "SELECT COUNT(*) FROM $table" . $where_clause;
        $total_items = $wpdb->get_var($total_items_query);
    
        $data_query = "SELECT * FROM $table" . $where_clause . " ORDER BY id DESC LIMIT %d OFFSET %d";
        $rows = $wpdb->get_results( $wpdb->prepare( $data_query, $per_page, $offset ) );
        
        ?>

            <div class="page-header_row">
                    <div class="page-header">
                        <h2 class="page-title"><?php _e( 'Sessions & User Journey', 'awp' ); ?></h2>
                        <p class="page-title"><?php _e( 'Track user journey, abandoned carts, and more.', 'awp' ); ?></p>
                    </div>
            </div>
<div class="awp-toolbar">
    <div class="live-search-bar">
        <input type="text" id="awp-live-search" placeholder="Live search in any info available on table...">
    </div>
</div>


            <div class="awp-card" style="padding: 0;gap: 0;">
                <div class="card-header_row with-tabs">
    <div class="cart-status-tabs nav-tab-wrapper">
        <?php
$statuses = [
    'all'                  => __('All', 'awp'),
    'potential_customer'   => __('Potential Customer', 'awp'), 
    'shopping'             => __('Shopping', 'awp'),
    'purchased'            => __('Purchased', 'awp'),
    'returning_customer'   => __('Returning Customer', 'awp'), 
];
foreach ($statuses as $status_key => $status_label) {
    $class = ($current_status === $status_key) ? 'nav-tab nav-tab-active' : 'nav-tab';
    $url = add_query_arg([
        'page'        => AWP_MAIN_MENU_SLUG,
        'awp_section' => 'abandoned_carts',       
        'status'      => $status_key,
    ], 'admin.php');
    
    $url = remove_query_arg('paged', $url);

    echo '<a href="' . esc_url($url) . '" class="' . esc_attr($class) . '">' . esc_html($status_label) . '</a>';
}
        ?>
    </div>
    <form method="post" class="btn-group">
        <?php wp_nonce_field( 'wac_clear_nonce' ); ?>
        <button type="submit" name="toggle_hide_new" class="awp-btn secondary" onclick="return confirm('<?php echo esc_js( __( 'Are you sure you want to toggle hiding rows with New status?', 'awp' ) ); ?>');">
            <?php echo ( $hide_new === '1' ) ? __( '<i class="ri-eye-line"></i> Show New Status', 'awp' ) : __( '<i class="ri-eye-off-line"></i> Hide New Status', 'awp' ); ?>
        </button>
        <button type="submit" name="wac_clear" value="all" class="awp-btn delete" onclick="return confirm('<?php echo esc_js( __( 'Are you sure you want to clear ALL records?', 'awp' ) ); ?>');">
            <i class="ri-delete-bin-line"></i> <?php _e( 'Clear All Records', 'awp' ); ?>
        </button>
        <button type="submit" id="wac-clear-selected" name="wac_clear" value="selected" class="awp-btn delete" onclick="return confirm('<?php echo esc_js( __( 'Are you sure you want to clear selected records?', 'awp' ) ); ?>');">
            <i class="ri-delete-bin-2-line"></i> <?php _e( 'Clear Selected', 'awp' ); ?>
        </button>
    </form>
</div>

                <div class="awp-table-container">
                    <table class="awp-table ab-cart-table">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="wac_select_all"></th>
                                <th><?php _e( 'Visitor/User', 'awp' ); ?></th>
                                <th><?php _e( 'Contact Info', 'awp' ); ?></th>
                                <th><?php _e( 'Cart Summary', 'awp' ); ?></th>
                                <th><?php _e( 'Status', 'awp' ); ?></th>
                                <th><?php _e( 'Journey', 'awp' ); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ( $rows ) : ?>
                                <?php foreach ( $rows as $r ) : 
                                    $cd_array = maybe_unserialize( $r->contact_details );
                                    if (!is_array($cd_array)) { $cd_array = []; }
                                    $first_last_name = '';
                                    $user_id_display = '';
                                    $user_label = '';
                                    $billing_id = '';
                                    $ip_link  = '';


                                    if ( $r->user_id > 0 ) {
                                        $user_data = get_userdata( $r->user_id );
                                        $user_label = '<span class="awp-badge user">User</span>';
                                        if ( $user_data ) {
                                            $first_last_name = $user_data->display_name;
                                            $user_id_display = ' <span class="wac-user-id"><a href="' . esc_url( admin_url( 'user-edit.php?user_id=' . $r->user_id ) ) . '" target="_blank">WP ID: ' .'('. esc_html($r->user_id) . ')' .'</a></span>';
                                        }
                                    } else {
                                        $user_label = '<span class="awp-badge guest">Guest</span>';
                                    }

                                    if ( is_array( $cd_array ) ) {
                                        $first = isset( $cd_array['billing_first_name'] ) ? $cd_array['billing_first_name'] : '';
                                        $last  = isset( $cd_array['billing_last_name'] ) ? $cd_array['billing_last_name'] : '';
                                        if ( $first || $last ) {
                                            $first_last_name = trim( $first . ' ' . $last );
                                        }
                                    }

                                    if ( empty($first_last_name) ) {
                                        $first_last_name = 'Unknown';
                                    }
                                    $display_name = '<div class="cart_fullname">' . esc_html( $first_last_name ) . $user_id_display . $user_label . '</div>';

                                    $billing_id .= '<div class="wac-meta">' . esc_html__( 'ID:', 'awp' ) . ' ' . esc_html( $r->id ) . '</div>';
                                    
                                    $user_data =  '<div class="data_group fullname">' . $display_name . ' ' . $billing_id . '</div>';

                                    $country_str = '';
                                    if ( ! empty( $cd_array['billing_country'] ) ) {
                                        $country_code = esc_attr( strtolower( $cd_array['billing_country'] ) );
                                        $country_name = WC()->countries->countries[ strtoupper( $country_code ) ] ?? $country_code;
                                        $flag_url = "https://flagcdn.com/16x12/" . $country_code . ".png";
                                        $country_str .= '<img src="' . esc_url( $flag_url ) . '" alt="' . esc_attr( $country_name ) . '" class="wac-flag-icon">' . esc_html( $country_name ) . '';
                                    }
                                    $device_html = $this->get_device_icon( $r->device );
                                    if ( ! empty( $r->screen_size ) ) {
                                        $device_html .= ' <span class="wac-meta">(' . esc_html( $r->screen_size ) . ')</span>';
                                    }
                                    
                                    $raw_location = (string) $r->location;
                                    $ip_address = $raw_location;
                                    $ip_country = '';
                                    if ( strpos( $raw_location, '|' ) !== false ) {
                                        list( $ip_address, $ip_country ) = explode( '|', $raw_location );
                                        $ip_country = strtolower( $ip_country );
                                    }
                                    $ip_link = '<a href="https://whatismyipaddress.com/ip/' . esc_attr( $ip_address ) . '" target="_blank" class="wac-meta">' . esc_html( $ip_address ) . '</a>';

                                    $contact_str  = '<div class="data_group">'
                                                  . '<div class="wac-detail-item country">' . $country_str . ''. $ip_link .'</div>' 
                                                  . '<div class="wac-detail-item">' . $device_html . '</div>'
                                                  . '<div class="wac-detail-item">' . $this->get_os_icon( $r->os ) . '</div>'
                                                  . '<div class="wac-detail-item">' . $this->get_browser_icon( $r->browser ) . '</div>'
                                                  . '</div>';




                                    $billing_info     = '';
                                    $billing_email    = '';
                                    $billing_wa       = '';
                                    $billing_address  = '';
                                    
                                    if ( ! empty( $cd_array['billing_email'] ) ) {
                                        $billing_email .= '<div class="wac-detail-item"><i class="ri-mail-line"></i><a href="mailto:' . esc_attr( $cd_array['billing_email'] ) . '">' . esc_html( $cd_array['billing_email'] ) . '</a></div>';
                                    }
                                    if ( ! empty( $cd_array['billing_phone'] ) ) {
                                        $clean_phone = preg_replace('/[^0-9]/', '', $cd_array['billing_phone']);
                                        $billing_wa .= '<div class="wac-detail-item"><i class="ri-whatsapp-line"></i><a href="https://api.whatsapp.com/send?phone=' . esc_attr( $clean_phone ) . '" target="_blank">' . esc_html( $cd_array['billing_phone'] ) . '</a></div>';
                                    }
                                    
                                    
                                    if ( ! empty( $cd_array['billing_state'] ) ) {
                                        $state_code = esc_attr( $cd_array['billing_state'] );
                                        $state_name = WC()->countries->get_states( strtoupper( $cd_array['billing_country'] ) )[ $state_code ] ?? $state_code;
                                        $items = [];
                                        if ( ! empty( $cd_array['billing_address_1'] ) ) { $items[] = esc_html( $cd_array['billing_address_1'] ); }
                                        if ( ! empty( $cd_array['billing_address_2'] ) ) { $items[] = esc_html( $cd_array['billing_address_2'] ); }
                                        if ( ! empty( $cd_array['billing_city'] ) )      { $items[] = esc_html( $cd_array['billing_city'] ); }
                                        if ( ! empty( $state_name ) )                     { $items[] = esc_html( $state_name ); }
                                        if ( ! empty( $cd_array['billing_postcode'] ) )  { $items[] = esc_html( $cd_array['billing_postcode'] ); }
                                    
                                        $spans = '';
                                        foreach ( $items as $i => $val ) {
                                            if ( $i > 0 ) {
                                                $spans .= '<span class="wac-sep">, </span>';
                                            }
                                            $spans .= '<span>' . $val . '</span>';
                                        }
                                        $billing_address .= '<div class="wac-detail-item" style="align-items: start;"><i class="ri-map-pin-line" style="margin-top: .125rem;"></i><div class="wac_address">' . $spans . '</div></div>';
                                    }
                                    
                                    $billing_info  = '<div class="data_group">'
                                                  . '<div class="wac-detail-item email">' . $billing_email . '</div>' 
                                                  . '<div class="wac-detail-item whatsapp">' . $billing_wa . '</div>'
                                                  . '<div class="wac-detail-item address">' . $billing_address . '</div>'
                                                  . '</div>';

                                    

                                    $contents_summary = '';
                                    $contents_data = [];
                                    if ( empty( $r->cart_contents ) || $r->cart_contents === 'a:0:{}' ) {
                                        $contents_summary = '<span class="wac-empty-cart">' . esc_html__( 'Empty Cart', 'awp' ) . '</span>';
                                    } else {
                                        $items = maybe_unserialize( $r->cart_contents );
                                        if ( is_array( $items ) && count( $items ) > 0 ) {
                                            $item_count = count($items);
                                            $contents_summary = sprintf( _n( '%d item', '%d items', $item_count, 'awp' ), $item_count );
                                            foreach ( $items as $it ) {
                                                $pid = $it['product_id'] ?? 0;
                                                $vid = $it['variation_id'] ?? 0;
                                                $product = wc_get_product( $vid ? $vid : $pid );
                                                if ( $product ) {
                                                    $product_image_html = $product->get_image(array(40,40));
                                                    preg_match('/<img.*?src="(.*?)".*?alt="(.*?)".*?>/i', $product_image_html, $matches);
                                                    $image_src = $matches[1] ?? '';
                                                    $image_alt = $matches[2] ?? $product->get_name();
                                                    $contents_data[] = [
                                                        'name' => $product->get_name(),
                                                        'qty' => $it['quantity'] ?? 1,
                                                        'price' => wc_price($product->get_price()),
                                                        'link' => $product->get_permalink(),
                                                        'image_src' => $image_src,
                                                        'image_alt' => $image_alt
                                                    ];
                                                }
                                            }
                                        } else {
                                            $contents_summary = '<span class="wac-empty-cart">' . esc_html__( 'Empty Cart', 'awp' ) . '</span>';
                                        }
                                    }
                                    $cart_total = $r->cart_total;
                                    if ( 'purchased' === $r->status && ! empty( $r->order_id ) ) {
                                        $order = wc_get_order( $r->order_id );
                                        if ( $order ) {
                                            $cart_total = $order->get_total();
                                            $contents_data = [];
                                            foreach ( $order->get_items() as $item ) {
                                                $product = $item->get_product();
                                                if ( $product ) {
                                                    $product_image_html = $product->get_image(array(40,40));
                                                    preg_match('/<img.*?src="(.*?)".*?alt="(.*?)".*?>/i', $product_image_html, $matches);
                                                    $image_src = $matches[1] ?? '';
                                                    $image_alt = $matches[2] ?? $product->get_name();
                                                    $contents_data[] = [
                                                        'name' => $product->get_name(),
                                                        'qty' => $item->get_quantity(),
                                                        'price' => wc_price($item->get_total()),
                                                        'link' => $product->get_permalink(),
                                                        'image_src' => $image_src,
                                                        'image_alt' => $image_alt
                                                    ];
                                                }
                                            }
                                            $contents_summary = sprintf( _n( '%d item (Order)', '%d items (Order)', count($contents_data), 'awp' ), count($contents_data) );
                                        }
                                    }
                                    $cart_total_html = wc_price( $cart_total );
                                   
                                    $cart_contents_html = '<div class="wac-cart-summary"><i class="ri-shopping-bag-3-line"></i> ' . $contents_summary . '</div>';
                                    if (!empty($contents_data)) {
                                        $cart_details_json = esc_attr(wp_json_encode($contents_data));
                                        $cart_contents_html .= '<div class="wac-cart-summary"><i class="ri-list-check-2"></i><a href="#" class="wac-view-cart-details" data-cart-details=\'' . $cart_details_json . '\'>' . esc_html__('View Items', 'awp') . '</a></div>';
                                    }

                                    $history = array();
                                    $source = '';
                                    $current = '';
                                    $history_detail = '';
                                    if ( ! empty( $r->page_history ) ) {
                                        $decoded = json_decode( $r->page_history, true );
                                        if ( is_array( $decoded ) ) { $history = $decoded; }
                                    }
                                    if ( is_array( $history ) && count( $history ) > 0 ) {
                                        usort( $history, function( $a, $b ) {
                                            return ( $a['timestamp'] ?? 0 ) - ( $b['timestamp'] ?? 0 );
                                        } );
                                        $first_event = reset( $history );
                                        $current_host = isset( $_SERVER['HTTP_HOST'] ) ? $_SERVER['HTTP_HOST'] : '';
                                        if ( isset( $first_event['data']['referrer'] ) && ! empty( $first_event['data']['referrer'] ) ) {
                                            $ref = $first_event['data']['referrer'];
                                            $ref_host = parse_url( $ref, PHP_URL_HOST );
                                            if ( $ref_host && strtolower( $ref_host ) !== strtolower( $current_host ) ) {
                                                $ref_host_clean = strtolower( $ref_host );
                                                $ref_host_clean = preg_replace( '/^www\./', '', $ref_host_clean );
                                                $ref_host_clean = str_ireplace( array( 'l.facebook.com', 'lm.facebook.com', 'm.facebook.com' ), 'facebook.com', $ref_host_clean );
                                                $icon_url = 'https://www.google.com/s2/favicons?domain=' . urlencode( $ref_host_clean );
                                                $source = '<a href="' . esc_url( $ref ) . '" target="_blank"><img src="' . esc_url( $icon_url ) . '" class="wac-favicon"> ' . esc_html( $ref_host_clean ) . '</a>';
                                            } else {
                                                $source = 'Direct';
                                            }
                                        } else {
                                            $source = 'Direct';
                                        }
                                        if ( empty( $source ) && isset( $first_event['data']['url'] ) ) {
                                            $first_url = $first_event['data']['url'];
                                            $first_host = parse_url( $first_url, PHP_URL_HOST );
                                            if ( ! empty( $first_host ) ) {
                                                $first_host = strtolower( $first_host );
                                                $first_host = preg_replace( '/^www\./', '', $first_host );
                                                $icon_url = 'https://www.google.com/s2/favicons?domain=' . urlencode( $first_host );
                                                $source = '<a href="' . esc_url( $first_url ) . '" target="_blank"><img src="' . esc_url( $icon_url ) . '" class="wac-favicon"> ' . esc_html( $first_event['data']['title'] ?? $first_host ) . '</a>';
                                            } else {
                                                $source = '<a href="' . esc_url( $first_url ) . '" target="_blank">' . esc_html( $first_event['data']['title'] ?? '' ) . '</a>';
                                            }
                                        }

                                        $history_detail = '<div class="wac-timeline">';
                                        foreach ( $history as $ev ) {
                                            $ts = $ev['timestamp'] ?? time();
                                            $timeLabel = date_i18n( 'M d, Y H:i:s', $ts );
                                            $type = $ev['type'] ?? 'page';
                                            $data = $ev['data'] ?? array();
                                            $history_detail .= '<div class="wac-timeline-item">';
                                            if ( 'source' === $type ) {
                                                $icon = '<i class="ri-links-line"></i> ';
                                                $history_detail .= '<div class="history_data">' . $icon . '<strong>Source:</strong> ' . $data['display'] . '</div>';
                                            } elseif ( 'cart_add' === $type ) {
                                                $icon = '<i class="ri-shopping-cart-2-line"></i> ';
                                                $productLink = ! empty( $data['link'] ) ? '<a href="' . esc_url( $data['link'] ) . '" target="_blank">' . esc_html( $data['name'] ) . '</a>' : esc_html( $data['name'] );
                                                $history_detail .= '<div class="history_data">' . $icon . '<strong>Added to Cart:</strong> ' . $productLink . '<span class="wac-meta">('. wc_price( $data['price'] ?? 0 ) . ' x ' . esc_html( $data['qty'] ?? 1 ) .')</span></div>';
                                            } elseif ( 'cart_remove' === $type ) {
                                                $icon = '<i class="ri-delete-bin-5-line"></i> ';
                                                $productLink = ! empty( $data['link'] ) ? '<a href="' . esc_url( $data['link'] ) . '" target="_blank">' . esc_html( $data['name'] ) . '</a>' : esc_html( $data['name'] );
                                                $history_detail .= '<div class="history_data">' . $icon . '<strong>Removed from Cart:</strong> ' . $productLink . '<span class="wac-meta">(' . wc_price( $data['price'] ?? 0 ) . ' x ' . esc_html( $data['qty'] ?? 1) . ')</span></div>';
                                            } elseif ( 'page' === $type ) {
                                                $icon = '<i class="ri-eye-line"></i> ';
                                                $favicon = '';
                                                if ( ! empty( $data['url'] ) ) {
                                                    $page_host = parse_url( $data['url'], PHP_URL_HOST );
                                                    if ( $page_host ) {
                                                        $icon_url = 'https://www.google.com/s2/favicons?domain=' . urlencode( $page_host );
                                                        $favicon = '<img src="' . esc_url( $icon_url ) . '" class="wac-favicon"> ';
                                                    }
                                                    $pageLink = '<a href="' . esc_url( $data['url'] ) . '" target="_blank" class="history_link">' . esc_html( $data['title'] ?? 'Page' ) . '</a>';
                                                } else {
                                                    $pageLink = esc_html( $data['title'] ?? 'Page' );
                                                }
                                                $timeSpent = ( isset( $data['time_spent'] ) && $data['time_spent'] > 60 ) ? round( $data['time_spent'] / 60 ) . ' min' : ( $data['time_spent'] ?? 0 ) . ' sec';
                                                $scrollPercent = esc_html( $data['scroll_percent'] ?? 0 );
                                                $history_detail .= '<div class="history_data">' . $icon . '<strong>Viewed Page:</strong> ' . $favicon . $pageLink . '<span class="wac-meta">(' . $timeSpent . ', Scroll: ' . $scrollPercent . '%)</span></div>';
                                            } elseif ( 'begin_checkout' === $type ) {
                                                $icon = '<i class="ri-shopping-cart-2-fill"></i> ';
                                                $history_detail .= '<div class="history_data">' . $icon . '<strong>Begin Checkout:</strong> ' . esc_html( $data ) . '</div>';
                                            } elseif ( 'user_login' === $type ) {
                                                $icon = '<i class="ri-login-box-line"></i> ';
                                                $history_detail .= '<div class="history_data">' . $icon . '<strong>Logged In:</strong> ' . esc_html( $data ) . '</div>';
                                            } elseif ( 'user_signup' === $type ) {
                                                $icon = '<i class="ri-user-add-line"></i> ';
                                                $history_detail .= '<div class="history_data">' . $icon . '<strong>Signed Up:</strong> ' . esc_html( $data ) . '</div>';
                                            } elseif ( 'order_made' === $type ) {
                                                $icon = '<i class="ri-file-list-3-line"></i> ';
                                                if ( is_array( $data ) ) {
                                                    $order_id = isset( $data['order_id'] ) ? $data['order_id'] : '';
                                                    $total    = isset( $data['total'] ) ? $data['total'] : 0;
                                                    $link     = isset( $data['link'] ) ? $data['link'] : '#';
                                                    $history_detail .= '<div class="history_data">' . $icon . '<strong>Order Made:</strong> <a href="' . esc_url( $link ) . '" target="_blank">Order #' . esc_html( $order_id ) . '</a> - Total: ' . wc_price( $total ) . '</div>';
                                                } else {
                                                    $history_detail .= '<div class="history_data">' . $icon . '<strong>Order Made:</strong> ' . esc_html( $data ) . '</div>';
                                                }
                                            } else {
                                                $icon = '<i class="ri-information-line"></i> ';
                                                $history_detail .= '<div class="history_data">' . $icon . '<strong>Event:</strong> ' . esc_html( $type ) . '</div>';
                                            }
                                            $history_detail .= '<div class="wac-timeline-time">' . esc_html( $timeLabel ) . '</div>';
                                            $history_detail .= '</div>';
                                        }
                                        
                                        $last_page_event = null;
                                        for ( $i = count( $history ) - 1; $i >= 0; $i-- ) {
                                            if ( isset( $history[ $i ]['type'] ) && $history[ $i ]['type'] === 'page' && ! empty( $history[ $i ]['data']['url'] ) ) {
                                                $last_page_event = $history[ $i ];
                                                break;
                                            }
                                        }
                                        if ( $last_page_event ) {
                                            $current_url  = $last_page_event['data']['url'];
                                            $current_host = parse_url( $current_url, PHP_URL_HOST );
                                            if ( ! empty( $current_host ) ) {
                                                $current_host = strtolower( preg_replace( '/^www\./', '', $current_host ) );
                                                $icon_url     = 'https://www.google.com/s2/favicons?domain=' . urlencode( $current_host );
                                                $current      = '<a href="' . esc_url( $current_url ) . '" target="_blank" class="last_link"><img src="' . esc_url( $icon_url ) . '" class="wac-favicon"> ' . esc_html( $last_page_event['data']['title'] ?? $current_host ) . '</a>';
                                            } else {
                                                $current = '<a href="' . esc_url( $current_url ) . '" target="_blank" class="last_link">' . esc_html( $last_page_event['data']['title'] ?? '' ) . '</a>';
                                            }
                                        }
                                        
                                        $last_event = end($history);
                                        $diff = time() - ( $last_event['timestamp'] ?? time() );
                                        $current_label = ( strtolower( $r->status ) === 'purchased' || $diff >= 600 ) ? 'Exit page:' : 'Current:';
                                    } else {
                                        $current_label = 'Current:';
                                    }
                                    $history_extra = '';
                                    if ( is_array( $history ) && count( $history ) > 0 ) {
                                        $first_time = $history[0]['timestamp'] ?? time();
                                        $last_time = end($history)['timestamp'] ?? time();
                                        $total_time_sec = $last_time - $first_time;
                                        $diff = time() - $last_time;

                                        $seconds = $total_time_sec;
                                        $days    = floor($seconds / 86400);
                                        $seconds %= 86400;
                                        $hours   = floor($seconds / 3600);
                                        $seconds %= 3600;
                                        $minutes = floor($seconds / 60);
                                        $seconds %= 60;
                                        
                                        $time_parts = [];
                                        if ($days > 0)    { $time_parts[] = $days . 'd'; }
                                        if ($hours > 0)   { $time_parts[] = $hours . 'h'; }
                                        if ($minutes > 0) { $time_parts[] = $minutes . 'm'; }
                                        if ($seconds > 0 || empty($time_parts)) { $time_parts[] = $seconds . 's'; }
                                        $total_spent_str = implode(' ', $time_parts);
                                        
                                        $user_status = ( $diff < 600 ) 
                                            ? '<span class="wac-online-status"><i class="ri-signal-wifi-line"></i> ' . esc_html__( 'Online', 'awp' ) . '</span>' 
                                            : '<span class="wac-offline-status"><i class="ri-signal-wifi-off-line"></i> ' . esc_html__( 'Left site', 'awp' ) . '</span>';
                                        
                                        $history_extra = '<div class="wac-detail-item"><i class="ri-time-line"></i> ' . esc_html__( 'Start:', 'awp' ) . ' ' . date_i18n( 'M d, Y H:i:s', strtotime( $r->created_at ) ) . '</div><div class="wac-detail-item"><i class="ri-login-box-line"></i> ' . esc_html__( 'Total time:', 'awp' ) . ' ' . $total_spent_str . '</div><div class="wac-detail-item">' . $user_status . '</div>';
                                    }

                                    $notification_status_html = '';
                                    $current_cart_status = strtolower($r->status);
                                    $notification_type = '';
                                    if ($current_cart_status === 'potential customer') {
                                        $notification_type = 'potential_customer';
                                    } elseif ($current_cart_status === 'shopping') {
                                        $notification_type = 'abandoned_cart';
                                    }
                                    if (!empty($notification_type)) {
                                        $notification_options = get_option('wawp_abandoned_cart_notification_settings');
                                        $sequence = $notification_options[$notification_type]['notifications'] ?? [];
                                        $total_count = 0;
                                        if (!empty($sequence) && is_array($sequence)) {
                                            foreach ($sequence as $step) {
                                                if (!empty($step['enable'])) { $total_count++; }
                                            }
                                        }
                                        $log_table = $wpdb->prefix . 'wawp_abandoned_cart_notifications_log';
                                        $sent_count = $wpdb->get_var($wpdb->prepare( "SELECT COUNT(*) FROM {$log_table} WHERE cart_id = %d AND notification_type = %s AND status = 'sent'", $r->id, $notification_type ));
                                        if ($total_count > 0) {
                                            $coupon_display = ! empty( $r->coupon_code ) ? '<div class="wac-coupon-code"><i class="ri-coupon-3-line"></i>' . esc_html( $r->coupon_code ) . '</div>' : '';
                                            $notification_status_html = sprintf( '<div class="wac-notification-progress"><i class="ri-notification-2-line"></i>%s: %d / %d</div>', __('Notifications', 'awp'), $sent_count, $total_count ) . $coupon_display;
                                        }
                                    }
                                    $status_display = ( 'wp' === $r->status ) ? 'New' : $r->status;
                                    $color = $this->get_status_color( $status_display );
                                ?>
                                <tr>
                                    <td><input type="checkbox" name="wac_clear_ids[]" class="wac-clear-id-checkbox" value="<?php echo esc_attr( $r->id ); ?>"></td>
                                    <td class="basic"><?php echo $user_data; ?><?php echo $contact_str; ?></td>
                                    <td><?php echo $billing_info; ?></td>
                                    <td>
                                        <div class="data_group">
                                            <?php echo $cart_contents_html; ?>
                                            <div class="wac-cart-summary"><i class="ri-wallet-line"></i><?php echo $cart_total_html; ?></div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="data_group">
                                            <div class="wac-status-badge <?php echo $status_display; ?>"><?php echo esc_html( ucfirst( $status_display ) ); ?></div>
                                            <?php echo $notification_status_html; ?>
                                            <?php if ( 'purchased' === $r->status && ! empty( $r->order_id ) ) : ?>
                                                <div class="wac-order-link">
                                                    <a href="<?php echo esc_url( admin_url( "post.php?post={$r->order_id}&action=edit" ) ); ?>" target="_blank">
                                                        <i class="ri-file-list-3-line"></i> <?php echo esc_html__( 'Order #', 'awp' ) . esc_html( $r->order_id ); ?>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="data_group">
                                            <span class="wac-detail-item"><?php _e( 'Source:', 'awp' ); ?><span class="wac-detail-item" style="gap: .25rem;"><i class="ri-arrow-left-down-line"></i> <?php echo $source; ?></span></span>
                                            <span class="wac-detail-item"><?php echo esc_html( $current_label ); ?><?php echo $current; ?></span>
                                            <?php echo $history_extra; ?>
                                            <?php if ( ! empty( $history_detail ) ) : ?>
                                                <div class="wac-history-trigger-wrapper">
                                                    <a href="#" class="wac-history-link awp-btn" data-history='<?php echo esc_attr( $history_detail ); ?>'><?php _e( 'View History', 'awp' ); ?></a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <tr><td style="flex: 1;text-align: center;"><?php _e( 'No records found.', 'awp' ); ?></td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="tablenav-pages">
                    <span class="displaying-num"><?php echo $total_items; ?> <?php _e('items', 'awp'); ?></span>
                    <?php
                    $page_links = paginate_links([
                        'base'      => add_query_arg('paged', '%#%'),
                        'format'    => '',
                        'prev_text' => __('&laquo;', 'awp'),
                        'next_text' => __('&raquo;', 'awp'),
                        'total'     => ceil($total_items / $per_page),
                        'current'   => $current_page
                    ]);
            
                    if ($page_links) {
                        echo '<span class="pagination-links">' . $page_links . '</span>';
                    }
                    ?>
                </div>
            </div>


        <div id="wac-history-modal" class="wac-modal" style="display:none;">
            <div class="wac-modal-content">
                <span class="wac-modal-close">&times;</span>
                <h2 class="wac-modal-title"><?php _e( 'Session History', 'awp' ); ?></h2>
                <div id="wac-history-content" class="wac-modal-body"></div>
            </div>
        </div>
        <div id="wac-cart-details-modal" class="wac-modal" style="display:none;">
            <div class="wac-modal-content">
                <span class="wac-modal-close">&times;</span>
                <h2 class="wac-modal-title"><?php _e( 'Cart Details', 'awp' ); ?></h2>
                <div id="wac-cart-details-content" class="wac-modal-body"></div>
            </div>
        </div>
        <?php
    }
        
        public function restore_abandoned_cart() {
            if ( is_admin() ) { return; }
            if ( ! function_exists( 'WC' ) || ! WC()->cart ) { return; }
            if ( ! session_id() ) { session_start(); }
            if ( isset( $_SESSION['cart_restored'] ) && $_SESSION['cart_restored'] === true ) { return; }
            if ( isset( $_SESSION['wac_session'] ) ) {
                global $wpdb;
                $table = $wpdb->prefix . 'wawp_abandoned_carts';
                $row = $wpdb->get_row( $wpdb->prepare( "SELECT cart_contents FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
                if ( $row && ! empty( $row->cart_contents ) ) {
                    $storedCart = maybe_unserialize( $row->cart_contents );
                    if ( is_array( $storedCart ) ) {
                        foreach ( $storedCart as $item ) {
                            $product_id = $item['product_id'] ?? 0;
                            $variation_id = $item['variation_id'] ?? 0;
                            $quantity = $item['quantity'] ?? 1;
                            $exists = false;
                            foreach ( WC()->cart->get_cart() as $cart_item ) {
                                if ( $cart_item['product_id'] == $product_id && $cart_item['variation_id'] == $variation_id ) {
                                    $exists = true;
                                    break;
                                }
                            }
                            if ( ! $exists ) {
                                WC()->cart->add_to_cart( $product_id, $quantity, $variation_id );
                            }
                        }
                        $currentCart = array();
                        $total = 0.0;
                        foreach ( WC()->cart->get_cart() as $cart_item ) {
                            $pid = $cart_item['product_id'] ?? 0;
                            $vid = $cart_item['variation_id'] ?? 0;
                            $qty = $cart_item['quantity'] ?? 1;
                            $product = wc_get_product( $vid ? $vid : $pid );
                            if ( $product ) {
                                $currentCart[] = array(
                                    'product_id'   => $pid,
                                    'variation_id' => $vid,
                                    'quantity'     => $qty,
                                    'name'         => $product->get_name(),
                                    'price'        => $product->get_price()
                                );
                                $total += $product->get_price() * $qty;
                            }
                        }
                        $this->insert_or_update( $_SESSION['wac_session'], get_current_user_id(), '', '', maybe_serialize( $currentCart ), $total, 'shopping' );
                    }
                } else {
                
                    $cart = WC()->cart->get_cart();
                    if ( empty( $cart ) ) {
                        $row = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
                        if ( $row && strtolower( $row->status ) !== 'purchased' ) {
                            $wpdb->update( $table, array( 'cart_contents' => '', 'cart_total' => 0.0 ), array( 'id' => $row->id ) );
                        }
                    }
                }
            }
            $_SESSION['cart_restored'] = true;
        }


        public function merge_duplicate_sessions_by_rule() {
            global $wpdb;
            $table = $wpdb->prefix . 'wawp_abandoned_carts';
            $rows = $wpdb->get_results( "SELECT * FROM $table WHERE contact_details IS NOT NULL AND contact_details <> '' AND location IS NOT NULL AND location <> ''" );
            if ( empty( $rows ) ) { return; }
            $records = array();
            foreach ( $rows as $row ) {
                $cd = maybe_unserialize( $row->contact_details );
                $name = '';
                $contact = '';
                $billing_info = '';
                if ( is_array( $cd ) ) {
                    $first = isset( $cd['billing_first_name'] ) ? trim( strtolower( $cd['billing_first_name'] ) ) : '';
                    $last  = isset( $cd['billing_last_name'] ) ? trim( strtolower( $cd['billing_last_name'] ) ) : '';
                    $name = $first . ' ' . $last;
                    $email = isset( $cd['billing_email'] ) ? trim( strtolower( $cd['billing_email'] ) ) : '';
                    $phone = isset( $cd['billing_phone'] ) ? trim( strtolower( $cd['billing_phone'] ) ) : '';
                    $contact = $email . ' ' . $phone;
                    $address1 = isset( $cd['billing_address_1'] ) ? trim( strtolower( $cd['billing_address_1'] ) ) : '';
                    $address2 = isset( $cd['billing_address_2'] ) ? trim( strtolower( $cd['billing_address_2'] ) ) : '';
                    $city     = isset( $cd['billing_city'] ) ? trim( strtolower( $cd['billing_city'] ) ) : '';
                    $state    = isset( $cd['billing_state'] ) ? trim( strtolower( $cd['billing_state'] ) ) : '';
                    $postcode = isset( $cd['billing_postcode'] ) ? trim( strtolower( $cd['billing_postcode'] ) ) : '';
                    $country  = isset( $cd['billing_country'] ) ? trim( strtolower( $cd['billing_country'] ) ) : '';
                    $billing_info = $address1 . ' ' . $address2 . ' ' . $city . ' ' . $state . ' ' . $postcode . ' ' . $country;
                }
                $location = strtolower( trim( $row->location ) );
                $records[ $row->id ] = array(
                    'id'           => $row->id,
                    'name'         => $name,
                    'contact'      => $contact,
                    'billing_info' => $billing_info,
                    'location'     => $location,
                    'status'       => strtolower( $row->status ),
                    'page_history' => $row->page_history,
                    'order_id'     => $row->order_id,
                    'row'          => $row,
                );
            }
            $groups = array();
            $visited = array();
            $record_ids = array_keys( $records );
            foreach ( $record_ids as $id ) {
                if ( in_array( $id, $visited ) ) { continue; }
                $group = array( $id );
                $visited[] = $id;
                foreach ( $record_ids as $other_id ) {
                    if ( $other_id == $id ) { continue; }
                    if ( in_array( $other_id, $visited ) ) { continue; }
                    $matches = 0;
                    if ( $records[$id]['name'] && $records[$other_id]['name'] && $records[$id]['name'] === $records[$other_id]['name'] ) { $matches++; }
                    if ( $records[$id]['contact'] && $records[$other_id]['contact'] && $records[$id]['contact'] === $records[$other_id]['contact'] ) { $matches++; }
                    if ( $records[$id]['billing_info'] && $records[$other_id]['billing_info'] && $records[$id]['billing_info'] === $records[$other_id]['billing_info'] ) { $matches++; }
                    if ( $records[$id]['location'] && $records[$other_id]['location'] && $records[$id]['location'] === $records[$other_id]['location'] ) { $matches++; }
                    if ( $matches >= 2 ) {
                        $group[] = $other_id;
                        $visited[] = $other_id;
                    }
                }
                $groups[] = $group;
            }
            foreach ( $groups as $group ) {
                if ( count( $group ) <= 1 ) { continue; }
                $hasPurchased = false;
                foreach ( $group as $id ) {
                    if ( $records[$id]['status'] === 'purchased' ) {
                        $hasPurchased = true;
                        break;
                    }
                }
                if ( $hasPurchased ) { continue; }
                $keep = null;
                foreach ( $group as $id ) {
                    if ( $keep === null ) {
                        $keep = $records[$id];
                    } else {
                        if ( $records[$id]['id'] > $keep['id'] ) {
                            $keep = $records[$id];
                        }
                    }
                }
                $mergedHistory = array();
                foreach ( $group as $id ) {
                    $rowHistory = array();
                    if ( $records[$id]['row']->page_history ) {
                        $rowHistory = json_decode( $records[$id]['row']->page_history, true );
                        if ( ! is_array( $rowHistory ) ) {
                            $rowHistory = array();
                        }
                    }
                    $mergedHistory = array_merge( $mergedHistory, $rowHistory );
                }
                usort( $mergedHistory, function( $a, $b ) { return $a['timestamp'] <=> $b['timestamp']; } );
                $wpdb->update( $table, array( 'page_history' => wp_json_encode( $mergedHistory ) ), array( 'id' => $keep['id'] ) );
                $idsToDelete = array();
                foreach ( $group as $id ) {
                    if ( $id != $keep['id'] ) {
                        $idsToDelete[] = $id;
                    }
                }
                if ( ! empty( $idsToDelete ) ) {
                    $idsStr = implode( ',', array_map( 'intval', $idsToDelete ) );
                    $wpdb->query( "DELETE FROM $table WHERE id IN ($idsStr)" );
                }
            }
        }

        public function prefill_checkout_fields( $value, $input ) {
            if ( empty( $value ) ) {
                if ( is_user_logged_in() ) {
                    $user_id = get_current_user_id();
                    $user_meta = get_user_meta( $user_id, $input, true );
                    if ( ! empty( $user_meta ) ) {
                        return $user_meta;
                    }
                } elseif ( isset( $_SESSION['wac_session'] ) ) {
                    global $wpdb;
                    $table = $wpdb->prefix . 'wawp_abandoned_carts';
                    $row = $wpdb->get_row( $wpdb->prepare( "SELECT contact_details FROM $table WHERE session_id=%s ORDER BY id DESC LIMIT 1", $_SESSION['wac_session'] ) );
                    if ( $row && ! empty( $row->contact_details ) ) {
                        $data = maybe_unserialize( $row->contact_details );
                        if ( is_array( $data ) && isset( $data[ $input ] ) ) {
                            return $data[ $input ];
                        }
                    }
                }
            }
            return $value;
        }

    public function handle_settings_save() {
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }

    if ( 'POST' !== $_SERVER['REQUEST_METHOD'] ) {
        return;
    }

    if ( empty($_POST['wawp_ac_settings_nonce']) || ! wp_verify_nonce( $_POST['wawp_ac_settings_nonce'], 'wawp_ac_settings_action' ) ) {
        return;
    }

    $input = $_POST[$this->option_name] ?? [];

    $sanitized_input = [];
    $sanitized_input['enable_popup']              = !empty($input['enable_popup']) ? 1 : 0;
    $sanitized_input['popup_title']               = isset($input['popup_title']) ? sanitize_text_field($input['popup_title']) : '';
    $sanitized_input['popup_description']         = isset($input['popup_description']) ? sanitize_text_field($input['popup_description']) : '';
    $sanitized_input['popup_display']             = in_array($input['popup_display'] ?? '', ['both', 'logged_in', 'guest', 'disabled'], true) ? $input['popup_display'] : 'both';
    $sanitized_input['popup_where']               = in_array($input['popup_where'] ?? '', ['all', 'exclude'], true) ? $input['popup_where'] : 'all';
    $sanitized_input['popup_exclude_pages']       = isset($input['popup_exclude_pages']) ? array_map('intval', (array)$input['popup_exclude_pages']) : [];
    $sanitized_input['enable_data_cleaner']       = !empty($input['enable_data_cleaner']) ? 1 : 0;
    $sanitized_input['popup_trigger_cart']        = !empty($input['popup_trigger_cart']) ? 1 : 0;
    $sanitized_input['popup_trigger_exit']        = !empty($input['popup_trigger_exit']) ? 1 : 0;
    $sanitized_input['popup_close_hide_duration'] = isset($input['popup_close_hide_duration']) ? absint($input['popup_close_hide_duration']) : 300;
    $sanitized_input['popup_initial_delay']       = isset($input['popup_initial_delay']) ? absint($input['popup_initial_delay']) : 0;

    update_option($this->option_name, $sanitized_input);

    add_action('admin_notices', function() {
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__( 'Settings saved successfully!', 'awp' ) . '</p></div>';
    });
    }

        
        public function settings_page_callback() {
                if ( 'POST' === $_SERVER['REQUEST_METHOD'] && !empty($_POST['wawp_ac_settings_nonce']) ) {
        $this->handle_settings_save();
    }
            
            $options = get_option( $this->option_name, array(
                'enable_popup'        => 1,
                'popup_title'         => 'Add your WhatsApp Number',
                'popup_description'   => 'To get a better experience with our website.',
                'popup_display'       => 'both',
                'popup_where'         => 'all',
                'popup_exclude_pages' => array(),
                'enable_data_cleaner' => 1,
                'popup_trigger_cart' => 1,
                'popup_trigger_exit' => 1,
                'popup_close_hide_duration' => 300,
            ) );
            ?>
            <div class="wrap">
                
                    <div class="page-header_row">
                    <div class="page-header">
                      <h2 class="page-title"><?php _e( 'Abandoned Cart Settings', 'awp' ); ?></h2>
                      <p class="page-title"><?php _e( 'Collect phone numbers from your visitors with ease.', 'awp' ); ?></p>
                    </div>
            </div>

                <form method="post" action="">
                    <?php wp_nonce_field( 'wawp_ac_settings_action', 'wawp_ac_settings_nonce' ); ?>
                    
                    <div class="wawp-setting-card">
                        <div class="wawp-setting-header awp-toggle-switch">
                            <div class="card-header">
                                <div class="card-title"><i class="ri-window-line"></i> <?php _e( 'Popup Settings', 'awp' ); ?></div>
                                <p><?php _e('Configure the settings for the abandoned cart popup.', 'awp'); ?></p>
                            </div>
                            <div class="btn-group"><i class="ri-arrow-down-s-line toggled-arrow"></i></div>
                        </div>
                        <div class="wawp-setting-content" style="display: none;">
                            <table class="form-table">
                                <tbody>
                                    <tr>
                                        <th scope="row"><?php _e( 'Enable Popup', 'awp' ); ?></th>
                                        <td>
                                            <label class="awp-switch">
                                                <input type="hidden" name="<?php echo esc_attr( $this->option_name ); ?>[enable_popup]" value="0" />
                                                <input type="checkbox" name="<?php echo esc_attr( $this->option_name ); ?>[enable_popup]" value="1" <?php checked( 1, $options['enable_popup'] ?? 1 ); ?> />
                                                <span class="awp-slider"></span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><?php _e( 'Popup Title', 'awp' ); ?></th>
                                        <td><input type="text" name="<?php echo esc_attr( $this->option_name ); ?>[popup_title]" value="<?php echo esc_attr( $options['popup_title'] ?? '' ); ?>" class="regular-text" /></td>
                                    </tr>
                                     <tr>
                                        <th scope="row"><?php _e( 'Popup Description', 'awp' ); ?></th>
                                        <td><input type="text" name="<?php echo esc_attr( $this->option_name ); ?>[popup_description]" value="<?php echo esc_attr( $options['popup_description'] ?? '' ); ?>" class="regular-text" /></td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><?php _e( 'Display Popup For', 'awp' ); ?></th>
                                        <td>
                                            <select name="<?php echo esc_attr( $this->option_name ); ?>[popup_display]">
                                                <option value="both" <?php selected($options['popup_display'], 'both'); ?>><?php _e( 'Both (Logged in & Guests)', 'awp' ); ?></option>
                                                <option value="logged_in" <?php selected($options['popup_display'], 'logged_in'); ?>><?php _e( 'Logged In Users Only', 'awp' ); ?></option>
                                                <option value="guest" <?php selected($options['popup_display'], 'guest'); ?>><?php _e( 'Guests Only', 'awp' ); ?></option>
                                                <option value="disabled" <?php selected($options['popup_display'], 'disabled'); ?>><?php _e( 'Disabled for All', 'awp' ); ?></option>
                                            </select>
                                        </td>
                                    </tr>
                                     <tr>
                                        <th scope="row"><?php _e( 'Where to Show Popup', 'awp' ); ?></th>
                                                          
                        <td>
                            <p>
                                <label>
                                    <input type="radio" name="<?php echo esc_attr( $this->option_name ); ?>[popup_where]" value="all" <?php checked( $options['popup_where'], 'all' ); ?>>
                                    <?php _e( 'Show on all pages', 'awp' ); ?>
                                </label>
                            </p>
                            <p>
                                <label>
                                    <input type="radio" name="<?php echo esc_attr( $this->option_name ); ?>[popup_where]" value="exclude" <?php checked( $options['popup_where'], 'exclude' ); ?>>
                                    <?php _e( 'Exclude specific pages', 'awp' ); ?>
                                </label>
                            </p>
                        
                            
                            <div class="wawp-exclude-pages-wrapper" style="display: none; margin-top: 10px;">
                                <select id="wawp-popup-exclude-pages" name="<?php echo esc_attr( $this->option_name ); ?>[popup_exclude_pages][]" multiple="multiple" style="width: 100%; max-width: 400px;">
                                    <?php
                                    $pages = get_pages();
                                    foreach ( $pages as $page ) {
                                        $selected = in_array( $page->ID, (array)($options['popup_exclude_pages'] ?? []) ) ? 'selected="selected"' : '';
                                        echo '<option value="' . esc_attr( $page->ID ) . '" ' . $selected . '>' . esc_html( $page->post_title ) . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><?php _e( 'Trigger Popup on Cart', 'awp' ); ?></th>
                                        <td>
                                            <label class="awp-switch">
                                                <input type="hidden" name="<?php echo esc_attr( $this->option_name ); ?>[popup_trigger_cart]" value="0" />
                                                <input type="checkbox" name="<?php echo esc_attr( $this->option_name ); ?>[popup_trigger_cart]" value="1" <?php checked( 1, $options['popup_trigger_cart'] ?? 1 ); ?> />
                                                <span class="awp-slider"></span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><?php _e( 'Trigger Popup on Exit Intent', 'awp' ); ?></th>
                                        <td>
                                            <label class="awp-switch">
                                                <input type="hidden" name="<?php echo esc_attr( $this->option_name ); ?>[popup_trigger_exit]" value="0" />
                                                <input type="checkbox" name="<?php echo esc_attr( $this->option_name ); ?>[popup_trigger_exit]" value="1" <?php checked( 1, $options['popup_trigger_exit'] ?? 1 ); ?> />
                                                <span class="awp-slider"></span>
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row"><?php _e( 'Hide Duration after Close (seconds)', 'awp' ); ?></th>
                                        <td><input type="number" name="<?php echo esc_attr( $this->option_name ); ?>[popup_close_hide_duration]" value="<?php echo esc_attr( $options['popup_close_hide_duration'] ?? 300 ); ?>" class="small-text" /></td>
                                    </tr>
                                    
                                        <tr>
                                            <th scope="row"><?php _e( 'Delay Initial Popup (seconds)', 'awp' ); ?></th>
                                            <td>
                                                <input type="number" name="<?php echo esc_attr( $this->option_name ); ?>[popup_initial_delay]" value="<?php echo esc_attr( $options['popup_initial_delay'] ?? 0 ); ?>" class="small-text" />
                                                <p class="description"><?php _e( 'Wait this many seconds after the page loads before showing the popup. Affects all triggers. Set to 0 to show immediately.', 'awp' ); ?></p>
                                            </td>
                                        </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="wawp-setting-card">
                        <div class="wawp-setting-header awp-toggle-switch">
                            <div class="card-header">
                                <div class="card-title"><i class="ri-database-2-line"></i> <?php _e( 'Data Cleaner Settings', 'awp' ); ?></div>
                                <p><?php _e('Enable the data cleaner to automatically manage and clean up abandoned cart records.', 'awp'); ?></p>
                            </div>
                            <div class="btn-group"><i class="ri-arrow-down-s-line toggled-arrow"></i></div>
                        </div>
                        <div class="wawp-setting-content" style="display: none;">
                            <table class="form-table">
                                <tbody>
                                    <tr>
                                        <th scope="row"><?php _e( 'Enable Data Cleaner', 'awp' ); ?></th>
                                        <td>
                                            <label class="awp-switch">
                                                <input type="hidden" name="<?php echo esc_attr( $this->option_name ); ?>[enable_data_cleaner]" value="0" />
                                                <input type="checkbox" name="<?php echo esc_attr( $this->option_name ); ?>[enable_data_cleaner]" value="1" <?php checked( 1, $options['enable_data_cleaner'] ?? 1 ); ?> />
                                                <span class="awp-slider"></span>
                                            </label>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php submit_button(); ?>
                </form>
            </div>
            <?php
        }

    }
}

