<?php
if (!defined('ABSPATH')) exit;

add_action('rest_api_init', function () {
    register_rest_route('awp/v1', '/lookup-carrier', [
        'methods'  => 'GET',
        'permission_callback' => '__return_true',
        'callback' => function (WP_REST_Request $req) {
            $e164 = $req->get_param('e164');
            if (!$e164) {
                return new WP_Error('bad_request', 'Missing e164', ['status' => 400]);
            }
            if (defined('AWP_PLUGIN_DIR')) {
                $autoload = AWP_PLUGIN_DIR . 'vendor/autoload.php';
                if (file_exists($autoload)) {
                    require_once $autoload;
                }
            }

            if (!class_exists('\libphonenumber\PhoneNumberUtil')) {
                return new WP_REST_Response(['carrier' => null], 200);
            }

            try {
                $phoneUtil = \libphonenumber\PhoneNumberUtil::getInstance();
                $carrier   = \libphonenumber\PhoneNumberToCarrierMapper::getInstance();
                $num       = $phoneUtil->parse($e164, null);
                $name      = $carrier->getNameForNumber($num, 'en');

                return new WP_REST_Response(['carrier' => $name ?: null], 200);
            } catch (\Throwable $e) {
                return new WP_REST_Response(['carrier' => null], 200);
            }
        },
    ]);
});
