<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AWP_Admin_Notices {

	public static function require_online_instance( $awp_instances, string $title = 'No online instance (Whatsapp Number)' ) : bool {

    $senders_opts = get_option( 'awp_senders_enabled', [ 'wa' => 1 ] );
    $is_wa_sender_enabled = ! empty( $senders_opts['wa'] );

    if ( ! $is_wa_sender_enabled ) {
        return true;
    }

    $online = [];

    if ( is_object( $awp_instances ) && method_exists( $awp_instances, 'get_online_instances' ) ) {
        $online = $awp_instances->get_online_instances();

    } elseif ( is_array( $awp_instances ) ) {
        $online = $awp_instances;

    } else {
        global $wpdb;
        $online = $wpdb->get_results(
            "SELECT id
               FROM {$wpdb->prefix}awp_instance_data
              WHERE status = 'online'"
        );
    }

    if ( ! empty( $online ) ) {
        return true;
    }

    self::render_no_instance_notice( $title );
    return false;
}

	private static function render_no_instance_notice( string $title ) : void {
	
	echo '<div class="wrap">
				<h1><i class="ri-lock-line"></i> ' . esc_html( $title ) . '</h1>
				<div class="nosender-box" style="padding: 1rem; border-left-width: 4px;">
					<p><strong>' . esc_html__( 'You need to check your Whatsapp number', 'awp' ) . '</strong></p>
					<p>' . esc_html__( 'No instance is online! Please connect an instance before using these features.', 'awp' ) . '</p>
					<p>
						<a href="' . esc_url( admin_url( 'admin.php?page=wawp&awp_section=instances#tab-wa' ) ) . '" class="awp-btn primary">
							<i class="ri-settings-3-line"></i> ' . esc_html__( 'Add New Instance', 'awp' ) . '
						</a>
					</p>
				</div>
			</div>';
	}

	
	
	
	

	public static function require_active_sender( string $title = 'Feature Unavailable' ) : bool {
		$senders_opts = get_option( 'awp_senders_enabled', [ 'email' => 1, 'wa' => 1, 'meta' => 1 ] );

		$is_any_sender_enabled = ! empty( $senders_opts['email'] ) || ! empty( $senders_opts['wa'] ) || ! empty( $senders_opts['meta'] );

		if ( $is_any_sender_enabled ) {
			return true;
		}

		self::render_no_sender_notice( $title );
		return false;
	}

	private static function render_no_sender_notice( string $title ) : void {
		echo '<div class="wrap">
				<h1><i class="ri-toggle-line"></i> ' . esc_html( $title ) . '</h1>
				<div class="nosender-box" style="padding: 1rem; border-left-width: 4px;">
					<p><strong>' . esc_html__( 'All Senders Disabled', 'awp' ) . '</strong></p>
					<p>' . esc_html__( 'To use this feature, please enable at least one sender (Email OR WhatsApp).', 'awp' ) . '</p>
					<p>
						<a href="' . esc_url( admin_url( 'admin.php?page=wawp&awp_section=instances#tab-senders' ) ) . '" class="awp-btn primary">
							<i class="ri-settings-3-line"></i> ' . esc_html__( 'Go to Sender Settings', 'awp' ) . '
						</a>
					</p>
				</div>
			</div>';
	}
}
