<?php
/**
 * Country Code List
 */

namespace AWP;

/**
 * Return an array of all countries with their details.
 *
 * @return array
 */
function awp_get_all_countries() {
    return array(
        array(
            'iso2'     => 'eg',
            'name'     => __( 'Egypt', 'awp' ),
            'dialCode' => '20',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'sa',
            'name'     => __( 'Saudi Arabia', 'awp' ),
            'dialCode' => '966',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'af',
            'name'     => __( 'Afghanistan', 'awp' ),
            'dialCode' => '93',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'al',
            'name'     => __( 'Albania', 'awp' ),
            'dialCode' => '355',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'dz',
            'name'     => __( 'Algeria', 'awp' ),
            'dialCode' => '213',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'as',
            'name'     => __( 'American Samoa', 'awp' ),
            'dialCode' => '1684',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'ad',
            'name'     => __( 'Andorra', 'awp' ),
            'dialCode' => '376',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'ao',
            'name'     => __( 'Angola', 'awp' ),
            'dialCode' => '244',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ai',
            'name'     => __( 'Anguilla', 'awp' ),
            'dialCode' => '1264',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ag',
            'name'     => __( 'Antigua and Barbuda', 'awp' ),
            'dialCode' => '1268',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ar',
            'name'     => __( 'Argentina', 'awp' ),
            'dialCode' => '54',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'am',
            'name'     => __( 'Armenia', 'awp' ),
            'dialCode' => '374',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'aw',
            'name'     => __( 'Aruba', 'awp' ),
            'dialCode' => '297',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'au',
            'name'     => __( 'Australia', 'awp' ),
            'dialCode' => '61',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'at',
            'name'     => __( 'Austria', 'awp' ),
            'dialCode' => '43',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'az',
            'name'     => __( 'Azerbaijan', 'awp' ),
            'dialCode' => '994',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'bs',
            'name'     => __( 'Bahamas', 'awp' ),
            'dialCode' => '1242',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'bh',
            'name'     => __( 'Bahrain', 'awp' ),
            'dialCode' => '973',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'bd',
            'name'     => __( 'Bangladesh', 'awp' ),
            'dialCode' => '880',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'bb',
            'name'     => __( 'Barbados', 'awp' ),
            'dialCode' => '1246',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'by',
            'name'     => __( 'Belarus', 'awp' ),
            'dialCode' => '375',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'be',
            'name'     => __( 'Belgium', 'awp' ),
            'dialCode' => '32',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'bz',
            'name'     => __( 'Belize', 'awp' ),
            'dialCode' => '501',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'bj',
            'name'     => __( 'Benin', 'awp' ),
            'dialCode' => '229',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'bm',
            'name'     => __( 'Bermuda', 'awp' ),
            'dialCode' => '1441',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'bt',
            'name'     => __( 'Bhutan', 'awp' ),
            'dialCode' => '975',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'bo',
            'name'     => __( 'Bolivia', 'awp' ),
            'dialCode' => '591',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ba',
            'name'     => __( 'Bosnia and Herzegovina', 'awp' ),
            'dialCode' => '387',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'bw',
            'name'     => __( 'Botswana', 'awp' ),
            'dialCode' => '267',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'br',
            'name'     => __( 'Brazil', 'awp' ),
            'dialCode' => '55',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'bn',
            'name'     => __( 'Brunei', 'awp' ),
            'dialCode' => '673',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'bg',
            'name'     => __( 'Bulgaria', 'awp' ),
            'dialCode' => '359',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'bf',
            'name'     => __( 'Burkina Faso', 'awp' ),
            'dialCode' => '226',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'bi',
            'name'     => __( 'Burundi', 'awp' ),
            'dialCode' => '257',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'cv',
            'name'     => __( 'Cabo Verde', 'awp' ),
            'dialCode' => '238',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'kh',
            'name'     => __( 'Cambodia', 'awp' ),
            'dialCode' => '855',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'cm',
            'name'     => __( 'Cameroon', 'awp' ),
            'dialCode' => '237',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ca',
            'name'     => __( 'Canada', 'awp' ),
            'dialCode' => '1',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'cf',
            'name'     => __( 'Central African Republic', 'awp' ),
            'dialCode' => '236',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'td',
            'name'     => __( 'Chad', 'awp' ),
            'dialCode' => '235',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'cl',
            'name'     => __( 'Chile', 'awp' ),
            'dialCode' => '56',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'cn',
            'name'     => __( 'China', 'awp' ),
            'dialCode' => '86',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'co',
            'name'     => __( 'Colombia', 'awp' ),
            'dialCode' => '57',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'km',
            'name'     => __( 'Comoros', 'awp' ),
            'dialCode' => '269',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'cd',
            'name'     => __( 'Congo, Democratic', 'awp' ),
            'dialCode' => '243',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'cg',
            'name'     => __( 'Congo', 'awp' ),
            'dialCode' => '242',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'cr',
            'name'     => __( 'Costa Rica', 'awp' ),
            'dialCode' => '506',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ci',
            'name'     => __( "Cote d'Ivoire", 'awp' ),
            'dialCode' => '225',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'hr',
            'name'     => __( 'Croatia', 'awp' ),
            'dialCode' => '385',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'cu',
            'name'     => __( 'Cuba', 'awp' ),
            'dialCode' => '53',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'cy',
            'name'     => __( 'Cyprus', 'awp' ),
            'dialCode' => '357',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'cz',
            'name'     => __( 'Czech Republic', 'awp' ),
            'dialCode' => '420',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'dk',
            'name'     => __( 'Denmark', 'awp' ),
            'dialCode' => '45',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'dj',
            'name'     => __( 'Djibouti', 'awp' ),
            'dialCode' => '253',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'dm',
            'name'     => __( 'Dominica', 'awp' ),
            'dialCode' => '1767',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'do',
            'name'     => __( 'Dominican Republic', 'awp' ),
            'dialCode' => '1809',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ec',
            'name'     => __( 'Ecuador', 'awp' ),
            'dialCode' => '593',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'sv',
            'name'     => __( 'El Salvador', 'awp' ),
            'dialCode' => '503',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'gq',
            'name'     => __( 'Equatorial Guinea', 'awp' ),
            'dialCode' => '240',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'er',
            'name'     => __( 'Eritrea', 'awp' ),
            'dialCode' => '291',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ee',
            'name'     => __( 'Estonia', 'awp' ),
            'dialCode' => '372',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'sz',
            'name'     => __( 'Eswatini', 'awp' ),
            'dialCode' => '268',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'et',
            'name'     => __( 'Ethiopia', 'awp' ),
            'dialCode' => '251',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'fj',
            'name'     => __( 'Fiji', 'awp' ),
            'dialCode' => '679',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'fi',
            'name'     => __( 'Finland', 'awp' ),
            'dialCode' => '358',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'fr',
            'name'     => __( 'France', 'awp' ),
            'dialCode' => '33',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'ga',
            'name'     => __( 'Gabon', 'awp' ),
            'dialCode' => '241',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'gm',
            'name'     => __( 'Gambia', 'awp' ),
            'dialCode' => '220',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ge',
            'name'     => __( 'Georgia', 'awp' ),
            'dialCode' => '995',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'de',
            'name'     => __( 'Germany', 'awp' ),
            'dialCode' => '49',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'gh',
            'name'     => __( 'Ghana', 'awp' ),
            'dialCode' => '233',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'gr',
            'name'     => __( 'Greece', 'awp' ),
            'dialCode' => '30',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'gd',
            'name'     => __( 'Grenada', 'awp' ),
            'dialCode' => '1473',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'gu',
            'name'     => __( 'Guam', 'awp' ),
            'dialCode' => '1671',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'gt',
            'name'     => __( 'Guatemala', 'awp' ),
            'dialCode' => '502',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'gn',
            'name'     => __( 'Guinea', 'awp' ),
            'dialCode' => '224',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'gw',
            'name'     => __( 'Guinea-Bissau', 'awp' ),
            'dialCode' => '245',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'gy',
            'name'     => __( 'Guyana', 'awp' ),
            'dialCode' => '592',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ht',
            'name'     => __( 'Haiti', 'awp' ),
            'dialCode' => '509',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'hn',
            'name'     => __( 'Honduras', 'awp' ),
            'dialCode' => '504',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'hk',
            'name'     => __( 'Hong Kong', 'awp' ),
            'dialCode' => '852',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'hu',
            'name'     => __( 'Hungary', 'awp' ),
            'dialCode' => '36',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'is',
            'name'     => __( 'Iceland', 'awp' ),
            'dialCode' => '354',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'in',
            'name'     => __( 'India', 'awp' ),
            'dialCode' => '91',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'id',
            'name'     => __( 'Indonesia', 'awp' ),
            'dialCode' => '62',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'ir',
            'name'     => __( 'Iran', 'awp' ),
            'dialCode' => '98',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'iq',
            'name'     => __( 'Iraq', 'awp' ),
            'dialCode' => '964',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'ie',
            'name'     => __( 'Ireland', 'awp' ),
            'dialCode' => '353',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'it',
            'name'     => __( 'Italy', 'awp' ),
            'dialCode' => '39',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'jm',
            'name'     => __( 'Jamaica', 'awp' ),
            'dialCode' => '1876',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'jp',
            'name'     => __( 'Japan', 'awp' ),
            'dialCode' => '81',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'jo',
            'name'     => __( 'Jordan', 'awp' ),
            'dialCode' => '962',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'kz',
            'name'     => __( 'Kazakhstan', 'awp' ),
            'dialCode' => '7',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'ke',
            'name'     => __( 'Kenya', 'awp' ),
            'dialCode' => '254',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ki',
            'name'     => __( 'Kiribati', 'awp' ),
            'dialCode' => '686',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'kp',
            'name'     => __( 'North Korea', 'awp' ),
            'dialCode' => '850',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'kr',
            'name'     => __( 'South Korea', 'awp' ),
            'dialCode' => '82',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'kw',
            'name'     => __( 'Kuwait', 'awp' ),
            'dialCode' => '965',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'kg',
            'name'     => __( 'Kyrgyzstan', 'awp' ),
            'dialCode' => '996',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'la',
            'name'     => __( "Lao People's Democratic Republic", 'awp' ),
            'dialCode' => '856',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'lv',
            'name'     => __( 'Latvia', 'awp' ),
            'dialCode' => '371',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'lb',
            'name'     => __( 'Lebanon', 'awp' ),
            'dialCode' => '961',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'ls',
            'name'     => __( 'Lesotho', 'awp' ),
            'dialCode' => '266',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'lr',
            'name'     => __( 'Liberia', 'awp' ),
            'dialCode' => '231',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ly',
            'name'     => __( 'Libya', 'awp' ),
            'dialCode' => '218',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'li',
            'name'     => __( 'Liechtenstein', 'awp' ),
            'dialCode' => '423',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'lt',
            'name'     => __( 'Lithuania', 'awp' ),
            'dialCode' => '370',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'lu',
            'name'     => __( 'Luxembourg', 'awp' ),
            'dialCode' => '352',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'mo',
            'name'     => __( 'Macao', 'awp' ),
            'dialCode' => '853',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'mg',
            'name'     => __( 'Madagascar', 'awp' ),
            'dialCode' => '261',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'mw',
            'name'     => __( 'Malawi', 'awp' ),
            'dialCode' => '265',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'my',
            'name'     => __( 'Malaysia', 'awp' ),
            'dialCode' => '60',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'mv',
            'name'     => __( 'Maldives', 'awp' ),
            'dialCode' => '960',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'ml',
            'name'     => __( 'Mali', 'awp' ),
            'dialCode' => '223',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'mt',
            'name'     => __( 'Malta', 'awp' ),
            'dialCode' => '356',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'mh',
            'name'     => __( 'Marshall Islands', 'awp' ),
            'dialCode' => '692',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'mr',
            'name'     => __( 'Mauritania', 'awp' ),
            'dialCode' => '222',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'mu',
            'name'     => __( 'Mauritius', 'awp' ),
            'dialCode' => '230',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'mx',
            'name'     => __( 'Mexico', 'awp' ),
            'dialCode' => '52',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'fm',
            'name'     => __( 'Micronesia', 'awp' ),
            'dialCode' => '691',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'md',
            'name'     => __( 'Moldova', 'awp' ),
            'dialCode' => '373',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'mc',
            'name'     => __( 'Monaco', 'awp' ),
            'dialCode' => '377',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'mn',
            'name'     => __( 'Mongolia', 'awp' ),
            'dialCode' => '976',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'me',
            'name'     => __( 'Montenegro', 'awp' ),
            'dialCode' => '382',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'ma',
            'name'     => __( 'Morocco', 'awp' ),
            'dialCode' => '212',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'mz',
            'name'     => __( 'Mozambique', 'awp' ),
            'dialCode' => '258',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'mm',
            'name'     => __( 'Myanmar', 'awp' ),
            'dialCode' => '95',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'na',
            'name'     => __( 'Namibia', 'awp' ),
            'dialCode' => '264',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'nr',
            'name'     => __( 'Nauru', 'awp' ),
            'dialCode' => '674',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'np',
            'name'     => __( 'Nepal', 'awp' ),
            'dialCode' => '977',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'nl',
            'name'     => __( 'Netherlands', 'awp' ),
            'dialCode' => '31',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'nz',
            'name'     => __( 'New Zealand', 'awp' ),
            'dialCode' => '64',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'ni',
            'name'     => __( 'Nicaragua', 'awp' ),
            'dialCode' => '505',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ne',
            'name'     => __( 'Niger', 'awp' ),
            'dialCode' => '227',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ng',
            'name'     => __( 'Nigeria', 'awp' ),
            'dialCode' => '234',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'nu',
            'name'     => __( 'Niue', 'awp' ),
            'dialCode' => '683',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'mk',
            'name'     => __( 'North Macedonia', 'awp' ),
            'dialCode' => '389',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'no',
            'name'     => __( 'Norway', 'awp' ),
            'dialCode' => '47',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'om',
            'name'     => __( 'Oman', 'awp' ),
            'dialCode' => '968',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'pk',
            'name'     => __( 'Pakistan', 'awp' ),
            'dialCode' => '92',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'pw',
            'name'     => __( 'Palau', 'awp' ),
            'dialCode' => '680',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'ps',
            'name'     => __( 'Palestine', 'awp' ),
            'dialCode' => '970',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'pa',
            'name'     => __( 'Panama', 'awp' ),
            'dialCode' => '507',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'pg',
            'name'     => __( 'Papua New Guinea', 'awp' ),
            'dialCode' => '675',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'py',
            'name'     => __( 'Paraguay', 'awp' ),
            'dialCode' => '595',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'pe',
            'name'     => __( 'Peru', 'awp' ),
            'dialCode' => '51',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ph',
            'name'     => __( 'Philippines', 'awp' ),
            'dialCode' => '63',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'pl',
            'name'     => __( 'Poland', 'awp' ),
            'dialCode' => '48',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'pt',
            'name'     => __( 'Portugal', 'awp' ),
            'dialCode' => '351',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'qa',
            'name'     => __( 'Qatar', 'awp' ),
            'dialCode' => '974',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'ro',
            'name'     => __( 'Romania', 'awp' ),
            'dialCode' => '40',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'ru',
            'name'     => __( 'Russia', 'awp' ),
            'dialCode' => '7',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'rw',
            'name'     => __( 'Rwanda', 'awp' ),
            'dialCode' => '250',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'kn',
            'name'     => __( 'Saint Kitts and Nevis', 'awp' ),
            'dialCode' => '1869',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'lc',
            'name'     => __( 'Saint Lucia', 'awp' ),
            'dialCode' => '1758',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'vc',
            'name'     => __( 'Saint Vincent and the Grenadines', 'awp' ),
            'dialCode' => '1784',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ws',
            'name'     => __( 'Samoa', 'awp' ),
            'dialCode' => '685',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'sm',
            'name'     => __( 'San Marino', 'awp' ),
            'dialCode' => '378',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'st',
            'name'     => __( 'Sao Tome and Principe', 'awp' ),
            'dialCode' => '239',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'sn',
            'name'     => __( 'Senegal', 'awp' ),
            'dialCode' => '221',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'rs',
            'name'     => __( 'Serbia', 'awp' ),
            'dialCode' => '381',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'sc',
            'name'     => __( 'Seychelles', 'awp' ),
            'dialCode' => '248',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'sl',
            'name'     => __( 'Sierra Leone', 'awp' ),
            'dialCode' => '232',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'sg',
            'name'     => __( 'Singapore', 'awp' ),
            'dialCode' => '65',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'sk',
            'name'     => __( 'Slovakia', 'awp' ),
            'dialCode' => '421',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'si',
            'name'     => __( 'Slovenia', 'awp' ),
            'dialCode' => '386',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'sb',
            'name'     => __( 'Solomon Islands', 'awp' ),
            'dialCode' => '677',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'so',
            'name'     => __( 'Somalia', 'awp' ),
            'dialCode' => '252',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'za',
            'name'     => __( 'South Africa', 'awp' ),
            'dialCode' => '27',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ss',
            'name'     => __( 'South Sudan', 'awp' ),
            'dialCode' => '211',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'es',
            'name'     => __( 'Spain', 'awp' ),
            'dialCode' => '34',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'lk',
            'name'     => __( 'Sri Lanka', 'awp' ),
            'dialCode' => '94',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'sd',
            'name'     => __( 'Sudan', 'awp' ),
            'dialCode' => '249',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'sr',
            'name'     => __( 'Suriname', 'awp' ),
            'dialCode' => '597',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'se',
            'name'     => __( 'Sweden', 'awp' ),
            'dialCode' => '46',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'ch',
            'name'     => __( 'Switzerland', 'awp' ),
            'dialCode' => '41',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'sy',
            'name'     => __( 'Syrian Arab Republic', 'awp' ),
            'dialCode' => '963',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'tw',
            'name'     => __( 'Taiwan', 'awp' ),
            'dialCode' => '886',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'tj',
            'name'     => __( 'Tajikistan', 'awp' ),
            'dialCode' => '992',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'tz',
            'name'     => __( 'Tanzania', 'awp' ),
            'dialCode' => '255',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'th',
            'name'     => __( 'Thailand', 'awp' ),
            'dialCode' => '66',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'tl',
            'name'     => __( 'Timor-Leste', 'awp' ),
            'dialCode' => '670',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'tg',
            'name'     => __( 'Togo', 'awp' ),
            'dialCode' => '228',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'to',
            'name'     => __( 'Tonga', 'awp' ),
            'dialCode' => '676',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'tt',
            'name'     => __( 'Trinidad and Tobago', 'awp' ),
            'dialCode' => '1868',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'tn',
            'name'     => __( 'Tunisia', 'awp' ),
            'dialCode' => '216',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'tr',
            'name'     => __( 'Turkey', 'awp' ),
            'dialCode' => '90',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'tm',
            'name'     => __( 'Turkmenistan', 'awp' ),
            'dialCode' => '993',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'tv',
            'name'     => __( 'Tuvalu', 'awp' ),
            'dialCode' => '688',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'ug',
            'name'     => __( 'Uganda', 'awp' ),
            'dialCode' => '256',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ua',
            'name'     => __( 'Ukraine', 'awp' ),
            'dialCode' => '380',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'ae',
            'name'     => __( 'United Arab Emirates', 'awp' ),
            'dialCode' => '971',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'gb',
            'name'     => __( 'United Kingdom', 'awp' ),
            'dialCode' => '44',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'us',
            'name'     => __( 'United States', 'awp' ),
            'dialCode' => '1',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'uy',
            'name'     => __( 'Uruguay', 'awp' ),
            'dialCode' => '598',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'uz',
            'name'     => __( 'Uzbekistan', 'awp' ),
            'dialCode' => '998',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'vu',
            'name'     => __( 'Vanuatu', 'awp' ),
            'dialCode' => '678',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 've',
            'name'     => __( 'Venezuela', 'awp' ),
            'dialCode' => '58',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'vn',
            'name'     => __( 'Vietnam', 'awp' ),
            'dialCode' => '84',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'ye',
            'name'     => __( 'Yemen', 'awp' ),
            'dialCode' => '967',
            'region'   => __( 'Middle East', 'awp' ),
        ),
        array(
            'iso2'     => 'zm',
            'name'     => __( 'Zambia', 'awp' ),
            'dialCode' => '260',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'zw',
            'name'     => __( 'Zimbabwe', 'awp' ),
            'dialCode' => '263',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'ca',
            'name'     => __( 'Canada', 'awp' ),
            'dialCode' => '1',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'us',
            'name'     => __( 'United States', 'awp' ),
            'dialCode' => '1',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ru',
            'name'     => __( 'Russia', 'awp' ),
            'dialCode' => '7',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'kz',
            'name'     => __( 'Kazakhstan', 'awp' ),
            'dialCode' => '7',
            'region'   => __( 'Asia', 'awp' ),
        ),
        array(
            'iso2'     => 'aq',
            'name'     => __( 'Antarctica', 'awp' ),
            'dialCode' => '672',
            'region'   => __( 'Antarctica', 'awp' ),
        ),
        array(
            'iso2'     => 'ax',
            'name'     => __( 'Åland Islands', 'awp' ),
            'dialCode' => '358',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'bl',
            'name'     => __( 'Saint Barthélemy', 'awp' ),
            'dialCode' => '590',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'bq',
            'name'     => __( 'Bonaire, Sint Eustatius and Saba', 'awp' ),
            'dialCode' => '599',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'bv',
            'name'     => __( 'Bouvet Island', 'awp' ),
            'dialCode' => '',
            'region'   => __( 'Antarctica', 'awp' ),
        ),
        array(
            'iso2'     => 'cc',
            'name'     => __( 'Cocos (Keeling) Islands', 'awp' ),
            'dialCode' => '61',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'ck',
            'name'     => __( 'Cook Islands', 'awp' ),
            'dialCode' => '682',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'cw',
            'name'     => __( 'Curaçao', 'awp' ),
            'dialCode' => '599',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'cx',
            'name'     => __( 'Christmas Island', 'awp' ),
            'dialCode' => '61',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'eh',
            'name'     => __( 'Western Sahara', 'awp' ),
            'dialCode' => '212',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'fk',
            'name'     => __( 'Falkland Islands (Malvinas)', 'awp' ),
            'dialCode' => '500',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'fo',
            'name'     => __( 'Faroe Islands', 'awp' ),
            'dialCode' => '298',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'gf',
            'name'     => __( 'French Guiana', 'awp' ),
            'dialCode' => '594',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'gg',
            'name'     => __( 'Guernsey', 'awp' ),
            'dialCode' => '44',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'gi',
            'name'     => __( 'Gibraltar', 'awp' ),
            'dialCode' => '350',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'gl',
            'name'     => __( 'Greenland', 'awp' ),
            'dialCode' => '299',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'gp',
            'name'     => __( 'Guadeloupe', 'awp' ),
            'dialCode' => '590',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'gs',
            'name'     => __( 'South Georgia and the South Sandwich Islands', 'awp' ),
            'dialCode' => '500',
            'region'   => __( 'Antarctica', 'awp' ),
        ),
        array(
            'iso2'     => 'hm',
            'name'     => __( 'Heard Island and McDonald Islands', 'awp' ),
            'dialCode' => '',
            'region'   => __( 'Antarctica', 'awp' ),
        ),
        array(
            'iso2'     => 'im',
            'name'     => __( 'Isle of Man', 'awp' ),
            'dialCode' => '44',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'io',
            'name'     => __( 'British Indian Ocean Territory', 'awp' ),
            'dialCode' => '246',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'je',
            'name'     => __( 'Jersey', 'awp' ),
            'dialCode' => '44',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'ky',
            'name'     => __( 'Cayman Islands', 'awp' ),
            'dialCode' => '1345',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'mf',
            'name'     => __( 'Saint Martin (French part)', 'awp' ),
            'dialCode' => '590',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'mp',
            'name'     => __( 'Northern Mariana Islands', 'awp' ),
            'dialCode' => '1670',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'mq',
            'name'     => __( 'Martinique', 'awp' ),
            'dialCode' => '596',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'ms',
            'name'     => __( 'Montserrat', 'awp' ),
            'dialCode' => '1664',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'nc',
            'name'     => __( 'New Caledonia', 'awp' ),
            'dialCode' => '687',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'nf',
            'name'     => __( 'Norfolk Island', 'awp' ),
            'dialCode' => '672',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'pf',
            'name'     => __( 'French Polynesia', 'awp' ),
            'dialCode' => '689',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'pm',
            'name'     => __( 'Saint Pierre and Miquelon', 'awp' ),
            'dialCode' => '508',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'pn',
            'name'     => __( 'Pitcairn', 'awp' ),
            'dialCode' => '64',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'pr',
            'name'     => __( 'Puerto Rico', 'awp' ),
            'dialCode' => '1',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 're',
            'name'     => __( 'Réunion', 'awp' ),
            'dialCode' => '262',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'sh',
            'name'     => __( 'Saint Helena, Ascension and Tristan da Cunha', 'awp' ),
            'dialCode' => '290',
            'region'   => __( 'Africa', 'awp' ),
        ),
        array(
            'iso2'     => 'sj',
            'name'     => __( 'Svalbard and Jan Mayen', 'awp' ),
            'dialCode' => '47',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'sx',
            'name'     => __( 'Sint Maarten (Dutch part)', 'awp' ),
            'dialCode' => '1721',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'tc',
            'name'     => __( 'Turks and Caicos Islands', 'awp' ),
            'dialCode' => '1649',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'tf',
            'name'     => __( 'French Southern Territories', 'awp' ),
            'dialCode' => '',
            'region'   => __( 'Antarctica', 'awp' ),
        ),
        array(
            'iso2'     => 'tk',
            'name'     => __( 'Tokelau', 'awp' ),
            'dialCode' => '690',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'um',
            'name'     => __( 'United States Minor Outlying Islands', 'awp' ),
            'dialCode' => '1',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'va',
            'name'     => __( 'Holy See (Vatican City State)', 'awp' ),
            'dialCode' => '379',
            'region'   => __( 'Europe', 'awp' ),
        ),
        array(
            'iso2'     => 'vg',
            'name'     => __( 'Virgin Islands, British', 'awp' ),
            'dialCode' => '1284',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'vi',
            'name'     => __( 'Virgin Islands, U.S.', 'awp' ),
            'dialCode' => '1340',
            'region'   => __( 'Americas', 'awp' ),
        ),
        array(
            'iso2'     => 'wf',
            'name'     => __( 'Wallis and Futuna', 'awp' ),
            'dialCode' => '681',
            'region'   => __( 'Oceania', 'awp' ),
        ),
        array(
            'iso2'     => 'yt',
            'name'     => __( 'Mayotte', 'awp' ),
            'dialCode' => '262',
            'region'   => __( 'Africa', 'awp' ),
        ),
          array(
            'iso2'     => 'ps',
            'name'     => __( 'Palestine 48 Lands', 'awp' ),
            'dialCode' => '972',
            'region'   => __( 'Middle East', 'awp' ),
        ),
    );
}
