<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Wawp_Dashboard {

    public function render_page() {
        $icons_url = AWP_PLUGIN_URL . 'assets/icons/';
        $icon_style = 'style="width: 3rem; height: 3rem;  margin-bottom: .5rem;"';
        $settings_icon_style = 'style="width: 24px; height: 24px;"';

        $current_domain       = wp_parse_url( get_site_url(), PHP_URL_HOST );
        $banned_msg           = get_transient( 'siteB_banned_msg' );
        $token                = get_option( 'mysso_token' );
        $user_data            = get_transient( 'siteB_user_data' );
        
        if ( ! $user_data && get_option( 'mysso_token' ) ) {
        do_action( 'mrsb_auto_sync_event' );
        $user_data = get_transient( 'siteB_user_data' );
         }
        $segmentation_allowed = ( $user_data['segnotifs_enabled'] ?? 'disabled' ) === 'enabled';
        $multilang_allowed = ( $user_data['multilang_enabled'] ?? 'disabled' ) === 'enabled';
        $sub_notifs_allowed = ( $user_data['subnotifs_enabled'] ?? '' ) === 'enabled'
          || (int) get_option( 'awp_sub_notifs_enabled', 0 ) === 1;
        $abandoned_carts_allowed = ( $user_data['abandonedcart_enabled'] ?? 'disabled' ) === 'enabled';
        $countrycode_allowed = ( $user_data['countrycode_enabled'] ?? 'disabled' ) === 'enabled';
        $chatbutton_allowed = ( $user_data['chatbutton_enabled'] ?? 'disabled' ) === 'enabled';
        $notifications_allowed = ( $user_data['notifications_enabled'] ?? 'disabled' ) === 'enabled';
        $login_otp_allowed = ( $user_data['loginotp_enabled'] ?? 'disabled' ) === 'enabled';
        $signup_otp_allowed = ( $user_data['signupotp_enabled'] ?? 'disabled' ) === 'enabled';
        $checkout_otp_allowed = ( $user_data['checkoutotp_enabled'] ?? 'disabled' ) === 'enabled';
        $custom_pages_allowed = true;
        $system_info_allowed = true;

        if ( $banned_msg ) {
            printf(
                '<div class="wrap"><h1><img src="%s" alt="Lock Icon" %s> %s</h1><p style="color:red;">%s</p></div>',
                esc_url( $icons_url . 'lock.svg' ),
                $icon_style,
                esc_html__( 'Wawp Dashboard', 'awp' ),
                esc_html( Wawp_Global_Messages::get( 'blocked_generic' ) )
            );
            return;
        }

        if ( ! $token ) {
            printf(
                '<div class="wrap"><h1><img src="%s" alt="Lock Icon" %s> %s</h1><p>%s</p></div>',
                esc_url( $icons_url . 'lock.svg' ),
                $icon_style,
                esc_html__( 'Wawp Dashboard', 'awp' ),
                esc_html( Wawp_Global_Messages::get( 'need_login' ) )
            );
            return;
        }

        if ( $user_data && ( $user_data['sites'][ $current_domain ] ?? '' ) !== 'active' ) {
            printf(
                '<div class="wrap"><h1><img src="%s" alt="Lock Icon" %s> %s</h1><p style="color:red;">%s</p></div>',
                esc_url( $icons_url . 'lock.svg' ),
                $icon_style,
                esc_html__( 'Wawp Dashboard', 'awp' ),
                esc_html( Wawp_Global_Messages::get( 'not_active_site' ) )
            );
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }
        
        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        
        $woocommerce_installed = is_plugin_active('woocommerce/woocommerce.php');
        $wc_subscriptions_installed = is_plugin_active('woocommerce-subscriptions/woocommerce-subscriptions.php');
        
        global $wpdb;

        $dm           = new AWP_Database_Manager();
        $user_info_table = $dm->get_user_info_table_name();

        $total_wp_users = get_transient( 'wawp_total_users' );
        if ( false === $total_wp_users ) {
            $total_wp_users = (int) $wpdb->get_var( "SELECT COUNT(ID) FROM {$wpdb->users}" );
            set_transient( 'wawp_total_users', $total_wp_users, HOUR_IN_SECONDS );
        }

        $info_stats = get_transient( 'wawp_userinfo_stats' );
        if ( false === $info_stats ) {
            $info_stats = $wpdb->get_row(
                "SELECT
                    COUNT(*)                    AS total_rows,
                    SUM(phone <> '' AND phone <> 'N/A')            AS users_with_phone,
                    SUM(whatsapp_verified = 'Verified')            AS verified,
                    SUM(whatsapp_verified = 'Not Verified')        AS not_verified
                  FROM {$user_info_table}",
                ARRAY_A
            );
            set_transient( 'wawp_userinfo_stats', $info_stats, 5 * MINUTE_IN_SECONDS );
        }

        $users_with_phone     = (int) $info_stats['users_with_phone'];
        $total_verified       = (int) $info_stats['verified'];
        $total_not_verified   = (int) $info_stats['not_verified'];
        
        $percent_verified = $users_with_phone > 0 ? ($total_verified / $users_with_phone) * 100 : 0;
        $percent_verified = max(0, min(100, $percent_verified));
        $percent_verified_display = number_format($percent_verified, 0);
        
        $percent_added = $total_wp_users > 0 ? ($users_with_phone / $total_wp_users) * 100 : 0;
        $percent_added = max(0, min(100, $percent_added));
        $percent_added_display = number_format($percent_added, 0);
        
        $percent_pending = $users_with_phone > 0 ? ($total_not_verified / $users_with_phone) * 100 : 0;
        $percent_pending = max(0, min(100, $percent_pending));
        $percent_pending_display = number_format($percent_pending, 0);
        
        $is_tracking_ids_enabled = class_exists('Wawp_Api_Url') ? get_option(Wawp_Api_Url::OPT_TRACKING_IDS, Wawp_Api_Url::DEF_TRACKING_IDS) : 0;
        $is_chat_widget_enabled   = get_option( 'awp_chat_widget_enabled', 1 );
        $is_notifications_enabled = get_option( 'awp_notifications_enabled', 1 );
        $is_wawp_otp_enabled      = get_option( 'awp_wawp_otp_enabled', 1 );
        $is_otp_login_enabled     = get_option( 'awp_otp_login_enabled', 1 );
        $is_signup_enabled        = get_option( 'awp_signup_enabled', 1 );
        $is_checkout_otp_enabled  = get_option( 'awp_checkout_otp_enabled', 1 );
        $is_custom_pages_enabled  = get_option( 'awp_custom_pages_enabled', 1 );
        $is_countrycode_enabled = get_option( 'awp_countrycode_enabled', 1 );
        $is_abandoned_carts_enabled = get_option('awp_abandoned_carts_enabled', 1);
        $is_campaigns_enabled   = get_option( 'awp_campaigns_enabled', 0 );
        $is_system_info_enabled = get_option('awp_system_info_enabled', 1);
        $is_multilang_enabled = get_option('awp_multilang_enabled', 0);
        $is_sub_notifs_enabled = get_option('awp_sub_notifs_enabled', 0);


        if ( ! $woocommerce_installed && $is_checkout_otp_enabled ) {
            update_option( 'awp_checkout_otp_enabled', 0 );
            $is_checkout_otp_enabled = 0;
        }

        wp_localize_script(
            'awp-dashboard-js',
            'awpVars',
            [
                'ajax_url'     => admin_url( 'admin-ajax.php' ),
                'verified'     => $total_verified,
                'not_verified' => $total_not_verified,
            ]
        );
        wp_nonce_field( 'awp_live_toggle_nonce', 'awp_live_toggle_nonce' );
        ?>
        <div class="wrap awp-dashboard-wrapper">
            <div class="awp-dashboard-content">
                <div class="page-header_row">
                    <div class="page-header">
                        <h2 class="page-title"><?php esc_html_e( 'Dashboard', 'awp' ); ?></h2>
                        <p><?php esc_html_e( 'Customize which features are enabled to match your preferences.', 'awp' ); ?></p>
                        <?php if ( ! $woocommerce_installed ) :
                            $woo_file            = WP_PLUGIN_DIR . '/woocommerce/woocommerce.php';
                            $woocommerce_file_exists = file_exists( $woo_file );
                            ?>
                            <div style="margin-top:12px;padding:16px;border:1px solid #ccc;background:#fff;">
                                <p style="font-size:14px;margin:0 0 8px;">
                                    <strong><?php esc_html_e( 'To enable Order Notifications, WooCommerce must be installed and active.', 'awp' ); ?></strong>
                                </p>
                                <?php
                                if ( $woocommerce_file_exists ) {
                                    $activate_url = wp_nonce_url(
                                        'plugins.php?action=activate&plugin=woocommerce/woocommerce.php',
                                        'activate-plugin_woocommerce/woocommerce.php'
                                    );
                                    printf(
                                        '<a class="button button-primary" href="%s">%s</a>',
                                        esc_url( $activate_url ),
                                        esc_html__( 'Activate WooCommerce', 'awp' )
                                    );
                                } else {
                                    $install_url = wp_nonce_url(
                                        self_admin_url( 'update.php?action=install-plugin&plugin=woocommerce' ),
                                        'install-plugin_woocommerce'
                                    );
                                    printf(
                                        '<a class="button button-primary" href="%s">%s</a>',
                                        esc_url( $install_url ),
                                        esc_html__( 'Install WooCommerce', 'awp' )
                                    );
                                }
                                ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="awp-cards">
                    <div class="awp-card" style="max-width: 100%;">
                        <div class="card-header_row">
                            <div class="card-header">
                                <span class="card-title"><?php esc_html_e( 'WordPress Users — Snapshot', 'awp' ); ?></span>
                                <p><?php esc_html_e( 'Overview of phone numbers and verification status.', 'awp' ); ?></p>
                            </div>
                            <a class="awp-btn secondary" href="<?php echo esc_url( admin_url( 'users.php' ) ); ?>" target="_blank">
                                <?php esc_html_e( 'View All Users', 'awp' ); ?>
                            </a>
                        </div>
                        <div class="cards-group">
                            <div class="stats-card">
                                <div class="card-number_wrapper">
                                    <span class="card-number"><?php echo esc_html( $users_with_phone . ' / ' . $total_wp_users ); ?></span>
                                    <span class="awp-badge disabled"><?php esc_html_e( 'All', 'awp' ); ?></span>
                                </div>
                                <span class="card-label"><?php esc_html_e( 'Phone Numbers Added', 'awp' ); ?><span class="progress__label"><?php esc_html_e( ' [ ' . $percent_added_display . '% ]', 'awp' ); ?></span></span>
                                <span class="stats-desc"><?php esc_html_e( 'Users with saved phone numbers.', 'awp' ); ?></span>
                                <div class="progress" role="progressbar"
                                     aria-valuemin="0" aria-valuemax="100"
                                     aria-valuenow="<?php echo (int)$percent_added; ?>"
                                     aria-label="<?php esc_attr_e( 'Phone numbers added progress', 'awp' ); ?>">
                                    <div class="progress__bar blue" style="width: <?php echo $percent_added; ?>%;"></div>
                                </div>
                            </div>
                            <div class="stats-card">
                                <div class="card-number_wrapper">
                                    <span class="card-number green"><?php echo esc_html( $total_verified ); ?></span>
                                    <span class="awp-badge success"><?php esc_html_e( 'Verified', 'awp' ); ?></span>
                                </div>
                                <span class="card-label"><?php esc_html_e( 'Completed Verification', 'awp' ); ?><span class="progress__label"><?php esc_html_e( ' [ ' . $percent_verified_display . '% ]', 'awp' ); ?></span></span>
                                <span class="stats-desc"><?php esc_html_e( 'Accounts successfully verified.', 'awp' ); ?></span>
                                <div class="progress" role="progressbar"
                                     aria-valuemin="0" aria-valuemax="100"
                                     aria-valuenow="<?php echo (int)$percent_verified; ?>"
                                     aria-label="<?php esc_attr_e( 'Verification progress', 'awp' ); ?>">
                                    <div class="progress__bar green" style="width: <?php echo $percent_verified; ?>%;"></div>
                                </div>
                            </div>
                            <div class="stats-card">
                                <div class="card-number_wrapper">
                                    <span class="card-number orange"><?php echo esc_html( $total_not_verified ); ?></span>
                                    <span class="awp-badge warning"><?php esc_html_e( 'Pending', 'awp' ); ?></span>
                                </div>
                                <span class="card-label"><?php esc_html_e( 'Pending Verification', 'awp' ); ?><span class="progress__label"><?php esc_html_e( ' [ ' . $percent_pending_display . '% ]', 'awp' ); ?></span></span>
                                <span class="stats-desc"><?php esc_html_e( 'Need to complete verification.', 'awp' ); ?></span>
                                <div class="progress" role="progressbar"
                                     aria-valuemin="0" aria-valuemax="100"
                                     aria-valuenow="<?php echo (int)$percent_pending; ?>"
                                     aria-label="<?php esc_attr_e( 'Pending verification progress', 'awp' ); ?>">
                                    <div class="progress__bar orange" style="width: <?php echo $percent_pending; ?>%;"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <h3 class="section-title"><?php esc_html_e( 'Core', 'awp' ); ?></h3>
                    
                    <div class="awp-features_section">
    
                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Unique Message IDs.svg' ); ?>" alt="Message ID Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="<?php echo esc_attr( class_exists('Wawp_Api_Url') ? Wawp_Api_Url::OPT_TRACKING_IDS : 'awp_enable_tracking_ids' ); ?>" <?php checked( $is_tracking_ids_enabled, 1 ); ?> onchange="handleToggle(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Unique Message IDs', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Prevent bans with unique WhatsApp message identifiers.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/wawp-plugin-dashboard/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/System Information.svg' ); ?>" alt="System Info Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_system_info_enabled" <?php checked($is_system_info_enabled, 1); ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e('System Information', 'awp'); ?></h4>
                                    <p><?php esc_html_e('Review site configuration and Wawp feature status.', 'awp'); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/wawp-system-status/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url('admin.php?page=' . AWP_MAIN_MENU_SLUG . '&awp_section=system_info') ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo $is_system_info_enabled ? 'flex' : 'none'; ?>;">
                                            <i class="ri-eye-line"></i>
                                            <span><?php esc_html_e( 'View Status', 'awp' ); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h3 class="section-title"><?php esc_html_e( 'Engagement & Retention', 'awp' ); ?></h3>
                    <div class="awp-features_section">
                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/WhatsApp Chat Button.svg' ); ?>" alt="WhatsApp Chat Button Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_chat_widget_enabled" <?php checked( $is_chat_widget_enabled, 1 ); ?> <?php echo $chatbutton_allowed ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'WhatsApp Chat Button', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Add floating chat button with analytics tracking.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/whatsapp-chat-button/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=chat_widget' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_chat_widget_enabled && $chatbutton_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $chatbutton_allowed ) : ?>
                                            <a href="https://wawp.net/product/whatsapp-chat-button/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Notifications Builder.svg' ); ?>" alt="Notifications Builder Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_notifications_enabled" <?php checked( $is_notifications_enabled, 1 ); ?> <?php echo $notifications_allowed ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Automated Notifications', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Send automated email/WhatsApp based on user actions.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/automated-notifications/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=notifications' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_notifications_enabled && $notifications_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $notifications_allowed ) : ?>
                                            <a href="https://wawp.net/product/notifications-feature/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php $is_abandoned_carts_enabled = get_option('awp_abandoned_carts_enabled', 1); ?>
                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Abandoned Cart Recovery.svg' ); ?>" alt="Abandoned Cart Recovery Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_abandoned_carts_enabled" <?php checked($is_abandoned_carts_enabled, 1); ?> <?php echo $abandoned_carts_allowed ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Abandoned Cart Recovery', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Track journeys. Detect abandoned carts. Send WhatsApp reminders.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/abandoned-carts/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url('admin.php?page=' . AWP_MAIN_MENU_SLUG . '&awp_section=abandoned_carts_settings') ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_abandoned_carts_enabled && $abandoned_carts_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $abandoned_carts_allowed ) : ?>
                                            <a href="https://wawp.net/product/abandoned-cart/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Bulk Campaigns.svg' ); ?>" alt="Bulk Campaigns Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_campaigns_enabled" <?php checked( $is_campaigns_enabled, 1 ); ?> <?php echo $segmentation_allowed ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Bulk Campaigns', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Broadcast updates & promotions to segments with scheduling.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/wawp-bulk-campaigns/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=campaigns' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_campaigns_enabled && $segmentation_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $segmentation_allowed ) : ?>
                                            <a href="https://wawp.net/product/whatsapp-campaigns-for-woocommerce/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Multilingual Notifications.svg' ); ?>" alt="Multilingual Notifications-1 Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_multilang_enabled" <?php checked( $is_multilang_enabled, 1 ); ?> <?php echo $multilang_allowed ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Multilingual Notifications', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Send notifications in multiple languages based on user preferences.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/wawp-plugin-dashboard/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=notifications' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_multilang_enabled && $multilang_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $multilang_allowed ) : ?>
                                            <a href="https://wawp.net/pricing/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/WooCommerce Subscription Notifications.svg' ); ?>" alt="WooCommerce Subscription Notifications Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_sub_notifs_enabled" <?php checked( $is_sub_notifs_enabled, 1 ); ?> <?php echo ( $sub_notifs_allowed && $wc_subscriptions_installed ) ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'WooCommerce Subscription Notifications', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Email/WhatsApp subscription renewals, cancellations, and updates.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/wawp-plugin-dashboard/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=notifications' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_sub_notifs_enabled && $sub_notifs_allowed && $wc_subscriptions_installed ) ? 'flex' : 'none'; ?>;">                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $sub_notifs_allowed ) : ?>
                                            <a href="https://wawp.net/pricing/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                        <?php if ( $sub_notifs_allowed && ! $wc_subscriptions_installed ) : ?>
                                            <span class="awp-badge" style="background:orange;color:#fff;margin-left:4px;"><?php esc_html_e( 'WooCommerce Subscriptions plugin not active', 'awp' ); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                   </div>
                   
                    <h3 class="section-title"><?php esc_html_e( 'Authentication & User Management', 'awp' ); ?></h3>
                    <div class="awp-features_section">
                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Advanced Phone Field.svg' ); ?>" alt="Advanced Phone Field Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_countrycode_enabled" <?php checked( $is_countrycode_enabled, 1 ); ?> <?php echo $countrycode_allowed ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Advanced Phone Field', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Add country code selection directly into any phone field.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/advanced-country-code/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=settings' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_countrycode_enabled && $countrycode_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $countrycode_allowed ) : ?>
                                            <a href="https://wawp.net/product/country-code-selector/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Login & Single Sign-on.svg' ); ?>" alt="Login & Single Sign-on Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_otp_login_enabled" <?php checked( $is_otp_login_enabled, 1 ); ?> <?php echo ( $is_wawp_otp_enabled && $login_otp_allowed ) ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Passwordless Login', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Enable one-time password login via WhatsApp or email.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/passwordless-login/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=otp_messages&tab=tab-otp-login' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_otp_login_enabled && $login_otp_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $login_otp_allowed ) : ?>
                                            <a href="https://wawp.net/product/otp-login-feature/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Registration Form Builder.svg' ); ?>" alt="Registration Form Builder Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_signup_enabled" <?php checked( $is_signup_enabled, 1 ); ?> <?php echo ( $is_wawp_otp_enabled && $signup_otp_allowed ) ? '' : 'disabled'; ?> onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Registration Form Builder', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Customizable registration form with email/WhatsApp verification.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/registration-form/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=otp_messages&tab=tab-signup' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_signup_enabled && $signup_otp_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $signup_otp_allowed ) : ?>
                                            <a href="https://wawp.net/product/otp-signup-feature/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/WooCommerce Checkout Verification.svg' ); ?>" alt="WooCommerce Checkout Verification Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_checkout_otp_enabled"
                                            <?php checked( $is_checkout_otp_enabled, 1 ); ?>
                                            <?php echo ( $woocommerce_installed && $checkout_otp_allowed ) ? '' : 'disabled'; ?>
                                            onchange="handleToggle(this); awpToggleIconVisibility(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'WooCommerce Checkout Verification', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'WhatsApp verification at checkout to prevent fraud & fake orders.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/checkout-verification/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=otp_messages&tab=tab-checkout' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo ( $is_checkout_otp_enabled && $checkout_otp_allowed ) ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $checkout_otp_allowed ) : ?>
                                            <a href="https://wawp.net/product/checkout-otp-feature/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="awp-card">
                            <div class="awp-toggle-group awp-toggle-main">
                                <div class="card-header">
                                    <div class="feature_enabling">
                                        <img src="<?php echo esc_url( $icons_url . '/features/Custom Authentication Pages.svg' ); ?>" alt="Custom Authentication Pages Icon" <?php echo $icon_style; ?>>
                                        <label class="awp-switch">
                                            <input type="checkbox" data-option="awp_custom_pages_enabled" <?php checked( $is_custom_pages_enabled, 1 ); ?> onchange="handleToggle(this);">
                                            <span class="awp-slider"></span>
                                        </label>
                                    </div>
                                    <h4 class="card-title"><?php esc_html_e( 'Custom Authentication Pages', 'awp' ); ?></h4>
                                    <p><?php esc_html_e( 'Create custom pages and redirects for login, signup.', 'awp' ); ?></p>
                                    <div class="awp-card_actions">
                                        <a href="https://help.wawp.net/en_US/about-authentication-pages-settings/" class="awp-btn" target="_blank">
                                            <i class="ri-book-open-line"></i>
                                            <span><?php esc_html_e( 'Docs', 'awp' ); ?></span>
                                        </a>
                                        <a href="<?php echo esc_url( admin_url( 'admin.php?page=wawp&awp_section=otp_messages&tab=tab-login-signup-pages' ) ); ?>" class="awp-setting-icon awp-btn" style="display:<?php echo $is_custom_pages_enabled ? 'flex' : 'none'; ?>;">
                                            <i class="ri-settings-line"></i>
                                            <span><?php esc_html_e( 'Settings', 'awp' ); ?></span>
                                        </a>
                                        <?php if ( ! $checkout_otp_allowed ) : ?>
                                            <a href="https://wawp.net/product/checkout-otp-feature/" target="_blank"><span class="awp-btn golden-btn"><i class="ri-vip-crown-2-line"></i><?php esc_html_e( 'Get Addon', 'awp' ); ?></span></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

add_filter(
    'pre_count_users',
    function ( $override ) {
        if ( ! function_exists( 'get_current_screen' ) ) {
            return $override;
        }
        $screen = get_current_screen();
        if ( ! $screen || 'toplevel_page_wawp' !== $screen->id ) {
            return $override; 
        }

        if ( ! empty( $override ) ) {
            return $override;
        }
        $total = get_transient( 'wawp_total_users' );
        if ( false === $total ) {
            global $wpdb;
            $total = (int) $wpdb->get_var( "SELECT COUNT(ID) FROM {$wpdb->users}" );
            set_transient( 'wawp_total_users', $total, HOUR_IN_SECONDS );
        }
        return [
            'total_users' => $total,
            'avail_roles' => [],
        ];
    }
);

add_action(
    'wp_ajax_awp_save_toggle',
    function () {
        check_ajax_referer( 'awp_live_toggle_nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( 'Unauthorized', 403 );
        }
        $option_name  = isset( $_POST['option_name'] ) ? sanitize_key( $_POST['option_name'] ) : '';
        $option_value = isset( $_POST['option_value'] ) ? (int) $_POST['option_value'] : 0;
        if ( $option_name ) {
            update_option( $option_name, $option_value );
            wp_send_json_success();
        }
        wp_send_json_error( 'Missing option name', 400 );
    }
);
