jQuery(function($) {
    var startTime = Date.now();
    var maxScroll = 0;
    
    $(window).on('load', function () {
        setTimeout(sendTrackingData, 1000);
    }); 

    var hasSentReferrer = false;

    function updateScroll() {
        var scrollTop = $(window).scrollTop();
        var docHeight = $(document).height();
        var winHeight = $(window).height();
        var scrollPercent = (scrollTop / (docHeight - winHeight)) * 100;
        if (scrollPercent > maxScroll) {
            maxScroll = Math.round(scrollPercent);
        }
    }

    function sendTrackingData () {
        updateScroll();
        var now = Date.now();

        var data = {
            action: 'wac_track_page',
            page_url: window.location.href,
            page_title: document.title,
            timestamp: Math.floor(now / 1000),
            time_spent: Math.round((now - startTime) / 1000),
            scroll_percent: maxScroll,
            // ADD THIS LINE
            screen_size: window.screen.width + 'x' + window.screen.height
        };
        if (!hasSentReferrer) {
            data.referrer = document.referrer;
            hasSentReferrer = true;
        }

        if (navigator.sendBeacon) {
            const ok = navigator.sendBeacon(
                wac_track_params.ajax_url,
                new URLSearchParams(data)
            );
            if (!ok) { $.post(wac_track_params.ajax_url, data); }
        } else {
            $.post(wac_track_params.ajax_url, data);
        }

        startTime = now;
        maxScroll = 0;
    }

    $(window).on('beforeunload', sendTrackingData);

    $('a').on('click', function() {
        sendTrackingData();
    });

    setInterval(sendTrackingData, 10000);

    $(window).on('scroll', updateScroll);
});