jQuery(function($) {
    var debounceTimer;
    
    function sendBillingData() {
        var data = {
            action: 'wac_capture_billing_fields'
        };

        // Iterate over all input and select elements whose name starts with "billing_"
        $('input[name^="billing_"], select[name^="billing_"]').each(function(){
            var field = $(this).attr('name');
            data[field] = $(this).val();
        });

        // console.log("Sending Billing Data:", data); // Debugging to check if data is being sent

        // Use $.post for AJAX request
        $.post(wac_params.ajax_url, data);
    }

    // Attach blur and change event listeners to billing fields
    // Using 'blur' for immediate capture when a field loses focus
    // Using 'change' for select elements or when input values change
    $('body').on('blur change', 'input[name^="billing_"], select[name^="billing_"]', function(){
        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(sendBillingData, 500); // Debounce to prevent excessive AJAX calls
    });
});
