jQuery(document).ready(function($) {
    // --- NEW: A flag to track if the initial delay period is over ---
    let canShowPopup = (popupSettings.popupInitialDelay === 0);

    // --- NEW: If a delay is set, use a timer to update the flag ---
    if (!canShowPopup) {
        setTimeout(function() {
            canShowPopup = true;
            // After the delay, trigger the initial popup check
            showPopup(false);
        }, popupSettings.popupInitialDelay * 1000);
    }

    var popup = $('#pnp-popup');
    var closeButtons = $('.pnp-close, #pnp-close-success');
    var savePhoneButton = $('#pnp-save-phone');
    var phoneNumberInput = $('#billing_phone_popup');
    var errorMessageDisplay = $('#pnp-error-message');
    var successState = $('.pnp-success-state');
    var popupBody = $('.pnp-popup-body');

    // Helper functions for cookies
    function getCookie(name) {
        var match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
        return match ? match[2] : null;
    }

    function setCookie(name, value, seconds) {
        var expires = "";
        if (seconds) {
            var date = new Date();
            date.setTime(date.getTime() + (seconds * 1000));
            expires = "; expires=" + date.toUTCString();
        }
        document.cookie = name + "=" + value + expires + "; path=/";
    }

    var visitorPhone = getCookie('visitor_phone');
    var popupClosedUntil = getCookie('popup_closed_until');
    var currentTime = Date.now();

    sessionStorage.removeItem('phone_entered');

    function shouldShowPopup() {
        if (visitorPhone) return false;
        if (!popupSettings.enablePopup) return false;
        if (popupClosedUntil && Number(popupClosedUntil) > currentTime) return false;
        
        var isUserLoggedIn = $('body').hasClass('logged-in');
        if (popupSettings.popupDisplay === 'logged_in' && !isUserLoggedIn) return false;
        if (popupSettings.popupDisplay === 'guest' && isUserLoggedIn) return false;
        if (popupSettings.popupDisplay === 'disabled') return false;

        if (popupSettings.popupWhere === 'exclude') {
            var currentPageId = $('body').attr('class').match(/page-id-(\d+)/);
            if (currentPageId && popupSettings.popupExcludePages.includes(parseInt(currentPageId[1]))) {
                return false;
            }
        }
        return true;
    }

    function showPopup(force = false) {
        // --- NEW: Check if the delay period is over before showing ---
        if (!canShowPopup) {
            return;
        }

        if (force) {
            if (visitorPhone || (popupClosedUntil && Number(popupClosedUntil) > currentTime)) {
                return;
            }
            popup.addClass('show').css('display', 'flex');
        } else {
            if (shouldShowPopup()) {
                popup.addClass('show').css('display', 'flex');
            }
        }
    }

    // --- MODIFIED: On window load, only show if there's no delay.
    // If there is a delay, the setTimeout at the top will handle it.
    $(window).on('load', function() {
        if (canShowPopup) {
            showPopup(false);
        }
    });

    closeButtons.on('click', function(e) {
        e.preventDefault();
        popup.removeClass('show').hide();
        setCookie('popup_closed_until', currentTime + (popupSettings.closeHideDuration * 1000), popupSettings.closeHideDuration);
    });

    $(document).on('click', function(e) {
        if (popup.hasClass('show') && !$(e.target).closest('.pnp-popup-content').length) {
            popup.removeClass('show').hide();
            setCookie('popup_closed_until', currentTime + (popupSettings.closeHideDuration * 1000), popupSettings.closeHideDuration);
        }
    });

    if (popupSettings.triggerExit) {
        $(document).on('mouseleave', function(e) {
            if (e.clientY < 0) {
                showPopup(true);
            }
        });
    }

    if (popupSettings.triggerCart) {
        $(document.body).on('added_to_cart', function() {
            showPopup(true);
        });
    }

    if (performance && performance.navigation && performance.navigation.type === performance.navigation.TYPE_RELOAD) {
        popup.removeClass('show').hide();
    }

    function sanitizePhone(raw) {
        return (raw || '').replace(/[^\d]/g, '');
    }
    function isValidPhone(digitsOnly) {
        return digitsOnly.length >= 7 && digitsOnly.length <= 15;
    }

    savePhoneButton.on('click', function() {
        errorMessageDisplay.hide();

        var rawInput = phoneNumberInput.val();
        var phoneDigits = sanitizePhone(rawInput);

        if (isValidPhone(phoneDigits)) {
            var phoneNumber = phoneDigits;
            savePhoneButton.attr('disabled', true).find('.button-text').hide().end().find('.loading-spinner').show();

            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'pnp_save_phone_number',
                    phone_number: phoneNumber
                },
                success: function(response) {
                    savePhoneButton.attr('disabled', false).find('.loading-spinner').hide().end().find('.button-text').show();
                    if (response.success) {
                        if (response.data.status === 'exists') {
                            errorMessageDisplay.text(response.data.message).css('color', 'orange').show();
                        } else {
                            setCookie('visitor_phone', phoneNumber, 30 * 24 * 60 * 60);
                            visitorPhone = phoneNumber;
                            
                            $('#billing_phone, #awp_whatsapp, #awp_phone, #awp_user_phone').val(phoneNumber);
                            popupBody.fadeOut(300, function() {
                                successState.fadeIn(300);
                            });
                        }
                    } else {
                        errorMessageDisplay.text(response.data.message).css('color', 'red').show();
                    }
                },
                error: function(xhr, status, error) {
                    savePhoneButton.attr('disabled', false).find('.loading-spinner').hide().end().find('.button-text').show();
                    console.error('AJAX Error: ' + status + ' - ' + error);
                    errorMessageDisplay.text('Error saving phone number. Please try again.').css('color', 'red').show();
                }
            });
        } else {
            errorMessageDisplay.text('Please enter a valid phone number (7–15 digits).').css('color', 'red').show();
        }
    });

    if (visitorPhone) {
        phoneNumberInput.val(visitorPhone);
    }
});