jQuery(document).ready(function($) {
    const tabsContainer = $('#awp-sender-tabs');
    const tabPanes = $('.awp-tab-pane');
    const senderToggles = {
        '#awp_sender_toggle_email': '[href="#tab-email"]',
        '#awp_sender_toggle_wa': '[href="#tab-wa"]',
        '#awp_sender_toggle_meta': '[href="#tab-meta"]',
        '#awp_sender_toggle_block': '[href="#tab-block"]'
    };

    function displayAdminNotice(msg, type = 'success') {
        $('.awp-admin-notice-global .awp-admin-notice').remove();
        const notice = $(`<div class="notice notice-${type} is-dismissible awp-admin-notice"><p>${msg}</p></div>`);
        $('.awp-admin-notice-global').first().append(notice);
        if (type === 'success' || type === 'info') {
            setTimeout(function() {
                notice.fadeOut(500, function() {
                    $(this).remove();
                });
            }, 10000);
        }
    }

    function updateTabVisibility() {
        const activeHref = tabsContainer.find('.nav-tab-active').attr('href');
        let activeTabIsVisible = false;

        if (activeHref) {
            const activeToggle = Object.keys(senderToggles).find(key => senderToggles[key] === activeHref);
            if (activeToggle) {
                if ($(activeToggle).is(':checked')) {
                    activeTabIsVisible = true;
                }
            } else {
                activeTabIsVisible = true; // Senders tab is always visible
            }
        }

        $.each(senderToggles, function(toggleSelector, tabLinkSelector) {
            const isChecked = $(toggleSelector).is(':checked');
            tabsContainer.find(tabLinkSelector).toggle(isChecked);
        });

        if (!activeTabIsVisible && !window.location.hash) {
            const firstVisibleTab = tabsContainer.find('a:visible').first();
            if (firstVisibleTab.length) {
                activatePane(firstVisibleTab.attr('href'), false);
            }
        }
    }

    function activatePane(hash, skipHistory) {
        const $targetLink = tabsContainer.find(`[href="${hash}"]`);

        if (!$targetLink.length || !$targetLink.is(':visible')) {
            const firstVisibleTab = tabsContainer.find('a:visible').first();
            if (firstVisibleTab.length) {
                activatePane(firstVisibleTab.attr('href'), skipHistory);
            }
            return;
        }

        tabsContainer.find('a').removeClass('nav-tab-active');
        $targetLink.addClass('nav-tab-active');

        tabPanes.hide().removeClass('active');
        $(hash).show().addClass('active');

        if (!skipHistory) {
            try {
                history.replaceState(null, '', window.location.pathname + window.location.search + hash);
            } catch (e) {
                console.warn("Could not update URL hash:", e);
            }
        }
    }

    // Fix #2: Remember active tab by updating form actions
    function updateFormActions() {
        const currentHash = window.location.hash || '#tab-senders';
        $('form').each(function() {
            const currentAction = $(this).attr('action') || '';
            const newAction = currentAction.split('#')[0] + currentHash;
            $(this).attr('action', newAction);
        });
    }

    // Initial setup on page load — honor the URL hash first
    updateTabVisibility();
    const initialHash = window.location.hash;
    const $initialTab = tabsContainer.find(`[href="${initialHash}"]`);

    if (initialHash && $initialTab.length) {
        activatePane(initialHash, true);
    } else {
        activatePane(tabsContainer.find('a:visible').first().attr('href'), true);
    }
    updateFormActions();


    // Event Handlers
    tabsContainer.on('click', 'a', function(e) {
        e.preventDefault();
        activatePane($(this).attr('href'), false);
        updateFormActions();
    });

    $(window).on('hashchange', function() {
        activatePane(window.location.hash, true);
        updateFormActions();
    });

    $('input[name^="awp_senders_enabled"]').on('change', function() {
        // Reflect immediately in the UI
        updateTabVisibility();

        const $toggles = $('input[name^="awp_senders_enabled"]');
        const $form = $('#awp-senders-form');
        const nonce = $form.find('[name="awp_save_senders_nonce"]').val();

        // snapshot to allow revert on failure
        const state = {
            email: $('#awp_sender_toggle_email').is(':checked') ? 1 : 0,
            wa: $('#awp_sender_toggle_wa').is(':checked') ? 1 : 0,
            meta: $('#awp_sender_toggle_meta').is(':checked') ? 1 : 0,
            block: $('#awp_sender_toggle_block').is(':checked') ? 1 : 0
        };

        const payload = {
            action: 'awp_ajax_save_senders_settings',
            awp_save_senders_nonce: nonce,
            awp_senders_enabled: state
        };

        // prevent double submits while saving
        $toggles.prop('disabled', true);

        // Use your helper if available; fall back to jQuery if not.
        const onOk = function(res) {
            displayAdminNotice(
                (res && res.data && res.data.message) || 'Sender settings saved.',
                'success'
            );
            // keep current hash so the same tab stays active after reload
            location.replace(window.location.pathname + window.location.search + (window.location.hash || ''));
            location.reload();
        };

        const onFail = function(msg) {
            // revert UI
            $('#awp_sender_toggle_email').prop('checked', !!state.email);
            $('#awp_sender_toggle_wa').prop('checked', !!state.wa);
            $('#awp_sender_toggle_meta').prop('checked', !!state.meta);
            $('#awp_sender_toggle_block').prop('checked', !!state.block);
            updateTabVisibility();

            displayAdminNotice(msg || 'Could not save settings. Please try again.', 'error');
            $toggles.prop('disabled', false);
        };

        if (typeof requestAjax === 'function') {
            requestAjax(payload, function(res) {
                if (res && res.success) return onOk(res);
                onFail(res && res.data && res.data.message);
            });
        } else {
            $.post(ajaxurl, payload)
                .done(function(res) {
                    if (res && res.success) return onOk(res);
                    onFail(res && res.data && res.data.message);
                })
                .fail(function() {
                    onFail();
                });
        }
    });
    let awpPrevSnapshot = null;
    let awpInitialSnapDone = false;

    // Hide the main spinner on initial load; it will be shown only for specific actions.
    $('#awp-loading-spinner').hide();

    function awpDetectChangeAndMaybeReload(rows) {
        const snap = {};
        rows.forEach(r => snap[r.instance_id] = String(r.status).toLowerCase());

        if (!awpInitialSnapDone) {
            awpPrevSnapshot = snap;
            awpInitialSnapDone = true;
            return;
        }

        let changed = false;

        Object.keys(snap).forEach(id => {
            if (!awpPrevSnapshot[id] || awpPrevSnapshot[id] !== snap[id]) {
                changed = true;
            }
        });

        Object.keys(awpPrevSnapshot).forEach(id => {
            if (!snap[id]) {
                changed = true;
            }
        });

        if (changed) {
            sessionStorage.setItem('awpJustReloaded', '1');
            location.reload();
        } else {
            awpPrevSnapshot = snap;
        }
    }

    if (sessionStorage.getItem('awpJustReloaded')) {
        sessionStorage.removeItem('awpJustReloaded');
    }

    function translateStatus(rawStatus) {
        const lower = String(rawStatus).toLowerCase();
        switch (lower) {
            case 'online':
            case 'working':
            case 'ready':
                return awpAjax.online || 'Online';
            case 'offline':
            case 'stopped':
            case 'failed':
                return awpAjax.offline || 'Offline';
            case 'checking':
                return awpAjax.checking || 'Checking';
            case 'scan_qr_code':
            case 'scan qr':
                return 'Scan QR';
            default:
                return awpAjax.unknown || 'Unknown';
        }
    }

    function autoCheckAllInstances() {
        if (typeof awpAjax === 'undefined' || !awpAjax.nonce) return;
        requestAjax({
            action: 'awp_auto_check_all_instance_status',
            nonce: awpAjax.nonce
        }, function(res) {
            if (res.success) {
                if (awpAjax.debugMode) console.log('AutoCheckAllInstances:', res.data.message);
                fetchInstances();
            }
        }, true);
    }

    if (typeof awpAjax !== 'undefined' && awpAjax.nonce) {
        setInterval(() => {
            autoCheckAllInstances();
        }, 300000); // Auto check all listed instances every 5 minutes
    }

    function displayAdminNotice(msg, type = 'success') {
        $('.awp-admin-notice-global .awp-admin-notice').remove();
        const notice = $(`<div class="notice notice-${type} is-dismissible awp-admin-notice"><p>${msg}</p></div>`);
        $('.awp-admin-notice-global').first().append(notice);
        if (type === 'success' || type === 'info') {
            setTimeout(function() {
                notice.fadeOut(500, function() {
                    $(this).remove();
                });
            }, 10000);
        }
    }

    function requestAjax(data, onSuccess, isSilent = false, onError = null) {
        if (!isSilent) {
            $('#awp-loading-spinner').fadeIn(100);
        }
        $.post(awpAjax.ajax_url, data)
            .done(res => {
                if (res.success) {
                    if (typeof onSuccess === 'function') {
                        onSuccess(res);
                    }
                } else {
                    const errorMessage = res.data && res.data.message ? res.data.message : (awpAjax.unexpectedError || 'An unexpected error occurred.');
                    if (typeof onError === 'function') {
                        onError(res.data || {
                            message: errorMessage
                        });
                    } else {
                        displayAdminNotice(errorMessage, 'error');
                    }
                }
            })
            .fail((jqXHR, textStatus, errorThrown) => {
                const errorMsg = `${awpAjax.unexpectedError || 'An unexpected error occurred.'} (Network Error: ${textStatus} ${errorThrown || ''})`;
                if (typeof onError === 'function') {
                    onError({
                        message: errorMsg,
                        raw_response_body_preview: jqXHR.responseText
                    });
                } else {
                    displayAdminNotice(errorMsg, 'error');
                }
            })
            .always(() => {
                if (!isSilent) {
                    $('#awp-loading-spinner').fadeOut(100);
                }
            });
    }

    function fetchInstances() {
        const tbody = $('#awp-table-body');
        tbody.html(`<tr><td colspan="5" style="text-align:center;">${awpAjax.loading || 'Loading...'}</td></tr>`);

        requestAjax({
            action: 'awp_get_all_instances',
            nonce: awpAjax.nonce
        }, res => {
            tbody.empty();

            if (!res.data || !res.data.length) {
                tbody.append(`<tr><td colspan="5" style="text-align:center;">${awpAjax.noInstancesFound || 'No instances found.'}</td></tr>`);
                return;
            }

            res.data.forEach(inst => {
                const instStatus = String(inst.status).toLowerCase();
                const isOnlineLike = ['online', 'working', 'ready', 'scan_qr_code', 'scan qr'].includes(instStatus);

                let dropdownMenuHtml = `<div class="dropdown-menu">
                    <button class="edit-instance">
                        <i class="ri-edit-line"></i> ${awpAjax.edit || 'Edit'}
                    </button>
                    <button class="check-status">
                        <i class="ri-restart-line"></i> ${awpAjax.checkStatus || 'Check Status'}
                    </button>`;

                if (isOnlineLike) {
                    dropdownMenuHtml += `
                        <button class="send-test-message">
                            <i class="ri-send-plane-2-line"></i> ${awpAjax.sendTestMessage || 'Send Test'}
                        </button>
                        <button class="info-instance"><i class="ri-information-line"></i> Session Info</button>
                        <button class="me-instance"><i class="ri-user-line"></i> About Data</button>
                        <button class="stop-instance"><i class="ri-stop-circle-line"></i> Stop Session</button>
                        <button class="logout-instance"><i class="ri-logout-box-line"></i> Logout Session</button>`;
                } else {
                    dropdownMenuHtml += `<button class="connect-qr-instance" data-db-id="${inst.id}" data-instance-id="${inst.instance_id}" data-access-token="${inst.access_token}">
                        <i class="ri-qr-code-line"></i> Connect with QR
                    </button>`;
                }

                dropdownMenuHtml += `<button class="delete-instance">
                        <i class="ri-delete-bin-6-line"></i>${awpAjax.delete || 'Delete'}
                    </button>
                </div>`;

                let row = `<tr data-id="${inst.id}">
                    <td>${inst.name || ''}</td>
                    <td>${inst.instance_id || ''}</td>
                    <td>${inst.access_token || ''}</td>
                    <td class="status awp-status-${instStatus}">
                        <span class="awp-badge">${translateStatus(inst.status)}</span>`;

                if (inst.message && instStatus === 'offline') {
                    row += `<div class="awp-status-reason">${inst.message}</div>`;
                }

                row += `</td><td>
                    <div class="dropdown">
                        <button class="dropdown-toggle">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-ellipsis"><circle cx="12" cy="12" r="1"/><circle cx="19" cy="12" r="1"/><circle cx="5" cy="12" r="1"/>
                            </svg>
                        </button>
                        ${dropdownMenuHtml}
                    </div></td></tr>`;
                tbody.append(row);
            });
            awpDetectChangeAndMaybeReload(res.data);
            const quotaEl = $('#awp-instance-quota');
            if (quotaEl.length) {
                const limit = parseInt(quotaEl.data('limit'), 10) || 0;
                const subUrl = String(quotaEl.data('subscription-url') || 'https://wawp.net/pricing');
                const used = Array.isArray(res.data) ? res.data.length : 0;

                const noun = limit === 1 ? 'number' : 'numbers';
                const linkOpen = `<a href="${subUrl}" target="_blank" rel="noopener noreferrer">`;
                const linkClose = `</a>`;
                const text = `${used} of ${limit} ${noun} are connected. See your ${linkOpen}Subscription${linkClose}.`;
                quotaEl.html(text);
                const addBtn = $('#awp-open-add-modal');
                const scanBtn = $('#awp-scan-qr-btn');
                const codeBtn = $('#awp-connect-by-code-btn');
                const badgeId = 'awp-limit-reached';
                if (used >= limit) {
                    addBtn.hide();
                    scanBtn.hide();
                    codeBtn.hide();
                    if (!$('#' + badgeId).length) {
                        $('<span id="awp-limit-reached" class="awp-badge" style="background:#ef4444;color:#fff;margin-left:8px;">' +
                            (awpAjax.limitReached || 'Instance limit reached.') +
                            '</span>').insertAfter(addBtn);
                    }
                } else {
                    addBtn.show();
                    scanBtn.show();
                    codeBtn.show();
                    $('#' + badgeId).remove();
                }
            }



        }, true);
    }

    $(document).on('click', '.dropdown-toggle', function(event) {
        event.stopPropagation();
        let dropdownMenu = $(this).next('.dropdown-menu');
        $('.dropdown-menu').not(dropdownMenu).removeClass('show');
        dropdownMenu.toggleClass('show');
    });

    $(document).on('click', function(event) {
        if (!$(event.target).closest('.dropdown').length) {
            $('.dropdown-menu').removeClass('show');
        }
    });

    if (typeof awpAjax !== 'undefined' && awpAjax.nonce) {
        fetchInstances();
        autoCheckAllInstances();
    }

    $('#awp-add-modal, #awp-edit-modal, #awp-scan-qr-modal, #awp-connect-by-code-modal, #awp-info-modal, #awp-confirm-modal').on('click', function(e) {
        if ($(e.target).is('.awp-modal')) {
            $(this).fadeOut(200);
            if (sessionPollInterval) {
                clearInterval(sessionPollInterval);
                sessionPollInterval = null;
                window.isCodeFlowActive = false;
            }
        }
    });

    $(document).on('click', '#awp-open-add-modal', e => {
        e.preventDefault();
        $('#awp-name, #awp-instance-id, #awp-access-token').val('');
        $('#awp-add-modal').fadeIn(200);
    });

    $(document).on('click', '#awp-close-add-modal, #awp-close-edit-modal, #awp-close-qr-modal, #awp-close-code-modal, .awp-modal-close', e => {
        e.preventDefault();
        $(e.target).closest('.awp-modal').fadeOut(200);
        if (sessionPollInterval) {
            clearInterval(sessionPollInterval);
            sessionPollInterval = null;
            window.isCodeFlowActive = false;
        }
    });

    $(document).on('click', '#awp-save-add-btn', () => {
        const name = $('#awp-name').val().trim();
        const instanceId = $('#awp-instance-id').val().trim();
        const accessToken = $('#awp-access-token').val().trim();
        if (!name || !instanceId || !accessToken) {
            displayAdminNotice(awpAjax.emptyFields || 'All fields are required.', 'error');
            return;
        }
        $('#awp-add-modal').fadeOut(0);
        requestAjax({
            action: 'awp_add_instance',
            nonce: awpAjax.nonce,
            name: name,
            instance_id: instanceId,
            access_token: accessToken
        }, res => {
            displayAdminNotice(res.data.message, 'success');
            fetchInstances();
        });
    });

    $(document).on('click', '.delete-instance', function() {
        const rowId = $(this).closest('tr').data('id');
        if (!confirm(awpAjax.confirmDelete || 'Are you sure you want to delete this instance?')) return;
        requestAjax({
            action: 'awp_delete_instance',
            nonce: awpAjax.nonce,
            id: rowId
        }, res => {
            displayAdminNotice(res.data.message, 'success');
            fetchInstances();
        });
    });

    $(document).on('click', '.edit-instance', function() {
        const row = $(this).closest('tr');
        $('#edit-id').val(row.data('id'));
        $('#edit-name').val(row.find('td:nth-child(1)').text().trim());
        $('#edit-instance-id').val(row.find('td:nth-child(2)').text().trim());
        $('#edit-access-token').val(row.find('td:nth-child(3)').text().trim());
        $('#awp-edit-modal').fadeIn(200);
    });

    $(document).on('click', '#awp-save-edit-btn', () => {
        const id = $('#edit-id').val().trim();
        const name = $('#edit-name').val().trim();
        const instanceId = $('#edit-instance-id').val().trim();
        const accessToken = $('#edit-access-token').val().trim();
        if (!name || !instanceId || !accessToken) {
            displayAdminNotice(awpAjax.emptyFields || 'All fields are required.', 'error');
            return;
        }
        $('#awp-edit-modal').fadeOut(0);
        requestAjax({
            action: 'awp_edit_instance',
            nonce: awpAjax.nonce,
            id: id,
            name: name,
            instance_id: instanceId,
            access_token: accessToken
        }, res => {
            displayAdminNotice(res.data.text, 'success');
            fetchInstances();
        });
    });

    $(document).on('click', '.check-status', function() {
        const row = $(this).closest('tr');
        const instanceId = row.find('td:nth-child(2)').text().trim();
        const accessToken = row.find('td:nth-child(3)').text().trim();
        requestAjax({
            action: 'awp_update_status',
            nonce: awpAjax.nonce,
            instance_id: instanceId,
            access_token: accessToken
        }, r => {
            displayAdminNotice(`${awpAjax.statusUpdated || 'Status Updated'}: ${translateStatus(r.data.status)}`, 'info');
            fetchInstances();
        });
    });

    $(document).on('click', '.send-test-message', function() {
        const row = $(this).closest('tr');
        const instanceId = row.find('td:nth-child(2)').text().trim();
        const accessToken = row.find('td:nth-child(3)').text().trim();
        requestAjax({
            action: 'awp_send_test_message',
            nonce: awpAjax.nonce,
            instance_id: instanceId,
            access_token: accessToken
        }, r => {
            displayAdminNotice(r.data.message, 'success');
        });
    });

    jQuery(function($) {
        if ($.fn.select2 && $('#wawp_notif_selected_instance').length) {
            $('#wawp_notif_selected_instance').select2({
                placeholder: 'Select instance(s)…',
                allowClear: true,
                width: '100%',
                dropdownParent: $('#wawp_notif_selected_instance').closest('.instance-select')
            });
        }
    });

    /* ───────── SMTP show/hide logic ───────── */
    function awpToggleSmtpFields() {
        const on = jQuery('#awp-smtp-enabled').is(':checked');
        const aut = jQuery('#awp-smtp-auth').is(':checked');
        jQuery('#awp-smtp-settings-fields').toggle(on);
        jQuery('.awp-smtp-auth-fields').toggle(aut && on);
    }
    jQuery(document).on('change', '#awp-smtp-enabled, #awp-smtp-auth', awpToggleSmtpFields);
    jQuery(awpToggleSmtpFields); // run once on page-load

    /* ----- SMTP test button ----- */
    $(document).on('click', '#awp-smtp-test-btn', function(e) {
        e.preventDefault();
        const $btn = $(this).prop('disabled', true);
        const $out = $('#awp-smtp-test-status').text('…');
        const dest = $('#awp-smtp-test-to').val().trim();
        if (!dest) {
            alert('Enter an email.');
            $btn.prop('disabled', false);
            return;
        }
        $.post(awpAjax.ajax_url, {
            action: 'awp_smtp_send_test_email',
            nonce: awpAjax.nonce,
            to: dest
        }).done(r => {
            $out.text(r.success ? r.data : r.data.message);
        }).fail(() => {
            $out.text('AJAX error.');
        }).always(() => $btn.prop('disabled', false));
    });

    /* ----- Test CONNECTION (no email) ------------------- */
    $(document).on('click', '#awp-smtp-test-conn', function(e) {
        e.preventDefault();
        const $btn = $(this).prop('disabled', true);
        const $out = $('#awp-smtp-test-status').text('…');

        /* grab current form values (so user can test before saving) */
        const grab = id => jQuery(id).val();
        const data = {
            host: grab('[name="awp_smtp[host]"]'),
            port: grab('[name="awp_smtp[port]"]'),
            encryption: grab('[name="awp_smtp[encryption]"]'),
            auth: jQuery('#awp-smtp-auth').is(':checked') ? 1 : 0,
            user: grab('[name="awp_smtp[user]"]'),
            pass: grab('[name="awp_smtp[pass]"]')
        };

        jQuery.post(awpAjax.ajax_url, {
            action: 'awp_smtp_test_connection',
            nonce: awpAjax.nonce,
            smtp: data
        }).done(r => {
            $out.text(r.success ? r.data : r.data);
        }).fail(() => {
            $out.text('AJAX error.');
        }).always(() => $btn.prop('disabled', false));
    });

    // ====================================================================
    // NEW SCRIPTING FOR QR & CODE CONNECTION
    // ====================================================================
    let sessionPollInterval = null;
    window.isCodeFlowActive = false; // Global flag for code flow UI
    const wawpApiBase = 'https://wawp.net/wp-json/awp/v1';

    function pollSessionStatus(instanceId, accessToken, instanceName, dbRowId = null) {
        $.ajax({
            url: `${wawpApiBase}/session/info`,
            method: 'GET',
            data: {
                instance_id: instanceId,
                access_token: accessToken
            },
            success: function(response) {
                const status = (response.status || '').toUpperCase();
                
                // Prevent overwriting the "Code Sent" message
                if (window.isCodeFlowActive && (status === 'SCAN_QR_CODE' || status === 'SCAN QR')) {
                    return; 
                }
                $('#awp-qr-status-text, #awp-code-status-text').text(`Status: ${status}...`);

                if (status === 'WORKING' || status === 'ONLINE' || status === 'READY') {
                    clearInterval(sessionPollInterval);
                    sessionPollInterval = null;
                    window.isCodeFlowActive = false;

                    let action = dbRowId ? 'awp_edit_instance' : 'awp_add_instance';
                    let data = {
                        action: action,
                        nonce: awpAjax.nonce,
                        name: instanceName,
                        instance_id: instanceId,
                        access_token: accessToken
                    };
                    if (dbRowId) {
                        data.id = dbRowId;
                    }

                    requestAjax(data, (res) => {
                         let successMsg = dbRowId ? 'Instance reconnected and updated!' : 'Instance connected and saved!';
                        displayAdminNotice(res.data.message || successMsg, 'success');
                        $('#awp-scan-qr-modal, #awp-connect-by-code-modal').fadeOut(200);
                        fetchInstances();
                    });
                }
            },
            error: function(xhr) {
                console.error("Polling error:", xhr.responseText);
            }
        });
    }

    function startQrScan(instanceId = null, accessToken = null, dbRowId = null) {
        const modal = $('#awp-scan-qr-modal');
        const qrImg = $('#awp-qr-image');
        const statusText = $('#awp-qr-status-text');
        const spinner = modal.find('.awp-spinner');

        qrImg.hide();
        spinner.show();
        statusText.text('Preparing session...');
        modal.fadeIn(200);

        const processQr = (instId, accToken, instName) => {
            statusText.text('Fetching QR Code...');
            spinner.show();
            qrImg.hide();

            $.ajax({
                url: `${wawpApiBase}/getQr`,
                method: 'GET',
                data: {
                    instance_id: instId,
                    access_token: accToken
                },
                success: function(response) {
                    if (response.qr) {
                        qrImg.attr('src', response.qr).show();
                        spinner.hide();
                        statusText.text('Scan the code with your WhatsApp app.');
                        if (sessionPollInterval) clearInterval(sessionPollInterval);
                        sessionPollInterval = setInterval(pollSessionStatus, 5000, instId, accToken, instName, dbRowId);
                    } else {
                        statusText.text('Failed to get QR code. Please close and try again.');
                        spinner.hide();
                    }
                },
                error: function(xhr) {
                    statusText.text('Error fetching QR code. ' + (xhr.responseJSON?.message || 'Please close and try again.'));
                    spinner.hide();
                }
            });
        };

        const waitForReadyState = (instId, accToken, instName, onReady, retryCount = 0, hasRestarted = false) => {
            const maxRetries = 15;
            const retryInterval = 5000;

            if (retryCount >= maxRetries) {
                statusText.text('Session failed to start in time. Please try again.');
                spinner.hide();
                return;
            }

            $.ajax({
                url: `${wawpApiBase}/session/info`,
                method: 'GET',
                data: {
                    instance_id: instId,
                    access_token: accToken
                },
                success: function(response) {
                    const status = (response.status || '').toUpperCase();
                    if (status === 'SCAN QR' || status === 'SCAN_QR_CODE' || status === 'READY' || status === 'WORKING' || status === 'ONLINE') {
                        onReady(instId, accToken, instName);
                    } else if (status === 'STARTING') {
                        statusText.text(`Waiting for session... (Status: ${status})`);
                        setTimeout(() => waitForReadyState(instId, accToken, instName, onReady, retryCount + 1, hasRestarted), retryInterval);
                    } else if (status === 'FAILED' && !hasRestarted) {
                        statusText.text(`Session failed. Attempting to restart...`);
                        $.ajax({
                            url: `${wawpApiBase}/session/restart`,
                            method: 'POST',
                            data: {
                                instance_id: instId,
                                access_token: accToken
                            },
                            success: function() {
                                statusText.text('Restart initiated. Checking status again...');
                                setTimeout(() => waitForReadyState(instId, accToken, instName, onReady, retryCount + 1, true), retryInterval);
                            },
                            error: function() {
                                statusText.text('Failed to restart the session. Please try again manually.');
                                spinner.hide();
                            }
                        });
                    } else {
                        // Keep polling if status is not final
                         statusText.text(`Waiting for session... (Status: ${status})`);
                        setTimeout(() => waitForReadyState(instId, accToken, instName, onReady, retryCount + 1, hasRestarted), retryInterval);
                    }
                },
                error: function() {
                    statusText.text('Error checking session status. Retrying...');
                    setTimeout(() => waitForReadyState(instId, accToken, instName, onReady, retryCount + 1, hasRestarted), retryInterval);
                }
            });
        };
        
        const createNewSessionAndConnect = (name, isUpdate = false) => {
            const instanceName = name || 'Wawp-wp-' + Math.floor(10000000 + Math.random() * 90000000);
            statusText.text('Creating new session...');
            $.ajax({
                url: `${wawpApiBase}/createSession`,
                method: 'POST',
                data: {
                    name: instanceName,
                    access_token: window.awp_main_access_token
                },
                success: function(response) {
                    const newInstanceId = response.config?.metadata?.instance_id;
                    const newAccessToken = response.config?.metadata?.access_token;
                    if (newInstanceId && newAccessToken) {
                        statusText.text('Session created. Waiting for initialization...');
                        setTimeout(() => {
                           waitForReadyState(newInstanceId, newAccessToken, instanceName, processQr, 0, false);
                        }, 5000);
                    } else {
                        statusText.text('Failed to create a new session.');
                        spinner.hide();
                    }
                },
                error: function(xhr) {
                    statusText.text('Error creating session: ' + (xhr.responseJSON?.message || 'Please check your connection.'));
                    spinner.hide();
                }
            });
        };

        if (instanceId && accessToken) {
            const row = $(`tr[data-id="${dbRowId}"]`);
            const name = row.find('td:first').text().trim();
             $.ajax({
                url: `${wawpApiBase}/session/info`,
                method: 'GET',
                data: { instance_id: instanceId, access_token: accessToken },
            }).done(function() {
                waitForReadyState(instanceId, accessToken, name, processQr, 0, false, dbRowId);
            }).fail(function() {
                createNewSessionAndConnect(name, true);
            });
        } else {
            createNewSessionAndConnect();
        }
    }

    function startConnectByCode(instanceId = null, accessToken = null, dbRowId = null) {
        const modal = $('#awp-connect-by-code-modal');
        const formContainer = $('#awp-code-form-container');
        const statusContainer = $('#awp-code-status-container');
        const statusText = $('#awp-code-status-text');
        const phoneInput = $('#awp-connect-phone-number');
        const spinner = statusContainer.find('.awp-spinner');

        phoneInput.val('');
        formContainer.show();
        statusContainer.hide();
        modal.fadeIn(200);

        const requestCode = (instId, accToken, instName) => {
            const phone = phoneInput.val().trim();
            if (!phone) {
                alert('Please enter a phone number.');
                return;
            }
            formContainer.hide();
            statusContainer.show().css('display', 'flex');
            statusText.text('Requesting code...');

            $.ajax({
                url: `${wawpApiBase}/requestCode`,
                method: 'POST',
                data: {
                    instance_id: instId,
                    access_token: accToken,
                    phone_number: phone
                },
                success: function(response) {
                    if (response.code) {
                        window.isCodeFlowActive = true;
                        statusText.html(`Code sent! Please enter <strong>${response.code}</strong> on your device.<br>Waiting for connection...`);
                        if (sessionPollInterval) clearInterval(sessionPollInterval);
                        sessionPollInterval = setInterval(pollSessionStatus, 5000, instId, accToken, instName, dbRowId);
                    } else {
                        statusText.text('Failed to request code.');
                        formContainer.show();
                        statusContainer.hide();
                    }
                },
                error: function(xhr) {
                    statusText.text('Error: ' + (xhr.responseJSON?.message || 'Failed to request code.'));
                    formContainer.show();
                    statusContainer.hide();
                }
            });
        };

        const onReadyForCode = (instId, accToken, instName) => {
            formContainer.show();
            statusContainer.hide();
            $('#awp-request-code-btn').off('click').on('click', () => requestCode(instId, accToken, instName));
        };

        const waitForReadyState = (instId, accToken, instName, onReady, retryCount = 0, hasRestarted = false) => {
            const maxRetries = 15;
            const retryInterval = 5000;

            if (retryCount >= maxRetries) {
                alert('Session failed to start in time. Please try again.');
                modal.fadeOut(200);
                return;
            }

            $.ajax({
                url: `${wawpApiBase}/session/info`,
                method: 'GET',
                data: {
                    instance_id: instId,
                    access_token: accToken
                },
                success: function(response) {
                    const status = (response.status || '').toUpperCase();
                    if (status === 'SCAN QR' || status === 'SCAN_QR_CODE' || status === 'READY' || status === 'WORKING' || status === 'ONLINE') {
                        onReady(instId, accToken, instName);
                    } else if (status === 'STARTING') {
                        setTimeout(() => waitForReadyState(instId, accToken, instName, onReady, retryCount + 1, hasRestarted), retryInterval);
                    } else if (status === 'FAILED' && !hasRestarted) {
                         $.ajax({
                            url: `${wawpApiBase}/session/restart`,
                            method: 'POST',
                            data: {
                                instance_id: instId,
                                access_token: accToken
                            },
                            success: function() {
                                setTimeout(() => waitForReadyState(instId, accToken, instName, onReady, retryCount + 1, true), retryInterval);
                            },
                            error: function() {
                                alert('Failed to restart the session. Please try again manually.');
                                modal.fadeOut(200);
                            }
                        });
                    } else {
                         // Keep polling if status is not final
                        setTimeout(() => waitForReadyState(instId, accToken, instName, onReady, retryCount + 1, hasRestarted), retryInterval);
                    }
                },
                error: function() {
                    setTimeout(() => waitForReadyState(instId, accToken, instName, onReady, retryCount + 1, hasRestarted), retryInterval);
                }
            });
        };
        
        const createNewSessionAndConnect = (name, isUpdate = false) => {
            const instanceName = name || 'Wawp-wp-' + Math.floor(10000000 + Math.random() * 90000000);
            formContainer.hide();
            statusContainer.show().css('display', 'flex');
            statusText.text('Creating new session...');

            $.ajax({
                url: `${wawpApiBase}/createSession`,
                method: 'POST',
                data: {
                    name: instanceName,
                    access_token: window.awp_main_access_token
                },
                success: function(response) {
                    const newInstanceId = response.config?.metadata?.instance_id;
                    const newAccessToken = response.config?.metadata?.access_token;
                    if (newInstanceId && newAccessToken) {
                        statusText.text('Session created. Waiting for initialization...');
                        setTimeout(() => {
                            waitForReadyState(newInstanceId, newAccessToken, instanceName, onReadyForCode, 0, false);
                        }, 5000);
                    } else {
                        statusText.text('Failed to create a new session.');
                        spinner.hide();
                    }
                },
                error: function(xhr) {
                    statusText.text('Error creating session: ' + (xhr.responseJSON?.message || 'Please check connection.'));
                    spinner.hide();
                }
            });
        };

        if (instanceId && accessToken) {
            const row = $(`tr[data-id="${dbRowId}"]`);
            const name = row.find('td:first').text().trim();
            $.ajax({
                url: `${wawpApiBase}/session/info`,
                method: 'GET',
                data: { instance_id: instanceId, access_token: accessToken },
            }).done(function() {
                waitForReadyState(instanceId, accessToken, name, onReadyForCode, 0, false, dbRowId);
            }).fail(function() {
                createNewSessionAndConnect(name, true);
            });
        } else {
            createNewSessionAndConnect();
        }
    }


    // Main button handlers
    $('#awp-scan-qr-btn').on('click', () => startQrScan());
    $('#awp-connect-by-code-btn').on('click', () => startConnectByCode());

    // Dropdown item handlers
    $(document).on('click', '.connect-qr-instance', function() {
        const dbRowId = $(this).data('db-id');
        const instanceId = $(this).data('instance-id');
        const accessToken = $(this).data('access-token');
        startQrScan(instanceId, accessToken, dbRowId);
    });

    $(document).on('click', '.connect-code-instance', function() {
        const dbRowId = $(this).data('db-id');
        const instanceId = $(this).data('instance-id');
        const accessToken = $(this).data('access-token');
        startConnectByCode(instanceId, accessToken, dbRowId);
    });

    // Dynamically add modals to the page
    $('body').append(`
        <div id="awp-info-modal" class="awp-modal">
            <div class="awp-modal-content">
                <h4 id="awp-info-modal-title" class="card-title">Session Information</h4>
                <pre id="awp-info-modal-body" style="background: #f5f5f5; border: 1px solid #ddd; padding: 10px; border-radius: 4px; max-height: 400px; overflow-y: auto;"></pre>
                <div class="btn-group" style="margin-top:12px;">
                    <button type="button" class="awp-btn awp-modal-close" style="flex:1;">Close</button>
                </div>
            </div>
        </div>
        <div id="awp-confirm-modal" class="awp-modal">
            <div class="awp-modal-content">
                <h4 id="awp-confirm-modal-title" class="card-title">Confirm Action</h4>
                <p id="awp-confirm-modal-body">Are you sure you want to proceed?</p>
                <div class="btn-group" style="margin-top:12px;">
                    <button type="button" class="awp-btn awp-modal-close" style="flex:1;">Cancel</button>
                    <button type="button" class="awp-btn primary" id="awp-confirm-btn" style="flex:1;">Confirm</button>
                </div>
            </div>
        </div>
    `);

    // New action handlers
    function showInfoModal(title, data) {
        $('#awp-info-modal-title').text(title);
        $('#awp-info-modal-body').text(JSON.stringify(data, null, 2));
        $('#awp-info-modal').fadeIn(200);
    }

    $(document).on('click', '.info-instance', function() {
        const row = $(this).closest('tr');
        const instanceId = row.find('td:nth-child(2)').text().trim();
        const accessToken = row.find('td:nth-child(3)').text().trim();

        $.ajax({
            url: `${wawpApiBase}/session/info`,
            method: 'GET',
            data: { instance_id: instanceId, access_token: accessToken },
            beforeSend: () => $('#awp-loading-spinner').fadeIn(100),
            complete: () => $('#awp-loading-spinner').fadeOut(100),
            success: (res) => showInfoModal('Session Info', res),
            error: (xhr) => displayAdminNotice('Error fetching session info: ' + (xhr.responseJSON?.message || 'Check console.'), 'error')
        });
    });

    $(document).on('click', '.me-instance', function() {
        const row = $(this).closest('tr');
        const instanceId = row.find('td:nth-child(2)').text().trim();
        const accessToken = row.find('td:nth-child(3)').text().trim();

        $.ajax({
            url: `${wawpApiBase}/session/me`,
            method: 'GET',
            data: { instance_id: instanceId, access_token: accessToken },
            beforeSend: () => $('#awp-loading-spinner').fadeIn(100),
            complete: () => $('#awp-loading-spinner').fadeOut(100),
            success: (res) => showInfoModal('About WhatsApp Data', res),
            error: (xhr) => displayAdminNotice('Error fetching account data: ' + (xhr.responseJSON?.message || 'Instance may be offline.'), 'error')
        });
    });

    function showConfirmModal(title, body, onConfirm) {
        $('#awp-confirm-modal-title').text(title);
        $('#awp-confirm-modal-body').text(body);
        $('#awp-confirm-btn').off('click').on('click', function() {
            onConfirm();
            $('#awp-confirm-modal').fadeOut(200);
        });
        $('#awp-confirm-modal').fadeIn(200);
    }
    
    $(document).on('click', '.stop-instance', function() {
        const row = $(this).closest('tr');
        const instanceId = row.find('td:nth-child(2)').text().trim();
        const accessToken = row.find('td:nth-child(3)').text().trim();

        showConfirmModal('Stop Session', 'Are you sure you want to stop this session? This will disconnect it temporarily.', () => {
             $.ajax({
                url: `${wawpApiBase}/session/stop`,
                method: 'POST',
                data: { instance_id: instanceId, access_token: accessToken },
                beforeSend: () => $('#awp-loading-spinner').fadeIn(100),
                complete: () => $('#awp-loading-spinner').fadeOut(100),
                success: () => {
                    displayAdminNotice('Session stopped successfully.', 'success');
                    fetchInstances();
                },
                error: (xhr) => displayAdminNotice('Error stopping session: ' + (xhr.responseJSON?.message || 'Please try again.'), 'error')
            });
        });
    });

    $(document).on('click', '.logout-instance', function() {
        const row = $(this).closest('tr');
        const instanceId = row.find('td:nth-child(2)').text().trim();
        const accessToken = row.find('td:nth-child(3)').text().trim();

        showConfirmModal('Logout Session', 'Are you sure you want to log out this session? This will require a new QR scan to reconnect.', () => {
            $.ajax({
                url: `${wawpApiBase}/session/logout`,
                method: 'POST',
                data: { instance_id: instanceId, access_token: accessToken },
                beforeSend: () => $('#awp-loading-spinner').fadeIn(100),
                complete: () => $('#awp-loading-spinner').fadeOut(100),
                success: () => {
                    displayAdminNotice('Session logged out successfully.', 'success');
                    fetchInstances();
                },
                error: (xhr) => displayAdminNotice('Error logging out: ' + (xhr.responseJSON?.message || 'Please try again.'), 'error')
            });
        });
    });


});


