jQuery(document).ready(function($) {
    const settingsForm  = $('#wawp-notif-settings-form');
    const addLangPopup  = $('#wawp-notif-add-lang-popup');
    const editTplPopup  = $('#wawp-notif-edit-template-popup');
    const iconBaseUrl   = wawpNotifData.iconBaseUrl;
    const langs = getConfiguredLanguages(); 

    function toggleLangTabsVisibility () {
        const $tabWrapper = $('.wawp-notif-settings-page .nav-tab-wrapper');
        if (!$tabWrapper.length) return;
    
        const tabCount = $tabWrapper.find('.nav-tab').length;
    
        if (tabCount <= 1) {
            $tabWrapper.hide();
    
            $('.wawp-notif-header-text').each(function () {
                const $h3 = $(this).children('h3');
                const $p  = $(this).children('p');
                if ($h3.text().trim().indexOf('Notification Rules for') === 0) {
                    $h3.text('Setup Notification Passed Trigger');
                }
                if ($p.text().trim().indexOf('Language Code:') === 0) {
                    $p.text('Define how and when your notifications are sent.');
                }
            });
        } else {
            $tabWrapper.show();
        }
    }
    let currentPopupRuleId = null; 
    let currentPopupStep = 0;     
    let activePopupSteps = [];
    
    
    function getTinymceContent(editorId) {
        if (typeof tinymce !== 'undefined' && tinymce.get(editorId) && tinymce.get(editorId).isDirty()) {
            return tinymce.get(editorId).getContent();
        }
        return $('#' + editorId).val();
    }
    
    $(document).on('click', '.add-rule-button', function(e) {
    e.preventDefault();
    const lang = $(this).data('lang');
    if (lang) {
        $('#wawp_notif_add_notification_rule_lang').val(lang);
        settingsForm[0].submit();
    }
    });

    function mapToSenderType(recipient, channelsArr) {
    const arr = Array.isArray(channelsArr) ? channelsArr : (channelsArr ? [channelsArr] : []);
    if (!recipient || arr.length === 0) {
        return null; 
    }

    let type = recipient; 
    if (arr.includes('whatsapp')) {
        type += '_whatsapp';
    }
    if (arr.includes('email')) {
        type += '_email';
    }
    if (arr.includes('meta_whatsapp')) {
        type += '_meta'; 
    }
    if (type.startsWith('both')) {
        type = 'user_admin' + type.substring(4);
    }
    
    return type;
}

    function splitSenderType(st) {
    if (!st) return ['user', []];

    let recipient = 'user';
    let channels = [];

    if (st.startsWith('user_admin')) {
        recipient = 'both';
    } else if (st.startsWith('admin')) {
        recipient = 'admin';
    }

    if (st.includes('whatsapp')) {
        channels.push('whatsapp');
    }
    if (st.includes('email')) {
        channels.push('email');
    }
    if (st.includes('meta')) {
        channels.push('meta_whatsapp');
    }

    return [recipient, channels];
}

    function initRecipientChannel(ruleId) {
    const $hidden = $('#sender_type_' + ruleId).hide();
    if (!$hidden.length) return;

    const [recInit, chansInit] = splitSenderType($hidden.val());
    $('#send_recipient_' + ruleId).val(recInit);
    $('#send_channel_'   + ruleId).val(chansInit).trigger('change'); 

    $('#send_recipient_' + ruleId + ', #send_channel_' + ruleId).on('change', function () {
        const rec = $('#send_recipient_' + ruleId).val();
        const ch  = $('#send_channel_'  + ruleId).val() || [];
        const mapped = mapToSenderType(rec, ch);
        if (mapped) {
            $hidden.val(mapped).trigger('change');
            refreshCardHeader(ruleId);
        }
    });
}

    $('.wawp-rule-sender-dropdown').each(function () {
    initRecipientChannel($(this).data('rule-id'));
});

    $(document).on('awpNotifRuleAdded', function (e, ruleId) {
    initRecipientChannel(ruleId);
});

    function beautifyRecipientChannel(ruleId){
    const $rec = $('#send_recipient_' + ruleId);
    if ($rec.length && typeof $.fn.select2 !== 'undefined' && !$rec.hasClass('select2-hidden-accessible')) {
        $rec.select2({
            minimumResultsForSearch: Infinity,
            width: 'resolve',
            dropdownParent: $rec.closest('td'),
            templateResult: formatRec, templateSelection: formatRec
        }).next('.select2-container').appendTo($rec.closest('.wawp-send-row'));
    }
    function formatRec(state){
        if(!state.id) return state.text;
        const icon = state.id === 'user' ? 'ri-user-line'
                    : state.id === 'admin'? 'ri-group-line'
                    :                      'ri-group-line';
        return $('<span>').html(`<i class="${icon} wawp-sendto-ico"></i> ${state.text}`);
    }

    const $ch = $('#send_channel_' + ruleId);
    if ($ch.length && typeof $.fn.select2 !== 'undefined' && !$ch.hasClass('select2-hidden-accessible')) {
        $ch.select2({
            multiple: true,
            width: 'resolve',
            dropdownParent: $ch.closest('td'),
            closeOnSelect: false,
            templateResult: formatChan, templateSelection: formatChan
        }).next('.select2-container').appendTo($ch.closest('.wawp-send-row'));
    }
    function formatChan(state){
        if(!state.id) return state.text;
        const icon = state.id === 'whatsapp' ? 'ri-whatsapp-line' 
                   : state.id === 'meta_whatsapp' ? 'ri-whatsapp-line' 
                   : 'ri-mail-line';
        return $('<span>').html(`<i class="${icon} wawp-sendto-ico"></i> ${state.text}`);
    }
}

    $('.wawp-rule-sender-dropdown').each(function(){
    beautifyRecipientChannel($(this).data('rule-id'));
});

    $(document).on('awpNotifRuleAdded', function(e, ruleId){
    beautifyRecipientChannel(ruleId);
});

    function setTinymceContent(editorId, content) {
        if (typeof tinymce !== 'undefined') {
            let editor = tinymce.get(editorId);
            if (editor) {
                editor.setContent(content || ''); 
            } else {
                const $textarea = $('#' + editorId);
                if ($textarea.is(':visible') || $textarea.closest('.step.active').length) {
                    tinymce.init({
                        selector: '#' + editorId,
                        height: 200,
                        menubar: false,
                        teeny: true,
                        toolbar: 'bold italic underline | bullist numlist | link unlink | undo redo',
                        branding: false,
                        plugins: 'lists,link,paste,wordpress,wplink',
                        setup: function(ed) {
                            ed.on('init', function() {
                                ed.setContent(content || '');
                            });
                        }
                    });
                } else {
                        $textarea.val(content || '');
                }
            }
        } else {
            $('#' + editorId).val(content || '');
        }
    }
    function activateLangTab(tabLink) {
        const target = $(tabLink).attr('href');
        if (!target || target === '#') return;
        $('.wawp-notif-tabs .nav-tab').removeClass('nav-tab-active');
        $(tabLink).addClass('nav-tab-active');
        $('.wawp-notif-tab-content').removeClass('active').hide();
        $(target).addClass('active').show();
        $('#wawp_active_tab').val(target);
    }
    const initLangTab = $('#wawp_active_tab').val();
    const firstLangTab = initLangTab && $(`.nav-tab[href="${initLangTab}"]`).length ?
        $(`.nav-tab[href="${initLangTab}"]`) :
        $('.wawp-notif-tabs .nav-tab:first');
    if (firstLangTab.length) activateLangTab(firstLangTab);
    $('.wawp-notif-tabs').on('click', '.nav-tab', function(e) {
        e.preventDefault(); activateLangTab(this);
    });
    $('#wawp-notif-add-lang-button-top, #wawp-notif-add-lang-button').on('click', function(e) {
        e.preventDefault(); addLangPopup.fadeIn();
    });
    $('#wawp-notif-popup-close, #wawp-notif-add-lang-popup').on('click', function(e) {
        if ($(e.target).is('#wawp-notif-popup-close') || $(e.target).is('#wawp-notif-add-lang-popup')) {
            e.preventDefault(); addLangPopup.fadeOut();
        }
    });
    $('#wawp-notif-add-lang-popup .wawp-notif-popup-inner').on('click', function(e) { e.stopPropagation(); });
    $('#wawp-notif-confirm-add-lang').on('click', function() {
        const langCode = $('#wawp-notif-select-language').val();
        if (!langCode) { alert('Please select a language.'); return; }
        $('#wawp_new_language_to_add').val(langCode);
        addLangPopup.fadeOut(); settingsForm[0].submit();
    });

    $('#wawp-notif-add-lang-button-top, #wawp-notif-add-lang-button').on('click', function(e) {
        e.preventDefault();
        addLangPopup.fadeIn();
    });
    $('#wawp-notif-popup-close, #wawp-notif-add-lang-popup').on('click', function(e) {
        if ($(e.target).is('#wawp-notif-popup-close') || $(e.target).is('#wawp-notif-add-lang-popup')) {
            e.preventDefault();
            addLangPopup.fadeOut();
        }
    });
    $('#wawp-notif-add-lang-popup .wawp-notif-popup-inner').on('click', function(e) { 
        e.stopPropagation();
    });
    $('#wawp-notif-confirm-add-lang').on('click', function() {
        const langCode = $('#wawp-notif-select-language').val();
        if (!langCode) {
            alert('Please select a language from the dropdown.');
            return;
        }
        $('#wawp_new_language_to_add').val(langCode);
        addLangPopup.fadeOut();
        settingsForm[0].submit();
    });

    $(document).on('click', '.wawp-notif-remove-lang-button', function(e) {
        e.preventDefault();
        e.stopPropagation();

        const lang      = $(this).data('lang');
        const mainLang  = $('#wawp_notif_main_language_code').val();
        const langName = $(this).closest('.wawp-notif-tab-container')
                                .find('.nav-tab')
                                .text()
                                .replace('(Main)', '')
                                .trim();

        if (lang === mainLang) {
            alert('You cannot remove the Main Language. Please select a different Main Language first.');
            return;
        }

        if (confirm(`Are you sure you want to remove the "${langName}" language configuration and all its rules? This cannot be undone.`)) {
            $('#wawp_remove_language').val(lang);
            settingsForm[0].submit();
        }
    });

    function toggleCardContent($wrapper, expand) {
        if (expand) {
            $wrapper.removeClass('collapsed').addClass('expanded');
            $wrapper.find('.wawp-notif-card-header i.ri-arrow-down-s-line')
                    .removeClass('ri-arrow-down-s-line').addClass('ri-arrow-up-s-line');
        } else {
            $wrapper.removeClass('expanded').addClass('collapsed');
            $wrapper.find('.wawp-notif-card-header i.ri-arrow-up-s-line')
                    .removeClass('ri-arrow-up-s-line').addClass('ri-arrow-down-s-line');
        }
    }
    
    function scrollToCard($wrapper) {
    const adminBar = $('#wpadminbar').length ? $('#wpadminbar').outerHeight() : 0;
    const pad = 12; 
    const top = Math.max(0, $wrapper.offset().top - adminBar - pad);
    $('html, body').stop(true).animate({ scrollTop: top }, 300);
}

    function closeAllCardsExcept($target) {
    const $pane = $target.closest('.wawp-notif-tab-content');
    $pane.find('.wawp-notif-card-wrapper').each(function () {
        const $w = $(this);
        if ($w[0] !== $target[0]) {
            toggleCardContent($w, false);
        }
    });
}

    function openCardAndScroll($wrapper) {
    const $pane   = $wrapper.closest('.wawp-notif-tab-content');
    const tabHref = '#' + $pane.attr('id');
    const $tab    = $('.wawp-notif-tabs .nav-tab[href="' + tabHref + '"]');

    if (!$pane.hasClass('active') && $tab.length) {
        activateLangTab($tab);
    }
    $('#wawp_active_tab').val(tabHref);

    closeAllCardsExcept($wrapper);
    toggleCardContent($wrapper, true);
    const rid = String($wrapper.data('rule-id') || '');
    if (rid) {
        $('#wawp_active_rule_id').val(rid);
        try { sessionStorage.setItem('wawp_active_rule_id', rid); } catch(e) {}
    }

    scrollToCard($wrapper);
}

    toggleLangTabsVisibility(); 
    $('.wawp-notif-card-wrapper').each(function() {
        if (!$(this).find('.wawp-notif-card-header i.ri-arrow-down-s-line, .wawp-notif-card-header i.ri-arrow-up-s-line').length) {
             $(this).find('.wawp-notif-card-header').append('<i class="ri-arrow-down-s-line"></i>');
        }
        if (!$(this).hasClass('expanded')) {
            $(this).addClass('collapsed');
        }
    });

$(document).on('click', '.wawp-notif-card-header', function(e) {
    // Keep the check to ignore clicks on buttons/switches within the header
    if ($(e.target).closest('.wawp-notif-remove-rule-button, .wawp-notif-duplicate-rule-button, .wawp-rule-enable-switch, .wawp-slider, .wawp-notif-edit-button').length) {
         return; // Don't toggle card if clicking an action element
    }

    const $wrapper = $(this).closest('.wawp-notif-card-wrapper');

    // --- NEW LOGIC ---
    // Check if the clicked card is already expanded
    if ($wrapper.hasClass('expanded')) {
        // If it's already open, just close it
        toggleCardContent($wrapper, false);
    } else {
        // Otherwise (it's collapsed), use the existing logic to open this one and close others
        openCardAndScroll($wrapper);
    }
    // --- END NEW LOGIC ---
});

    function setCardEnabled (ruleId, enabled) {

    const $wrapper  = $(`.wawp-notif-card-wrapper[data-rule-id="${ruleId}"]`);
    const $content  = $wrapper.find('.wawp-notif-card-content');
    const $fields = $content
        .find('input, select, textarea, button')
        .not('[type="hidden"]')   
        .not('.wawp-rule-enable-switch, .wawp-rule-enabled-flag, .wawp-slider');

    $content.toggleClass('disabled', !enabled);
    $fields.prop('disabled', !enabled);
    $wrapper.find('.wawp-rule-enabled-flag').val(enabled ? '1' : '0');
}

    $('.wawp-rule-enable-switch').each(function() {
        const ruleId = $(this).data('rule-id');
        
        setCardEnabled(ruleId, $(this).is(':checked'));
    });

    $(document).on('change', '.wawp-rule-enable-switch', function() {
          const ruleId = $(this).data('rule-id');
    setCardEnabled(ruleId, $(this).is(':checked'));
    });
    $(document).on('change', '.wawp-notif-send-timing-select, .delay-fields input, .delay-fields select',
    function () {
        const ruleId = $(this).closest('.wawp-notif-card-wrapper').data('rule-id');
        refreshCardHeader(ruleId);
    });

    const mediaFrames = {};  
    $(document).on('click', '.wawp-notif-media-upload-button', function (e) {
        e.preventDefault();
        const $btn    = $(this);
        const target  = String($btn.data('target') || '').trim();
        if (!target) { alert('Upload button is missing data-target'); return; }

        if (!mediaFrames[target]) {
            mediaFrames[target] = wp.media({
                title   : 'Select media',
                library : { type: [ 'image', 'video' ] },
                button  : { text: 'Use this media' },
                multiple: false
            }).on('select', () => {
                const url = mediaFrames[target]
                                .state()
                                .get('selection')
                                .first()
                                .toJSON().url;
                $(target).val(url).trigger('change');
            });
        }
        window.wpActiveEditor = null; 
        mediaFrames[target].open();
    });

    $(document).on('click', '.insert-media', function () {
        const editorId = $(this).data('editor');
        if (editorId) { window.wpActiveEditor = editorId; }
    });

    function toggleDelayFields(selectElement) {
        const $selectElement    = $(selectElement);
        const selectedValue     = $selectElement.val();
        const $delayFields      = $selectElement.closest('td').find('.delay-fields');
        const $delayValueInput  = $delayFields.find('input[type="number"]');
        const $delayUnitSelect  = $delayFields.find('select');
        const isDisabled = $selectElement.is(':disabled');


        if (selectedValue === 'delayed' && !isDisabled) {
            $delayFields.addClass('active').slideDown();
            $delayValueInput.prop('disabled', false);
            $delayUnitSelect.prop('disabled', false);
        } else {
            $delayFields.removeClass('active').slideUp();
            $delayValueInput.prop('disabled', true);
            $delayUnitSelect.prop('disabled', true);
        }
    }
    $(document).on('change', '.wawp-notif-send-timing-select', function() {
        toggleDelayFields(this);
    });
    $('.wawp-notif-send-timing-select').each(function() {
        toggleDelayFields(this);
    });
    function initializeEmojiOneArea(selector = '.wawp-emojione-editor') {
        $(selector + ':not(.emojionearea-initialized)').each(function() {
            if ($.fn.emojioneArea) {
                $(this).emojioneArea({
                    pickerPosition: 'bottom',
                    tonesStyle: 'bullet',
                    search: true,
                    autocomplete: true,
                    attributes: { spellcheck: true }
                });
                $(this).addClass('emojionearea-initialized');
            }
        });
    }
    initializeEmojiOneArea();

    function initializeEmojiOneAreaForPopup(textareaId) {
        const $textarea = $(`#${textareaId}`);
        if ($textarea.length && !$textarea.hasClass('emojionearea-initialized') && $.fn.emojioneArea) {
            $textarea.emojioneArea({
                pickerPosition: 'bottom',
                tonesStyle: 'bullet',
                search: true,
                autocomplete: true,
                attributes: { spellcheck: true }
            }).addClass('emojionearea-initialized');

            const editor = $textarea.data('emojioneArea');
            if (editor) {
                const $dropdown = $textarea.next('.placeholder-dropdown');
                if ($dropdown.length) {
                    editor.button.after($dropdown);
                }
                editor.setText($textarea.val()); 
            }
        } else if ($textarea.hasClass('emojionearea-initialized') && $textarea.data('emojioneArea')) {
            $textarea.data('emojioneArea').setText($textarea.val());
        }
    }

    $(document).on('change', '#wawp-notif-edit-template-popup .placeholder-dropdown', function() {
        const $dropdown = $(this);
        const placeholder = $dropdown.val();
        const targetId = $dropdown.data('target');

        if (placeholder && targetId) {
            const editor = $('#' + targetId).data('emojioneArea');
            if (editor) {
                editor.editor.focus();
                const sel = window.getSelection();
                if (sel.getRangeAt && sel.rangeCount) {
                    const range = sel.getRangeAt(0);
                    range.deleteContents();
                    range.insertNode(document.createTextNode(placeholder + ' '));
                    range.collapse(false); 
                } else {
                    editor.setText(editor.getText() + placeholder + ' ');
                }
            }
            $dropdown.val('');
        }
    });

    function initSelect2ForRule(ruleId) {
        const $select = $(`#admin_user_ids_${ruleId}`);
        if (!$select.length || !$.fn.select2) return;
        if ($select.hasClass('select2-hidden-accessible')) return; 
        $select.select2({
            placeholder: 'Search users…',
            multiple: true,
            allowClear: true,
            minimumInputLength: 1,
            ajax: {
                url: wawpNotifData.ajaxUrl,
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        action: 'wawp_search_users',
                        nonce: wawpNotifData.nonceSearchUsers,
                        q: params.term
                    };
                },
                processResults: function(data) { return { results: data.results || [] }; },
                cache: true
            },
            dropdownParent: $select.closest('td')
        });
    }

    $('.wawp-admin-user-select').each(function() {
        initSelect2ForRule($(this).data('rule-id'));
    });
    
    function initCountryGatewaySelect2(context = document) {
        if (!$.fn.select2) return;
        $(context).find('.wawp-billing-country-select:not(.select2-hidden-accessible)').each(function() {
            $(this).select2({
                placeholder: 'Select one or more countries…', allowClear: true, width: '100%',
                dropdownParent: $(this).closest('td'), closeOnSelect: false
            });
        });
        $(context).find('.wawp-payment-gateway-select:not(.select2-hidden-accessible)').each(function() {
            $(this).select2({
                placeholder: 'Select one or more gateways…', allowClear: true, width: '100%',
                dropdownParent: $(this).closest('td'), closeOnSelect: false
            });
        });
    }
    initCountryGatewaySelect2();
    
    function initProductSelect2(context=document){
    if(!$.fn.select2) return;
    $(context).find('.wawp-product-select:not(.select2-hidden-accessible)').each(function(){
        $(this).select2({
            placeholder:'Search products…',
            allowClear:true,
            minimumInputLength:2,
            ajax:{
                url: wawpNotifData.ajaxUrl,
                dataType:'json',
                delay:250,
                data: params => ({
                    action: 'wawp_search_products',
                    nonce : wawpNotifData.nonceSearchProducts,
                    q     : params.term
                }),
                processResults:data=>({results:data.results||[]}),
                cache:true
            },
            dropdownParent: $(this).closest('td'),
            width:'100%',
            closeOnSelect:false
        });
    });
}

    function initTriggerSelect2(ruleId) {
    const $sel = $('#trigger_key_' + ruleId);
    if (!$sel.length || $sel.hasClass('select2-hidden-accessible') || !$.fn.select2) { return; }

    $sel.select2({
        width: 'fit-content',
        templateResult: formatTrigger,
        templateSelection: formatTrigger,
        dropdownParent: $sel.closest('td')
    });
    


function formatTrigger(state) {
        if (!state.id) { return state.text; }  
        const iconFile = $(state.element).data('icon') || ''; 
        const $wrap    = $('<span/>');
        if (iconFile) {
            $('<img>', {
                src  : wawpNotifData.iconBaseUrl + iconFile,
                class: 'wawp-trigger-ico'
            }).appendTo($wrap);
        }
        $wrap.append(document.createTextNode(' ' + state.text));
        return $wrap;
    }
}

    $('.wawp-rule-trigger-select').each(function () {
    initTriggerSelect2($(this).data('rule-id'));
});

    $(document).on('awpNotifRuleAdded', function (e, ruleId) {
    initTriggerSelect2(ruleId);
});

    $(document).on('awpNotifRuleAdded', function(e, ruleId){
    const $pane = $('.wawp-notif-card-wrapper[data-rule-id="'+ruleId+'"]')
                .closest('.wawp-notif-tab-content');
    initCardSorting($pane);
});

    const copyLangPopup = $('#wawp-notif-copy-lang-popup');

    $(document).on('click', '.wawp-notif-copy-lang-button', function(e) {
    e.preventDefault();
    const srcLang = $(this).data('lang');
    const destSelect = copyLangPopup.find('#wawp-notif-copy-destination-lang');

    destSelect.empty(); 
    const allLangs = getConfiguredLanguages();
    let availableDestinations = 0;

    $.each(allLangs, function(code, name) {
        if (code !== srcLang) {
            destSelect.append($('<option>', { value: code, text: name }));
            availableDestinations++;
        }
    });

    if (availableDestinations > 0) {
        copyLangPopup.data('source-lang', srcLang);
        copyLangPopup.fadeIn();
    } else {
        alert('No other languages available to copy to.');
    }
});

    $('#wawp-notif-copy-lang-confirm').on('click', function() {
    const src = copyLangPopup.data('source-lang');
    const dst = copyLangPopup.find('#wawp-notif-copy-destination-lang').val();

    if (src && dst) {
        $('#wawp_notif_copy_lang_src').val(src);
        $('#wawp_notif_copy_lang_dst').val(dst);
        settingsForm[0].submit();
    }
    copyLangPopup.fadeOut();
});

    $('#wawp-notif-copy-lang-cancel').on('click', function(e) {
    e.preventDefault();
    copyLangPopup.fadeOut();
});
    copyLangPopup.on('click', function(e) {
        if ($(e.target).is(copyLangPopup)) {
            copyLangPopup.fadeOut();
        }
    });
    copyLangPopup.find('.wawp-notif-popup-inner').on('click', function(e) {
        e.stopPropagation();
    });

    function updateSenderFields(ruleId) {
        const $dropdown = $(`#sender_type_${ruleId}`);
        if (!$dropdown.length) return;
        const chosen = $dropdown.val();
        const $wrapper = $(`.wawp-notif-card-wrapper[data-rule-id="${ruleId}"]`);

        $wrapper.find('.status-item-wrapper').hide(); 
        const userPart = chosen.includes('user');
        const adminPart = chosen.includes('admin');
        const waChannel = chosen.includes('whatsapp');
        const emailChannel = chosen.includes('email');
        const metaChannel = chosen.includes('meta');

        const userWhatsAppActive  = userPart && waChannel;
        const userEmailActive     = userPart && emailChannel;
        const userMetaActive      = userPart && metaChannel;
        const adminWhatsAppActive = adminPart && waChannel;
        const adminEmailActive    = adminPart && emailChannel;
        const adminMetaActive     = adminPart && metaChannel;

        if (userWhatsAppActive)  $wrapper.find('.status-item-wrapper[data-status-type="user_whatsapp"]').show();
        if (userEmailActive)     $wrapper.find('.status-item-wrapper[data-status-type="user_email"]').show();
        if (userMetaActive)      $wrapper.find('.status-item-wrapper[data-status-type="user_meta_whatsapp"]').show();
        if (adminWhatsAppActive) $wrapper.find('.status-item-wrapper[data-status-type="admin_whatsapp"]').show();
        if (adminEmailActive)    $wrapper.find('.status-item-wrapper[data-status-type="admin_email"]').show();
        if (adminMetaActive)     $wrapper.find('.status-item-wrapper[data-status-type="admin_meta_whatsapp"]').show();
        
        const $adminSelectRow = $wrapper.find(`.admin-user-row-${ruleId}`);
        if (chosen.includes('admin')) { 
            $adminSelectRow.slideDown(); initSelect2ForRule(ruleId); 
        } else {
            $adminSelectRow.slideUp();
        }
        refreshCardHeader(ruleId);
    }
    $(document).on('change', '.wawp-rule-sender-dropdown', function () {
        const ruleId = $(this).data('rule-id');
        updateSenderFields(ruleId); 
    });

    $(document).on('click', '.wawp-notif-duplicate-rule-button', function (e) {
    e.preventDefault();
    e.stopPropagation();

    const ruleId   = $(this).data('rule-id');
    const lang     = $(this).data('lang');
    const $wrapper = $('.wawp-notif-card-wrapper[data-rule-id="' + ruleId + '"]');
    const idx      = $wrapper.closest('.wawp-notif-tab-content')
                                .find('.wawp-notif-card-wrapper')
                                .index($wrapper); 

    $('#wawp_notif_duplicate_notification_rule_idx').val(idx);
    $('#wawp_notif_duplicate_notification_rule_lang').val(lang);

    $('#wawp-notif-settings-form').submit();
});

    $(document).on('change', '.wawp-rule-trigger-select', function () {
    const ruleId = $(this).data('rule-id');
    refreshFilterVisibility(ruleId);
    refreshCardHeader(ruleId);
});

    function getConfiguredLanguages () {
    if (wawpNotifData && wawpNotifData.configuredLanguages &&
        Object.keys(wawpNotifData.configuredLanguages).length) {
        return wawpNotifData.configuredLanguages;
    }
    const map = {};
    $('.wawp-notif-tab-container .nav-tab').each(function () {
        const code = $(this).attr('href').replace('#tab-', '');
        const name = $(this).text().replace('(Main)', '').trim();
        map[code] = name;
    });
    return map;
}
    $(document).on('click', '.wawp-notif-remove-rule-button', function(e) {
        e.preventDefault();
        e.stopPropagation();
        const ruleId = $(this).data('rule-id');
        const lang   = $(this).data('lang');
        const $wrapper = $(`.wawp-notif-card-wrapper[data-rule-id="${ruleId}"]`);
        const $tabPane = $wrapper.closest('.wawp-notif-tab-content');
        const idx      = $tabPane.find('.wawp-notif-card-wrapper').index($wrapper);
        const triggerText = $wrapper.find('.wawp-rule-trigger-select option:selected').text().trim() || 'this trigger';

        if (confirm(`Are you sure you want to remove the notification rule for “${triggerText}”?`)) {
            $('#wawp_notif_remove_notification_rule_idx').val(idx);
            $('#wawp_notif_remove_notification_rule_lang').val(lang);
            settingsForm[0].submit();
        }
    });

    function refreshCardHeader(ruleId) {
    const $wrap = $(`.wawp-notif-card-wrapper[data-rule-id="${ruleId}"]`);
    if (!$wrap.length) return;

    const iconBase = wawpNotifData.iconBaseUrl;
    const $triggerOpt = $wrap.find(`#trigger_key_${ruleId} option:selected`);
    const triggerLabel = ($triggerOpt.text() || '').trim();
    const triggerIconFile = $triggerOpt.data('icon');
    const senderType = $(`#sender_type_${ruleId}`).val() || 'user_whatsapp';
    const sendTiming = $(`#send_timing_${ruleId}`).val() || 'instant';
    const $timingCell = $wrap.find(`#send_timing_${ruleId}`).closest('td');
    const delayVal = parseInt($timingCell.find('input[type="number"]').val() || 1, 10);
    const delayUnit = $timingCell.find('select[name$="[delay_unit]"]').val() || 'minutes';
    const toUser = senderType.includes('user');
    const toAdmin = senderType.includes('admin');
    const hasWA = senderType.includes('whatsapp');
    const hasEM = senderType.includes('email');
    const hasMeta = senderType.includes('meta');
    let triggerIconHtml = '';
    if (triggerIconFile) {
        triggerIconHtml = `<img class="icon-svg" src="${iconBase + triggerIconFile}" alt="${triggerLabel}" title="${triggerLabel}" />`;
    }

    let recipientIconHtml = '';
    if (toUser && toAdmin) {
        recipientIconHtml = '<i class="ri-group-line icon-svg" title="User & Admins"></i>';
    } else if (toAdmin) {
        recipientIconHtml = '<i class="ri-shield-user-line icon-svg" title="Admins Only"></i>';
    } else { 
        recipientIconHtml = '<i class="ri-user-line icon-svg" title="User Only"></i>';
    }
    let channelIconHtml = '';
    if (hasWA) {
            channelIconHtml += `<img class="icon-svg" src="${iconBase}whatsapp.svg" alt="Wawp Whatsapp" title="Wawp Whatsapp" />`;
    }
    if (hasEM) {
           channelIconHtml += `<img class="icon-svg" src="${iconBase}email.svg" alt="Email" title="Email" />`;
    }
        if (hasMeta) {
            channelIconHtml += `<img class="icon-svg" src="${iconBase}meta.svg" alt="Meta Whatsapp" title="Meta Whatsapp" />`;
    }
    if (channelIconHtml === '') {
        channelIconHtml = '<i class="ri-question-mark icon-svg" title="No channel selected"></i>';
    }

    let recipientTxt = 'User';
    if (toUser && toAdmin) recipientTxt = 'User & Admins';
    else if (toAdmin) recipientTxt = 'Admins';

    let timingTxt = 'instant';
    if (sendTiming === 'delayed') {
        const T = { delayUnits: (wawpNotifData && wawpNotifData.delayUnits) || {} };
        const unitLabel = T.delayUnits[delayUnit] || delayUnit;
        timingTxt = `After ${delayVal} ${unitLabel}`;
    }

    $wrap.find('.wawp-notif-card-header .trigger-icon').html(triggerIconHtml);
    $wrap.find('.wawp-notif-card-header .recipient-icon').html(recipientIconHtml);
    $wrap.find('.wawp-notif-card-header .channel-icon').html(channelIconHtml);
    
    $wrap.find('.wawp-notif-card-header .sendto span').text(`Send to ${recipientTxt}`);
    $wrap.find('.wawp-notif-card-header .sendtime span').text(timingTxt);
    $wrap.find('.wawp-notif-card-header h4').text(triggerLabel);
}

    $('.wawp-filter-toggle-row input[type="checkbox"]').each(function(){
    refreshFilterVisibility($(this).data('rule-id'));
});

    $(document).on('change','.wawp-filter-toggle-row input[type="checkbox"]',function(){
    refreshFilterVisibility($(this).data('rule-id'));
});
    
    function refreshFilterVisibility(ruleId) {
    const $card = $(`.wawp-notif-card-wrapper[data-rule-id="${ruleId}"]`);
    if (!$card.length) return;

    const triggerKey = $card.find('.wawp-rule-trigger-select').val() || '';

    const isWcTrigger           = triggerKey.startsWith('wc_');
    const isSubscriptionTrigger = triggerKey.startsWith('wc_sub_');
    const isOrderNoteTrigger    = (triggerKey === 'wc_order_note_added');

    const showFilters = isWcTrigger && !isSubscriptionTrigger && !isOrderNoteTrigger;

    const $imageSwitchRow      = $card.find('.wawp-product-image-switch-row');
    const $toggleRow           = $card.find('.wawp-filter-toggle-row');              
    const $toggleRowContainer  = $card.find('.wawp-filter-toggle-row-container'); 
    const $countryFilterTables = $card.find('.wawp-billing-country-whitelist-filter-table, .wawp-billing-country-blocklist-filter-table');
    const $productFilterTables = $card.find('.wawp-product-whitelist-filter-table, .wawp-product-blocklist-filter-table');
    const $paymentFilterTable  = $card.find('.wawp-payment-gateway-filter-table');

    const $wooFiltersContainer = $card.find('.awp-woo-filters');

    const isToggleEnabled = (slug) => $card.find(`input.${slug}_filter_enabled-input`).is(':checked');

    if (showFilters) {
        $imageSwitchRow.stop(true,true).slideDown();
        $toggleRowContainer.stop(true,true).slideDown(); 
        $toggleRow.stop(true,true).slideDown();
    } else {
        $imageSwitchRow.stop(true,true).slideUp();
        $toggleRowContainer.stop(true,true).slideUp(); 
        $toggleRow.stop(true,true).slideUp();
    }

    (showFilters && isToggleEnabled('country')) ? $countryFilterTables.slideDown() : $countryFilterTables.slideUp();
    (showFilters && isToggleEnabled('product')) ? $productFilterTables.slideDown() : $productFilterTables.slideUp();
    (showFilters && isToggleEnabled('payment')) ? $paymentFilterTable.slideDown()  : $paymentFilterTable.slideUp();

    const anyToggleOn = isToggleEnabled('country') || isToggleEnabled('product') || isToggleEnabled('payment');
    if (showFilters && anyToggleOn) {
        $wooFiltersContainer.stop(true,true).slideDown();
    } else {
        $wooFiltersContainer.stop(true,true).slideUp();
    }
}

    function updateActivePopupStepsForPopup() {
    if (!currentPopupRuleId) {
        console.warn("updateActivePopupStepsForPopup: currentPopupRuleId is not set");
        return;
    }
    const ruleWrapper = $(`.wawp-notif-card-wrapper[data-rule-id="${currentPopupRuleId}"]`);
    if (!ruleWrapper.length) {
        console.warn("updateActivePopupStepsForPopup: Rule wrapper not found for " + currentPopupRuleId);
        return;
    }
    const $senderSelect = ruleWrapper.find(`#sender_type_${currentPopupRuleId}`);
    if (!$senderSelect.length) {
        console.warn("updateActivePopupStepsForPopup: Sender select not found for " + currentPopupRuleId);
        return;
    }

    const senderType = $senderSelect.val();

    activePopupSteps = [];
    if (senderType.includes('user')) {
            if (senderType.includes('whatsapp')) activePopupSteps.push(1);
            if (senderType.includes('email'))    activePopupSteps.push(5);
            if (senderType.includes('meta'))     activePopupSteps.push(3);
        }
    if (senderType.includes('admin')) {
            if (senderType.includes('whatsapp')) activePopupSteps.push(2);
            if (senderType.includes('email'))    activePopupSteps.push(6);
            if (senderType.includes('meta'))     activePopupSteps.push(4);
        }
    
    const $navTabsContainer = $('#wawp-notif-edit-template-popup .navigation-tabs');
    if (activePopupSteps.length <= 1) {
        $navTabsContainer.hide();
    } else {
        $navTabsContainer.show();
        $navTabsContainer.find('button.nav-step-btn').each(function() {
            const s = parseInt($(this).data('step'), 10);
            $(this).toggle(activePopupSteps.includes(s));
        });
    }
}

    function showStepForPopup(stepToShow) {
    let targetStep = parseInt(stepToShow, 10);
    if (activePopupSteps.length > 0 && !activePopupSteps.includes(targetStep)) {
        targetStep = activePopupSteps[0];
    }
    if (activePopupSteps.length === 0) {
        targetStep = 0;
    }
    if (activePopupSteps.length === 1) {
        $('#wawp-notif-edit-template-popup .step').removeClass('active');
        $(`#wawp-notif-edit-template-popup .step.step-${activePopupSteps[0]}`)
            .addClass('active');
        $('#wawp-notif-edit-template-popup .navigation-tabs').hide();
        $('#wawp-notif-edit-template-popup .navigation-tabs').hide();
        $('#popup_finish_btn').show();
        if (activePopupSteps[0] === 1) {
            initializeEmojiOneAreaForPopup('popup_whatsapp_message');
        }
        if (activePopupSteps[0] === 2) {
            const rid = $('#popup_rule_id').val();
            const dbHtml = $(`#email_body_${rid}`).val() || '';
            setTinymceContent('popup_email_body', dbHtml);
        }
        if (activePopupSteps[0] === 3) {
            initializeEmojiOneAreaForPopup('popup_admin_whatsapp_message');
        }
        if (activePopupSteps[0] === 4) {
            setTinymceContent('popup_admin_email_body', $('#popup_admin_email_body').val() || '');
            const rid = $('#popup_rule_id').val();
            const dbHtml = $(`#admin_email_body_${rid}`).val() || '';
            setTinymceContent('popup_admin_email_body', dbHtml);
        }
        if (activePopupSteps[0] === 5) {
            initializeEmojiOneAreaForPopup('popup_whatsapp_message_meta');
        }
        if (activePopupSteps[0] === 6) {
            initializeEmojiOneAreaForPopup('popup_admin_whatsapp_message_meta');
        }
        return;
    }
    currentPopupStep = targetStep;
    $('#wawp-notif-edit-template-popup .step').removeClass('active');
    $(`#wawp-notif-edit-template-popup .step.step-${currentPopupStep}`)
        .addClass('active');
    $('#wawp-notif-edit-template-popup .navigation-tabs button.nav-step-btn')
        .removeClass('active');
    $(`#wawp-notif-edit-template-popup .navigation-tabs button[data-step="${currentPopupStep}"]`)
        .addClass('active');
    const idx        = activePopupSteps.indexOf(currentPopupStep);
    const atStart    = (idx === 0);
    const atEnd      = (idx === activePopupSteps.length - 1);
    $('#popup_finish_btn').show();
    if (currentPopupStep === 1) {
        initializeEmojiOneAreaForPopup('popup_whatsapp_message');
    }
    if (currentPopupStep === 2 && !tinymce.get('popup_email_body')) {
        const rid   = $('#popup_rule_id').val();
        const dbHtml= $('#email_body_'+rid).val() || '';
        setTinymceContent('popup_email_body', dbHtml);
    }
    if (currentPopupStep === 3) {
        initializeEmojiOneAreaForPopup('popup_admin_whatsapp_message');
    }
    if (currentPopupStep === 4 && !tinymce.get('popup_admin_email_body')) {
        const rid   = $('#popup_rule_id').val();
        const dbHtml= $('#admin_email_body_'+rid).val() || '';
        setTinymceContent('popup_admin_email_body', dbHtml);
    }
    if (currentPopupStep === 5) {
        initializeEmojiOneAreaForPopup('popup_whatsapp_message_meta');
    }
    if (currentPopupStep === 6) {
        initializeEmojiOneAreaForPopup('popup_admin_whatsapp_message_meta');
    }
}

    function populatePopupFields(ruleId, langCode, ruleIndex) {
    const ruleWrapper = $(`.wawp-notif-card-wrapper[data-rule-id="${ruleId}"]`);
    $('#popup_rule_id').val(ruleId);
    $('#popup_rule_lang').val(langCode);
    $('#popup_rule_index').val(ruleIndex);

    $('#popup_whatsapp_message').val(ruleWrapper.find(`#whatsapp_message_${ruleId}`).val() || '');
    $('#popup_whatsapp_media_url').val(ruleWrapper.find(`#whatsapp_media_url_${ruleId}`).val() || '');
    $('#popup_email_subject').val(ruleWrapper.find(`#email_subject_${ruleId}`).val() || '');
    setTinymceContent('popup_email_body', ruleWrapper.find(`#email_body_${ruleId}`).val() || '');

    $('#popup_admin_whatsapp_message').val(ruleWrapper.find(`#admin_whatsapp_message_${ruleId}`).val() || '');
    $('#popup_admin_whatsapp_media_url').val(ruleWrapper.find(`#admin_whatsapp_media_url_${ruleId}`).val() || '');
    $('#popup_admin_email_subject').val(ruleWrapper.find(`#admin_email_subject_${ruleId}`).val() || '');
    setTinymceContent('popup_admin_email_body', ruleWrapper.find(`#admin_email_body_${ruleId}`).val() || '');

    const userMetaType = ruleWrapper.find(`#meta_message_type_${ruleId}`).val() || 'text';
    $(`input[name="popup_meta_message_type"][value="${userMetaType}"]`).prop('checked', true).trigger('change');
    $('#popup_whatsapp_message_meta').val(ruleWrapper.find(`#whatsapp_message_${ruleId}`).val() || '');
    const userTemplateName = ruleWrapper.find(`#meta_template_name_${ruleId}`).val();
    const userTemplateLang = ruleWrapper.find(`#meta_template_lang_${ruleId}`).val();
    populateMetaTemplateDropdowns('popup_meta_template_name', 'popup_meta_template_lang', userTemplateName, userTemplateLang);

    const adminMetaType = ruleWrapper.find(`#admin_meta_message_type_${ruleId}`).val() || 'text';
    $('input[name="popup_admin_meta_message_type"][value="' + adminMetaType + '"]').prop('checked', true).trigger('change');
    
    $('#popup_admin_whatsapp_message_meta').val(ruleWrapper.find(`#admin_whatsapp_message_${ruleId}`).val() || '');

    const adminTemplateName = ruleWrapper.find(`#admin_meta_template_name_${ruleId}`).val();
    const adminTemplateLang = ruleWrapper.find(`#admin_meta_template_lang_${ruleId}`).val();
    populateMetaTemplateDropdowns('popup_admin_meta_template_name', 'popup_admin_meta_template_lang', adminTemplateName, adminTemplateLang);

    ['popup_whatsapp_message', 'popup_admin_whatsapp_message', 'popup_whatsapp_message_meta', 'popup_admin_whatsapp_message_meta'].forEach(id => {
        if ($(`#${id}`).data('emojioneArea')) {
            $(`#${id}`).data('emojioneArea').setText($(`#${id}`).val());
        }
    });
}

    function savePopupFields() {
    const ruleId = $('#popup_rule_id').val();
    if (!ruleId) {
        console.error("Save Error: Could not get ruleId from popup.");
        return;
    }
    const ruleWrapper = $(`.wawp-notif-card-wrapper[data-rule-id="${ruleId}"]`);
    if (!ruleWrapper.length) {
         console.error("Save Error: Could not find ruleWrapper for ruleId:", ruleId);
        return;
    }

    // --- Helper to get EmojiOneArea text safely ---
    const getEmojiText = (selector) => {
        const $el = $(selector);
        // Check if the element exists and has the emojioneArea instance
        if ($el.length && $el.data('emojioneArea')) {
            return $el.data('emojioneArea').getText();
        }
        console.warn("EmojiOneArea instance not found for selector:", selector, "Falling back to .val()");
        return $el.val(); // Fallback if not initialized or found
    };

// --- Helper to get Email Body content ---
    const getEmailBodyContent = (editorId) => {
        // Prioritize getting content from an active TinyMCE editor
        if (typeof tinymce !== 'undefined') {
             const editor = tinymce.get(editorId);
             // Check if the editor exists and is initialized
             if (editor && !editor.isHidden()) {
                 return editor.getContent();
             }
        }
        // Fallback: If TinyMCE isn't active/found, try getting value from the underlying textarea
        const $textarea = $(`#${editorId}`);
         if ($textarea.length) {
            console.warn("TinyMCE editor not found or hidden for:", editorId, ". Falling back to textarea value.");
            return $textarea.val();
         }
         console.error("Could not find TinyMCE editor or textarea for:", editorId);
         return '';
    };

    // --- Save User Fields ---
    ruleWrapper.find(`#whatsapp_message_${ruleId}`).val(getEmojiText('#popup_whatsapp_message'));
    ruleWrapper.find(`#whatsapp_media_url_${ruleId}`).val($('#popup_whatsapp_media_url').val() || ''); // Ensure empty string if null/undefined
    ruleWrapper.find(`#email_subject_${ruleId}`).val($('#popup_email_subject').val() || '');
    ruleWrapper.find(`#email_body_${ruleId}`).val(getEmailBodyContent('popup_email_body'));

    // --- Save Admin Fields ---
    ruleWrapper.find(`#admin_whatsapp_message_${ruleId}`).val(getEmojiText('#popup_admin_whatsapp_message'));
    ruleWrapper.find(`#admin_whatsapp_media_url_${ruleId}`).val($('#popup_admin_whatsapp_media_url').val() || '');
    ruleWrapper.find(`#admin_email_subject_${ruleId}`).val($('#popup_admin_email_subject').val() || '');
    ruleWrapper.find(`#admin_email_body_${ruleId}`).val(getEmailBodyContent('popup_admin_email_body'));

    // --- Save User Meta Fields ---
    const userMetaType = $('input[name="popup_meta_message_type"]:checked').val() || 'text'; // Default to text if none checked
    ruleWrapper.find(`#meta_message_type_${ruleId}`).val(userMetaType);
    if (userMetaType === 'template') {
        ruleWrapper.find(`#meta_template_name_${ruleId}`).val($('#popup_meta_template_name').val() || '');
        ruleWrapper.find(`#meta_template_lang_${ruleId}`).val($('#popup_meta_template_lang').val() || '');
        // NOTE: The whatsapp_message field keeps the value from the Web WA tab when template is selected.
    } else { // 'text'
        // Assuming Meta text uses the same content as Web WA text, which is already saved above.
        // Clear template fields if type is 'text'
         ruleWrapper.find(`#meta_template_name_${ruleId}`).val('');
         ruleWrapper.find(`#meta_template_lang_${ruleId}`).val('');
    }

    // --- Save Admin Meta Fields ---
     const adminMetaType = $('input[name="popup_admin_meta_message_type"]:checked').val() || 'text';
     ruleWrapper.find(`#admin_meta_message_type_${ruleId}`).val(adminMetaType);
     if (adminMetaType === 'template') {
        ruleWrapper.find(`#admin_meta_template_name_${ruleId}`).val($('#popup_admin_meta_template_name').val() || '');
        ruleWrapper.find(`#admin_meta_template_lang_${ruleId}`).val($('#popup_admin_meta_template_lang').val() || '');
        // NOTE: The admin_whatsapp_message field keeps the value from the Web WA tab.
     } else { // 'text'
        // Assuming Admin Meta text uses the same content as Admin Web WA text, saved above.
         // Clear template fields if type is 'text'
         ruleWrapper.find(`#admin_meta_template_name_${ruleId}`).val('');
         ruleWrapper.find(`#admin_meta_template_lang_${ruleId}`).val('');
     }

     // Update status indicators on the main form card immediately for better feedback
     updateTemplateStatusIndicators(ruleId);

     console.log("Saved popup data for rule:", ruleId); // Add console log for confirmation
}

function updateTemplateStatusIndicators(ruleId) {
    const $wrapper = $(`.wawp-notif-card-wrapper[data-rule-id="${ruleId}"]`);
    if (!$wrapper.length) return;

    const checkIcon = '<i class="ri-checkbox-circle-fill" style="color:#0b7;"></i> ';
    const crossIcon = '<i class="ri-close-circle-fill" style="color:#dc3545;"></i> ';

    // Update User WA Web Status
    const userWaMsg = $wrapper.find(`#whatsapp_message_${ruleId}`).val();
    const $userWaStatus = $wrapper.find('.wawp-template-status[data-type="user_whatsapp"]');
    $userWaStatus.html(userWaMsg ? checkIcon + wawpNotifData.textWhatsAppTemplateSet : crossIcon + wawpNotifData.textWhatsAppNotSet);

    // Update User Email Status
    const userEmailSub = $wrapper.find(`#email_subject_${ruleId}`).val();
    const userEmailBody = $wrapper.find(`#email_body_${ruleId}`).val();
    const $userEmailStatus = $wrapper.find('.wawp-template-status[data-type="user_email"]');
    $userEmailStatus.html(userEmailSub && userEmailBody ? checkIcon + wawpNotifData.textEmailTemplateSet : crossIcon + wawpNotifData.textEmailNotSet);

    // Update Admin WA Web Status
    const adminWaMsg = $wrapper.find(`#admin_whatsapp_message_${ruleId}`).val();
    const $adminWaStatus = $wrapper.find('.wawp-template-status[data-type="admin_whatsapp"]');
    $adminWaStatus.html(adminWaMsg ? checkIcon + wawpNotifData.textAdminWhatsAppTemplateSet : crossIcon + wawpNotifData.textAdminWhatsAppNotSet);

    // Update Admin Email Status
    const adminEmailSub = $wrapper.find(`#admin_email_subject_${ruleId}`).val();
    const adminEmailBody = $wrapper.find(`#admin_email_body_${ruleId}`).val();
    const $adminEmailStatus = $wrapper.find('.wawp-template-status[data-type="admin_email"]');
    $adminEmailStatus.html(adminEmailSub && adminEmailBody ? checkIcon + wawpNotifData.textAdminEmailTemplateSet : crossIcon + wawpNotifData.textAdminEmailNotSet);

     // Update User Meta Status (Simplified: checks if *either* text or template is set)
     const userMetaType = $wrapper.find(`#meta_message_type_${ruleId}`).val();
     const userMetaTpl = $wrapper.find(`#meta_template_name_${ruleId}`).val();
     const isUserMetaSet = (userMetaType === 'template' && userMetaTpl) || (userMetaType === 'text' && userWaMsg); // Re-use userWaMsg for text check
     const $userMetaStatus = $wrapper.find('.wawp-template-status[data-type="user_meta_whatsapp"]');
     $userMetaStatus.html(isUserMetaSet ? checkIcon + 'User Whatsapp (Meta)' : crossIcon + 'User Whatsapp (Meta)');

     // Update Admin Meta Status (Simplified)
     const adminMetaType = $wrapper.find(`#admin_meta_message_type_${ruleId}`).val();
     const adminMetaTpl = $wrapper.find(`#admin_meta_template_name_${ruleId}`).val();
     const isAdminMetaSet = (adminMetaType === 'template' && adminMetaTpl) || (adminMetaType === 'text' && adminWaMsg); // Re-use adminWaMsg for text check
     const $adminMetaStatus = $wrapper.find('.wawp-template-status[data-type="admin_meta_whatsapp"]');
     $adminMetaStatus.html(isAdminMetaSet ? checkIcon + 'Admin Whatsapp (Meta)' : crossIcon + 'Admin Whatsapp (Meta)');

}

    $(document).on('click', '.wawp-notif-edit-button', function (e) {
        e.preventDefault();
        e.stopPropagation();
    
        currentPopupRuleId = $(this).data('rule-id');
        const langCode     = $(this).data('lang');
        const $ruleCard    = $(`.wawp-notif-card-wrapper[data-rule-id="${currentPopupRuleId}"]`);
        const ruleIndex    = $ruleCard.data('idx');
        
        openCardAndScroll($ruleCard);
    
        populatePopupFields(currentPopupRuleId, langCode, ruleIndex);
        updateActivePopupStepsForPopup();
        showStepForPopup(activePopupSteps.length ? activePopupSteps[0] : 0);
    
    const titleText   = ($ruleCard.find('.wawp-notif-card-header h4').text() || '').trim();
    const sendToTxt   = ($ruleCard.find('.wawp-notif-card-header .sendto span').text() || '').trim();
    const sendTimeTxt = ($ruleCard.find('.wawp-notif-card-header .sendtime span').text() || '').trim();
    const triggerIco  = $ruleCard.find('.wawp-notif-card-header .trigger-icon').html() || '';
    const channelIco  = $ruleCard.find('.wawp-notif-card-header .channel-icon').html() || '';
    
    const popupHeaderHtml = `
      <div class="notif-header">
        <div class="icons-group">
          <div class="trigger-icon">${triggerIco}</div>
          <i class="ri-arrow-right-s-line"></i>
          <div class="channel-icon">${channelIco}</div>
        </div>
        <div class="notif-header-info">
          <h4 style="line-height: 1;">${titleText}</h4>
          <div class="trigger-badges">
            <div class="trigger-badge sendto"><i class="ri-contacts-line"></i><span>${sendToTxt}</span></div>
            <div class="trigger-badge sendtime"><i class="ri-time-line"></i><span>${sendTimeTxt}</span></div>
          </div>
        </div>
      </div>
    `;
    
    $('#wawp-popup-rule-header').html(popupHeaderHtml);
    
    
        editTplPopup.fadeIn();
    });
    $('#popup_cancel_btn').on('click', function() {
        editTplPopup.fadeOut();
        currentPopupRuleId = null;
    });
    $('#popup_finish_btn').on('click', function() {
    savePopupFields();

    if (currentPopupRuleId) {
        $('#wawp_active_rule_id').val(String(currentPopupRuleId));
        try { sessionStorage.setItem('wawp_active_rule_id', String(currentPopupRuleId)); } catch(e) {}
    }

    editTplPopup.fadeOut();
    currentPopupRuleId = null;
    settingsForm[0].submit();
    });

    $('#wawp-notif-edit-template-popup').on('click', function(e) {
        if ($(e.target).is('#wawp-notif-edit-template-popup')) {
            e.preventDefault();
            editTplPopup.fadeOut();
            currentPopupRuleId = null; 
        }
    });
    
    $('#wawp-notif-edit-template-popup .wawp-notif-popup-inner').on('click', function(e) {
        e.stopPropagation();
    });

    $('#wawp-notif-edit-template-popup .navigation-tabs').on('click', '.nav-step-btn', function(e) {
        e.preventDefault(); 
    const stepToJump = parseInt($(this).data('step'));
        if (activePopupSteps.includes(stepToJump)) {
        showStepForPopup(stepToJump);
        }
        return false; 
    });

    function initCardSorting ( $tabPane ) {
    if (typeof $.fn.sortable !== 'function') { return; }
        $tabPane.sortable({
            items:              '.wawp-notif-card-wrapper',
            handle:             '.wawp-notif-card-header',
            placeholder:        'wawp-card-placeholder',
            forcePlaceholderSize: true,
            tolerance:          'pointer',
            start:  function(e, ui){ ui.placeholder.height(ui.item.outerHeight()); },
            update: function(e, ui){ renumberCards($tabPane); }
        });
    }
    
    function renumberCards ( $pane ) {
        $pane.find('.wawp-notif-card-wrapper').each(function(idx){
            const rid = $(this).data('rule-id');
            refreshCardHeader(rid);
            $(this).find('.wawp-sort-order').val(idx);
        });
    }

    function runInitializations() {
        toggleLangTabsVisibility();
        initializeEmojiOneArea();
        initCountryGatewaySelect2(document);
        initProductSelect2(document);

        $('.wawp-notif-send-timing-select').each(function() { toggleDelayFields(this); });
        $('.wawp-rule-sender-dropdown').each(function() { updateSenderFields($(this).data('rule-id')); });
        
        $('.wawp-admin-user-select').each(function() { initSelect2ForRule($(this).data('rule-id')); });
        
        $('.wawp-notif-card-wrapper').each(function() {
            const ruleId = $(this).data('rule-id');
            if (ruleId) {
             
                if (!$(this).find('.wawp-notif-card-header i[class*="ri-arrow-"]').length) {
                    $(this).find('.wawp-notif-card-header').append('<i class="ri-arrow-down-s-line"></i>');
                }
                if (!$(this).hasClass('expanded') && !$(this).hasClass('collapsed')) {
                        $(this).addClass('collapsed');
                } else if ($(this).hasClass('expanded')) {
                        toggleCardContent($(this), true);
                } else {
                        toggleCardContent($(this), false);
                }

                refreshCardHeader(ruleId);
                
                initCardSorting( $(this).closest('.wawp-notif-tab-content') );
                $(this).find('.wawp-rule-trigger-select').trigger('change');
            }
        });
        
        const $mainSaveButton = $('#save_settings_button');
        if ($mainSaveButton.length && !$mainSaveButton.find('i.ri-save-line').length) {
            $mainSaveButton.html('<i class="ri-save-line"></i> ' + $mainSaveButton.text());
        }
    }

    runInitializations();
    $(document.body).on('post-load', function() { 
        runInitializations();
    });

    window.wawpNotifData = $.extend({
        textWhatsAppTemplateSet: 'WhatsApp Template Set',
        textWhatsAppNotSet: 'WhatsApp Not Set',
        textEmailTemplateSet: 'Email Template Set',
        textEmailNotSet: 'Email Not Set',
        textAdminWhatsAppTemplateSet: 'Admin WhatsApp Set',
        textAdminWhatsAppNotSet: 'Admin WhatsApp Not Set',
        textAdminEmailTemplateSet: 'Admin Email Set',
        textAdminEmailNotSet: 'Admin Email Not Set',
        textWhen: 'When',
        textRule: 'Rule'  
    }, wawpNotifData || {});

    let cardWasOpened = false;
    const activeRuleIdOnLoad = wawpNotifData.activeRuleId || sessionStorage.getItem('wawp_active_rule_id');
    if (activeRuleIdOnLoad) {
        const $cardToOpen = $('.wawp-notif-card-wrapper[data-rule-id="' + activeRuleIdOnLoad + '"]');
        if ($cardToOpen.length) {
            setTimeout(function() {
                openCardAndScroll($cardToOpen);
            }, 150);
            cardWasOpened = true;
        }
    }
    if (!cardWasOpened && $('#wawp_active_tab').val().indexOf('#tab-') === 0) {
        const $cardsInActiveTab = $('.wawp-notif-tab-content.active .wawp-notif-card-wrapper');
        const $lastCard = $cardsInActiveTab.last();
        if ($lastCard.length) {
            const triggerKey = $lastCard.find('.wawp-rule-trigger-select').val();
            if (triggerKey === 'user_login') { 
                setTimeout(function() {
                    openCardAndScroll($lastCard);
                }, 150);
            }
        }
    }

    function populateMetaTemplateDropdowns(nameSelectId, langSelectId, selectedName, selectedLang) {
        const $nameSelect = $(`#${nameSelectId}`);
        const $langSelect = $(`#${langSelectId}`);
        const templates = wawpNotifData.metaTemplates || {};

        $nameSelect.empty().append($('<option>', { value: '', text: '-- Select Template --' }));
        
        $.each(templates, function(templateName, languages) {
            $nameSelect.append($('<option>', { value: templateName, text: templateName }));
        });

        $nameSelect.val(selectedName).trigger('change');
        updateMetaLangDropdown(nameSelectId, langSelectId, selectedLang);
    }

    function updateMetaLangDropdown(nameSelectId, langSelectId, selectedLang) {
        const selectedTemplate = $(`#${nameSelectId}`).val();
        const $langSelect = $(`#${langSelectId}`);
        const templates = wawpNotifData.metaTemplates || {};

        $langSelect.empty();
        if (selectedTemplate && templates[selectedTemplate]) {
            $.each(templates[selectedTemplate], function(i, langCode) {
                $langSelect.append($('<option>', { value: langCode, text: langCode }));
            });
            $langSelect.val(selectedLang);
        } else {
            $langSelect.append($('<option>', { value: '', text: '-- Select Template First --' }));
        }
    }

    $(document).on('change', 'input[name="popup_meta_message_type"], input[name="popup_admin_meta_message_type"]', function() {
        const type = $(this).val();
        const isAdmin = $(this).attr('name').includes('admin');
        const textFields = isAdmin ? '.admin-meta-type-text' : '.meta-type-text';
        const templateFields = isAdmin ? '.admin-meta-type-template' : '.meta-type-template';

        if (type === 'template') {
            $(this).closest('.step').find(textFields).hide();
            $(this).closest('.step').find(templateFields).show();
        } else {
            $(this).closest('.step').find(textFields).show();
            $(this).closest('.step').find(templateFields).hide();
        }
    });

    $(document).on('change', '#popup_meta_template_name', function() {
        updateMetaLangDropdown('popup_meta_template_name', 'popup_meta_template_lang', null);
    });
    $(document).on('change', '#popup_admin_meta_template_name', function() {
        updateMetaLangDropdown('popup_admin_meta_template_name', 'popup_admin_meta_template_lang', null);
    });

});
