jQuery(document).ready(function($) {
    // Ensure wawpAcNotifications object is available before running the main logic
    if (typeof wawpAcNotifications === 'undefined') {
        console.error('wawpAcNotifications data is not defined. Aborting script.');
        return;
    }

    // Function to get a notification card template dynamically
    function getNotificationCardHTML(type, index) {
        const i18n = wawpAcNotifications.i18n;
        let html = `
        <div class="notification-card postbox closed">
            <div class="postbox-header">
                <h2 class="hndle">
                    <span>${i18n.step} ${index + 1}</span>
                </h2>
                <div class="handle-actions">
                    <label class="awp-switch">
                        <input type="hidden" name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][enable]" value="0" />
                        <input type="checkbox" class="wawp-rule-enable-switch" name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][enable]" value="1" checked />
                        <span class="awp-slider"></span>
                    </label>
                    <button type="button" class="handlediv" aria-expanded="false"><span class="screen-reader-text">${i18n.toggle_panel}</span><span class="toggle-indicator" aria-hidden="true"></span></button>
                </div>
            </div>
            <div class="inside">
                <div class="wawp-notif-card-content">
                    ${wawpAcNotifications.is_coupon_enabled ? `
                    <table class="form-table">
                        <tr valign="top">
                            <th scope="row"><label><i class="ri-coupon-3-line"></i> ${i18n.attach_coupon}</label></th>
                            <td>
                                <div class="btn-group">
                                    <label class="awp-switch">
                                        <input type="hidden" name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][use_coupon]" value="0" />
                                        <input type="checkbox" name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][use_coupon]" value="1" />
                                        <span class="awp-slider"></span>
                                    </label>
                                    <p class="description" style="display: inline-block; margin-left: 10px;">${i18n.coupon_desc}</p>
                                </div>
                            </td>
                        </tr>
                    </table>` : ''}
                    <table class="form-table">
                        <tr valign="top">
                            <th scope="row">
                                <label><i class="ri-time-line"></i> ${i18n.waiting_time}</label>
                            </th>
                            <td>
                                <select name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][send_timing]" class="wawp-notif-send-timing-select">
                                    <option value="instant">${i18n.send_instantly_desc}</option>
                                    <option value="delayed">${i18n.send_after}</option>
                                </select>
                                <div class="delay-fields" style="display:none;">
                                    <input type="number" name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][delay_value]" value="1" min="1" style="width:70px;" />
                                    <select name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][delay_unit]">
                                        <option value="minutes">${i18n.minutes}</option>
                                        <option value="hours">${i18n.hours}</option>
                                        <option value="days">${i18n.days}</option>
                                    </select>
                                </div>
                            </td>
                        </tr>
                        <tr valign="top">
                            <th scope="row">
                                <label><i class="ri-send-plane-line"></i> ${i18n.send_via}</label>
                            </th>
                            <td>
                                <select name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][send_via][]" class="wac-send-via-select" multiple="multiple" style="width:100%;">
                                    ${wawpAcNotifications.is_wawp_active ? `<option value="wawp_whatsapp" selected>${i18n.wawp_whatsapp}</option>` : ''}
                                    ${wawpAcNotifications.is_meta_active ? `<option value="meta_whatsapp">${i18n.meta_whatsapp}</option>` : ''}
                                    <option value="email">${i18n.email}</option>
                                </select>
                            </td>
                        </tr>
                    </table>

                    <div class="channel-fields-wrapper">
                        <div class="wawp-setting-card channel-fields" data-channel="wawp_whatsapp">
                            <div class="wawp-setting-header awp-toggle-switch">
                                <div class="card-header">
                                    <div class="card-title"><i class="ri-whatsapp-line"></i> ${i18n.wawp_wa_message}</div>
                                </div>
                                <div class="btn-group"><i class="ri-arrow-down-s-line toggled-arrow"></i></div>
                            </div>
                            <div class="wawp-setting-content" style="display: none;">
                                <textarea name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][whatsapp_message]" rows="5" class="large-text wawp-emojione-editor"></textarea>
                                <div class="placeholder-buttons"></div>
                            </div>
                        </div>
                        <div class="wawp-setting-card channel-fields" data-channel="meta_whatsapp" style="display:none;">
                                <div class="wawp-setting-header awp-toggle-switch">
                                    <div class="card-header">
                                        <div class="card-title"><i class="ri-meta-line"></i> ${i18n.meta_wa_template}</div>
                                    </div>
                                    <div class="btn-group"><i class="ri-arrow-down-s-line toggled-arrow"></i></div>
                                </div>
                            <div class="wawp-setting-content" style="display: none;">
                                    <select name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][meta_template]">
                                        <option value="">${i18n.select_template}</option>
                                        ${(wawpAcNotifications.meta_templates || []).map(t => `<option value="${t.template_name}|${t.language_code}">${t.template_name} (${t.language_code})</option>`).join('')}
                                    </select>
                            </div>
                        </div>
                        <div class="wawp-setting-card channel-fields" data-channel="email" style="display:none;">
                            <div class="wawp-setting-header awp-toggle-switch">
                                <div class="card-header">
                                    <div class="card-title"><i class="ri-mail-line"></i> ${i18n.email_body}</div>
                                </div>
                                <div class="btn-group"><i class="ri-arrow-down-s-line toggled-arrow"></i></div>
                            </div>
                            <div class="wawp-setting-content" style="display: none;">
                                <p><label for="wawp_${type}_${index}_email_subject">${i18n.email_subject}</label></p>
                                <input type="text" id="wawp_${type}_${index}_email_subject" name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][email_subject]" class="regular-text" />
                                <p style="margin-top: 1em;"><label for="wawp_${type}_${index}_email_body">${i18n.email_body}</label></p>
                                <textarea name="wawp_abandoned_cart_notification_settings[${type}][notifications][${index}][email_body]" rows="10" id="wawp_${type}_${index}_email_body" class="large-text"></textarea>
                                <div class="placeholder-buttons"></div>
                            </div>
                        </div>
                        <button type="button" class="awp-btn delete-plain button-link-delete remove-notification-step" style="align-self: end;">${i18n.remove_step}</button>
                    </div>
                </div>
            </div>
        </div>`;
        return html;
    }

    function populatePlaceholders(card) {
        if (wawpAcNotifications && wawpAcNotifications.placeholders) {
            let buttonsHtml = '<div class="placeholder-dropdown-wrapper"><select class="placeholder-dropdown"><option value="">'+wawpAcNotifications.i18n.insert_placeholder+'</option>';
            $.each(wawpAcNotifications.placeholders, function(placeholder, desc) {
                buttonsHtml += `<option value="${placeholder}">${desc}</option>`;
            });
            buttonsHtml += '</select></div>';
            card.find('.placeholder-buttons').html(buttonsHtml);
        }
    }

    function initializeEmojiPicker(element) {
        if (element.length > 0 && !element.data('emojioneArea')) {
            element.emojioneArea({
                pickerPosition: 'bottom',
                tonesStyle: 'bullet'
            });
        }
    }

    function updateChannelVisibility(card) {
        const selectedChannels = card.find('.wac-send-via-select').val() || [];
        card.find('.channel-fields').hide();
        selectedChannels.forEach(function(channel) {
            card.find(`.channel-fields[data-channel="${channel}"]`).show();
        });
    }

    function updateDelayVisibility(card) {
        const timing = card.find('.wawp-notif-send-timing-select').val();
        if (timing === 'delayed') {
            card.find('.delay-fields').css('display', 'flex');
        } else {
            card.find('.delay-fields').hide();
        }
    }

    // Add notification step
    $(document).on('click', '.add-notification-step', function() {
        const type = $(this).data('type');
        const wrapper = $('#wawp-ac-' + type + '-wrapper');
        const newIndex = wrapper.find('.notification-card').length;
        const newCardHTML = getNotificationCardHTML(type, newIndex);
        const newCard = $(newCardHTML);
        
        wrapper.append(newCard);
        
        newCard.find('.wac-send-via-select').select2({
            placeholder: 'Select channels',
            width: '100%'
        });

        populatePlaceholders(newCard);
        updateChannelVisibility(newCard);
        updateDelayVisibility(newCard);
        initializeEmojiPicker(newCard.find('.wawp-emojione-editor'));

        const newEditorId = `wawp_${type}_${newIndex}_email_body`;
        if (typeof wp.editor !== 'undefined') {
            wp.editor.initialize(newEditorId, {
                tinymce: {
                    wpautop: true,
                    plugins : 'charmap,colorpicker,hr,lists,media,paste,tabfocus,textcolor,fullscreen,wordpress,wpautoresize,wpeditimage,wpemoji,wpgallery,wplink,wpdialogs,wpview',
                    toolbar1: 'bold,italic,strikethrough,bullist,numlist,blockquote,hr,alignleft,aligncenter,alignright,link,unlink,wp_more,spellchecker,fullscreen,wp_adv',
                    toolbar2: 'formatselect,underline,alignjustify,forecolor,pastetext,removeformat,charmap,outdent,indent,undo,redo,wp_help'
                },
                quicktags: true,
                mediaButtons: false
            });
        }
    });

    // Remove notification step
    $(document).on('click', '.remove-notification-step', function() {
        if (confirm('Are you sure you want to remove this notification step?')) {
            const card = $(this).closest('.notification-card');
            const wrapper = card.closest('.notification-sequence-wrapper');
            const type = wrapper.attr('id').replace('wawp-ac-', '').replace('-wrapper', '');
            
            card.remove();

            wrapper.find('.notification-card').each(function(index) {
                $(this).find('input, select, textarea').each(function() {
                    const name = $(this).attr('name');
                    if (name) {
                        const newName = name.replace(/\[notifications\]\[\d+\]/, `[notifications][${index}]`);
                        $(this).attr('name', newName);
                        
                        if ($(this).attr('id') && $(this).attr('id').includes('email_body')) {
                            const oldId = $(this).attr('id');
                            const newId = `wawp_${type}_${index}_email_body`;
                            if (typeof tinymce !== 'undefined' && tinymce.get(oldId)) {
                                tinymce.get(oldId).remove();
                            }
                            $(this).attr('id', newId);
                            if (typeof wp.editor !== 'undefined') {
                                wp.editor.initialize(newId, { tinymce: true, quicktags: true });
                            }
                        }
                    }
                });
                $(this).find('h2.hndle span').first().text(`${wawpAcNotifications.i18n.step} ${index + 1}`);
            });
        }
    });

    // Handle channel visibility change
    $(document).on('change', '.wac-send-via-select', function() {
        const card = $(this).closest('.notification-card');
        updateChannelVisibility(card);
    });
    
    // Handle delay visibility change
    $(document).on('change', '.wawp-notif-send-timing-select', function() {
        const card = $(this).closest('.notification-card');
        updateDelayVisibility(card);
    });

    // Copy placeholder to textarea from dropdown
    $(document).on('change', '.placeholder-dropdown', function() {
        const placeholder = $(this).val();
        if (!placeholder) return;

        const container = $(this).closest('.wawp-setting-content');
        const targetTextarea = container.find('textarea');
        const editorId = targetTextarea.attr('id');
        const emojioneEditorDiv = container.find('.emojionearea-editor');

        if (typeof tinymce !== 'undefined' && tinymce.get(editorId)) {
            tinymce.get(editorId).execCommand('mceInsertContent', false, placeholder);
        } else if (emojioneEditorDiv.length > 0 && emojioneEditorDiv[0].emojioneArea) {
            emojioneEditorDiv[0].emojioneArea.insert(placeholder, 'end');
        } else if (targetTextarea.length > 0) {
            const currentVal = targetTextarea.val();
            const cursorPos = targetTextarea[0].selectionStart;
            const newVal = currentVal.substring(0, cursorPos) + placeholder + currentVal.substring(cursorPos);
            targetTextarea.val(newVal).focus();
            targetTextarea[0].selectionStart = cursorPos + placeholder.length;
            targetTextarea[0].selectionEnd = cursorPos + placeholder.length;
        }
        $(this).val(''); // Reset dropdown
    });

    // ====================================================================
    // ## START OF FIX ##
    // ====================================================================

$(document).on('click', '.wawp-setting-header.awp-toggle-switch', function(e) {
    e.stopPropagation(); // Prevents this click from triggering handlers on parent elements
    $(this).next('.wawp-setting-content').slideToggle(200);
    $(this).find('.toggled-arrow').toggleClass('open');
});

// NEW HANDLER: Accordion for main postbox (the notification steps)
// This is more specific and robust, preventing conflicts.
$(document).on('click', '.notification-card .postbox-header', function(e) {
    // Prevent clicks on the enable/disable switch (or its label) from toggling the accordion
    if ($(e.target).closest('.awp-switch').length) {
        return;
    }
    e.stopPropagation(); // Prevent this click from bubbling up to other handlers
    $(this).closest('.notification-card').toggleClass('closed');
});

// ====================================================================
// ## END OF FIX ##
// ====================================================================
// ==> ADD THE CODE BEFORE THIS LINE:
initializeCards();

    // ====================================================================
    // ## END OF FIX ##
    // ====================================================================

    // Initial setup for existing cards on page load
    function initializeCards() {
        $('.notification-card').each(function() {
            const card = $(this);
            
            card.find('.wac-send-via-select').select2({
                placeholder: 'Select channels',
                width: '100%'
            });
            
            populatePlaceholders(card);
            updateChannelVisibility(card);
            updateDelayVisibility(card);
            initializeEmojiPicker(card.find('.wawp-emojione-editor'));
        });
    }
    
    initializeCards();
});