jQuery(document).ready(function($) {
    // Select all checkbox functionality
    $("#wac_select_all").on("change", function() {
        $("input[name='wac_clear_ids[]']").prop("checked", $(this).prop("checked"));
    });

    // History Modal functionality
    var historyModal = $('#wac-history-modal');
    var historyContent = $('#wac-history-content');
    var modalCloseButtons = $('.wac-modal-close');

    // Open History Modal
    $('body').on('click', '.wac-history-link', function(e) {
        e.preventDefault();
        var dataHistory = $(this).data('history'); // Data attribute already contains HTML
        historyContent.html(dataHistory);
        historyModal.css('display', 'flex'); // Use flex to center
    });

    // Open Cart Details Modal
    var cartDetailsModal = $('#wac-cart-details-modal');
    var cartDetailsContent = $('#wac-cart-details-content');

    $('body').on('click', '.wac-view-cart-details', function(e) {
        e.preventDefault();
        var cartDetails = $(this).data('cart-details'); // This will be an array of objects
        var htmlContent = '';
        if (Array.isArray(cartDetails) && cartDetails.length > 0) {
            cartDetails.forEach(function(item) {
                htmlContent += `
                    <div class="wac-cart-item">
                        <img src="${item.image_src}" alt="${item.image_alt}" />
                        <div class="wac-item-details">
                            <a href="${item.link}" target="_blank">${item.name}</a>
                            <p>Quantity: ${item.qty}</p>
                            <p>Price: ${item.price}</p>
                        </div>
                    </div>
                `;
            });
        } else {
            htmlContent = '<p>No detailed cart contents available.</p>';
        }
        cartDetailsContent.html(htmlContent);
        cartDetailsModal.css('display', 'flex'); // Use flex to center
    });

    // Close Modals
    modalCloseButtons.on('click', function() {
        $(this).closest('.wac-modal').css('display', 'none');
    });

    // Close modal when clicking outside of the modal content
    $(window).on('click', function(event) {
        if ($(event.target).is(historyModal)) {
            historyModal.css('display', 'none');
        }
        if ($(event.target).is(cartDetailsModal)) {
            cartDetailsModal.css('display', 'none');
        }
    });

    // Accordion for settings cards
    $('.wawp-setting-header.awp-toggle-switch').on('click', function() {
        $(this).next('.wawp-setting-content').slideToggle(200);
        $(this).find('.toggled-arrow').toggleClass('open');
    });
    
    
    // ==> ADD THIS ENTIRE BLOCK TO THE END OF THE FILE

// Logic to show/hide the "Clear Selected" button
const clearSelectedBtn = $('#wac-clear-selected');
const rowCheckboxes = $('.wac-clear-id-checkbox');
const selectAllCheckbox = $('#wac_select_all');

// A function to check how many boxes are checked and toggle the button
function toggleClearSelectedButton() {
    // Count only the individual row checkboxes that are checked
    const checkedCount = $('.wac-clear-id-checkbox:checked').length;
    
    if (checkedCount > 0) {
        clearSelectedBtn.css('display', 'flex');   // was .show()
    } else {
        clearSelectedBtn.css('display', 'none');   // was .hide()
    }
}

// Run the check when any checkbox state changes
$('body').on('change', '.wac-clear-id-checkbox, #wac_select_all', function() {
    toggleClearSelectedButton();
});

// Run the check once on page load to hide the button initially
toggleClearSelectedButton();
    // ==> ADD THIS ENTIRE BLOCK TO THE END OF THE FILE

// Live Search for the Abandoned Carts table
const searchInput = $('#awp-live-search');
const tableRows = $('.awp-table tbody tr');

searchInput.on('keyup', function() {
    const searchTerm = $(this).val().toLowerCase().trim();

    tableRows.each(function() {
        const row = $(this);
        const rowText = row.text().toLowerCase();

        // If the row text includes the search term, show it, otherwise hide it
        if (rowText.includes(searchTerm)) {
            row.show();
        } else {
            row.hide();
        }
    });
});
// ==> ADD THIS ENTIRE BLOCK TO THE END OF THE FILE

// Logic for the "Where to Show Popup" setting
const popupWhereRadios = $('input[name="wawp_abandoned_cart_settings[popup_where]"]');
const excludePagesWrapper = $('.wawp-exclude-pages-wrapper');

function toggleExcludePagesField() {
    if (popupWhereRadios.filter(':checked').val() === 'exclude') {
        excludePagesWrapper.slideDown(200);
    } else {
        excludePagesWrapper.slideUp(200);
    }
}

// Check on page load
toggleExcludePagesField();

// Check when a radio button is changed
popupWhereRadios.on('change', function() {
    toggleExcludePagesField();
});

});
